/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Variable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableArrayAccessTypeAnalyzer
extends PhpArrayAccessTypeAnalyzer {
    @NotNull
    private final CharSequence myVariableName;

    public PhpVariableArrayAccessTypeAnalyzer(@NotNull CharSequence variableName, @Nullable PsiElement key) {
        if (variableName == null) {
            PhpVariableArrayAccessTypeAnalyzer.$$$reportNull$$$0(0);
        }
        super(key);
        this.myVariableName = variableName;
    }

    @Override
    protected boolean isSameValue(PhpArrayAccessInstruction curInstruction) {
        return PhpLangUtil.equalsVariableNames(this.myVariableName, curInstruction.getVariableName());
    }

    @Override
    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        if (PhpLangUtil.equalsVariableNames(this.myVariableName, instruction.getVariableName()) && this.elementOverwritten(instruction.getAccess(), (PsiElement)instruction.getAnchor())) {
            this.handlePreliminaryTraversalEnd();
            return false;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    @Override
    @NotNull
    protected PhpArrayAccessTypeDFAnalyzer createAnalyzer(@Nullable PsiElement key) {
        return new PhpVariableArrayAccessTypeDFAnalyzer(this.myVariableName, key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/jetbrains/php/codeInsight/typeInference/PhpVariableArrayAccessTypeAnalyzer", "<init>"));
    }

    private static final class PhpVariableArrayAccessTypeDFAnalyzer
    extends PhpArrayAccessTypeDFAnalyzer {
        @NotNull
        private final CharSequence myVariableName;

        private PhpVariableArrayAccessTypeDFAnalyzer(@NotNull CharSequence variableName, @Nullable PsiElement key) {
            if (variableName == null) {
                PhpVariableArrayAccessTypeDFAnalyzer.$$$reportNull$$$0(0);
            }
            super(key);
            this.myVariableName = variableName;
        }

        @Override
        protected boolean isSameArrayValue(PsiElement arrayValue) {
            return arrayValue instanceof Variable && PhpLangUtil.equalsVariableNames(this.myVariableName, ((Variable)arrayValue).getNameCS());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/jetbrains/php/codeInsight/typeInference/PhpVariableArrayAccessTypeAnalyzer$PhpVariableArrayAccessTypeDFAnalyzer", "<init>"));
        }
    }
}

