/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCaseConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpBaseCaseConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionWithInversedEx;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeStateInferredAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpInstructionExplicitStopListener;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableTypeDFAnalyzer;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpPassByReferenceParameterTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpReplaceNullFalseWithArrayTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnaryInfixPostfixTP;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableInferredTypeAnalyzerProcessor
extends PhpTypeAnalyzerProcessor
implements PhpInstructionExplicitStopListener {
    private static final Function<PhpType, PhpType> REPLACE_NULL_FALSE_WITH_ARRAY = t -> PhpReplaceNullFalseWithArrayTypeProvider.replaceNullFalseWithArray(t);
    private static final Key<CachedValue<Set<PhpAccessVariableInstruction>>> KEY = Key.create((String)"PhpVariableInferredTypeAnalyzerProcessor.FIRST_VARIABLE_WRITES");
    private static final Key<CachedValue<Collection<PsiElement>>> UNWRAP_KEY = Key.create((String)"PhpVariableInferredTypeAnalyzerProcessor.UNWRAP_KEY");
    private boolean myAmbiguous;
    private boolean myIsStaticDeclaration;
    private final Collection<PhpAccessVariableInstruction> myPossibleFirstFunctionArgumentAccesses;
    private final Collection<PhpAccessVariableInstruction> myStdLibLastFunctionArgumentAccesses;
    private boolean myExplicitInitIsMissing;
    private Collection<PhpInstruction> myInstructionsToStop;
    private static final Function<PhpType, PhpType> ADD_ARRAY = PhpReplaceNullFalseWithArrayTypeProvider::exchangeNullWithArray;
    @NotNull
    private final Variable myVariable;
    @NotNull
    private final CharSequence myVariableName;
    @NotNull
    private final PhpScopeHolder myScopeHolder;
    private final HashSet<PhpInstruction> myVisited;
    private final boolean myOriginalReadOrReadRef;
    private final PhpInstruction myOriginalInstruction;
    private Function<PhpType, PhpType> myArrayAccessTypeAdjuster;
    private final Map<PhpInstructionWithInversedEx, PhpType> myComputedDFAStateTypes;
    private final Collection<PhpInstructionWithInversedEx> myNonComputedDFAStates;
    private final Collection<PsiElement> myProcessedInnerConditions;
    private final PhpType myTypeFromExplicitPassByRef;
    private boolean myAssignedByRef;
    private boolean myTraversalWasTerminated;
    private boolean myReadOrOreadRefAccessExists;

    public boolean isAmbiguous() {
        return this.myAmbiguous;
    }

    public PhpVariableInferredTypeAnalyzerProcessor(@NotNull Variable variable, @NotNull CharSequence variableName, @NotNull PhpScopeHolder scopeHolder, PhpInstruction originalInstruction) {
        if (variable == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(0);
        }
        if (variableName == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(1);
        }
        if (scopeHolder == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(2);
        }
        this.myIsStaticDeclaration = false;
        this.myPossibleFirstFunctionArgumentAccesses = new HashSet<PhpAccessVariableInstruction>();
        this.myStdLibLastFunctionArgumentAccesses = new HashSet<PhpAccessVariableInstruction>();
        this.myExplicitInitIsMissing = false;
        this.myInstructionsToStop = new HashSet<PhpInstruction>();
        this.myComputedDFAStateTypes = new HashMap<PhpInstructionWithInversedEx, PhpType>();
        this.myNonComputedDFAStates = new HashSet<PhpInstructionWithInversedEx>();
        this.myProcessedInnerConditions = new HashSet<PsiElement>();
        this.myTypeFromExplicitPassByRef = new PhpType();
        this.myAssignedByRef = false;
        this.myTraversalWasTerminated = false;
        this.myReadOrOreadRefAccessExists = false;
        this.myVariable = variable;
        this.myVariableName = variableName;
        this.myScopeHolder = scopeHolder;
        this.myVisited = new HashSet();
        this.myOriginalInstruction = originalInstruction;
        this.myOriginalReadOrReadRef = this.myOriginalInstruction instanceof PhpAccessVariableInstruction && ((PhpAccessVariableInstruction)this.myOriginalInstruction).getAccess() instanceof PhpAccessInstruction.ReadOrReadRefAccess;
    }

    public boolean processInstruction(PhpInstruction instruction) {
        this.myVisited.add(instruction);
        return super.processInstruction(instruction);
    }

    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpPsiElement curAnchor;
        if (instruction.getAnchor() != this.myVariable && this.myVariableName.equals(instruction.getVariableName()) && (curAnchor = instruction.getAnchor()) instanceof Variable) {
            PhpAccessInstruction.Access access = instruction.getAccess();
            PsiElement parent = curAnchor.getParent();
            if (access instanceof PhpAccessInstruction.ReadOrReadRefAccess) {
                this.myReadOrOreadRefAccessExists = true;
                if (PhpVariableInferredTypeAnalyzerProcessor.isPassByRefStdLibCall(curAnchor) && (this.myExplicitInitIsMissing || (this.myExplicitInitIsMissing = PhpVariableInferredTypeAnalyzerProcessor.isExplicitInitIsMissing(this.myVariableName, this.myScopeHolder, this.myVariable)))) {
                    PhpVariableInferredTypeAnalyzerProcessor.addPotentialPassByRefArgument(instruction, this.myStdLibLastFunctionArgumentAccesses);
                    return false;
                }
                PhpVariableInferredTypeAnalyzerProcessor.addPotentialPassByRefArgument(instruction, this.myPossibleFirstFunctionArgumentAccesses);
            }
            if (access.isWrite() || access.isWriteRef()) {
                if (PhpPsiUtil.getParentOfClass((PsiElement)curAnchor, PhpStaticStatement.class) != null) {
                    this.myIsStaticDeclaration = true;
                }
                if (!this.myAssignedByRef && access.isWriteRef() && PhpVariableInferredTypeAnalyzerProcessor.assignmentByRef(curAnchor)) {
                    this.myAssignedByRef = true;
                }
                if (parent instanceof UnaryExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.POSTFIX_EXPRESSION)) {
                    this.setType(PhpUnaryInfixPostfixTP.getType((UnaryExpression)parent));
                    super.processAccessVariableInstruction(instruction);
                    return false;
                }
                if (((PhpAccessVariableInstructionImpl)instruction).assignedValueContainsVariable(this.myVariable)) {
                    this.setType(PhpType.MIXED);
                    return true;
                }
                PhpType assignedType = this.getType((PhpAccessInstruction)instruction);
                if (PhpVariableInferredTypeAnalyzerProcessor.isSelfAssignmentVariable((PsiElement)curAnchor, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opSHIFT_LEFT_ASGN, PhpTokenTypes.opSHIFT_RIGHT_ASGN}))) {
                    this.setType(PhpType.INT);
                } else if (PhpVariableInferredTypeAnalyzerProcessor.isSelfAssignmentVariable((PsiElement)curAnchor, PhpTokenTypes.tsBIT_ASGN_OPS)) {
                    this.addBitwiseAssignedType(assignedType);
                } else {
                    this.setType(assignedType);
                    if (assignedType.isEmpty()) {
                        this.setType(PhpType.MIXED);
                    }
                }
                SelfAssignmentExpression expression = (SelfAssignmentExpression)ObjectUtils.tryCast((Object)parent, SelfAssignmentExpression.class);
                if (expression == null || expression.getOperationType() == PhpTokenTypes.opCONCAT_ASGN || PhpTokenTypes.tsBIT_ASGN_OPS.contains(expression.getOperationType()) || PhpVariableInferredTypeAnalyzerProcessor.isCoalesceSelfAssignmentVariable((PsiElement)curAnchor)) {
                    super.processAccessVariableInstruction(instruction);
                    this.myInstructionsToStop.add((PhpInstruction)instruction);
                    return false;
                }
            } else if (!(access instanceof PhpAccessInstruction.ReadOrReadRefAccess) && access.isReadRef() && !PhpLangUtil.isThisReference((PsiElement)curAnchor)) {
                if (PhpVariableInferredTypeAnalyzerProcessor.isAssignedByRef((PsiElement)curAnchor)) {
                    this.myAssignedByRef = true;
                } else {
                    this.myTypeFromExplicitPassByRef.add(this.getTypeFromReadRefAccess((Variable)curAnchor));
                }
            } else if (parent instanceof SelfAssignmentExpression && this.myOriginalReadOrReadRef && (access instanceof PhpAccessInstruction.ReadOrReadRefAccess || access.isRead()) && this.myOriginalInstruction.num() > instruction.num() && !this.myVisited.contains(instruction)) {
                super.processAccessVariableInstruction(instruction);
                this.processAccessInstruction((PhpAccessInstruction)instruction);
                this.myInstructionsToStop.add((PhpInstruction)instruction);
                return false;
            }
        }
        super.processAccessVariableInstruction(instruction);
        return true;
    }

    private static void addPotentialPassByRefArgument(PhpAccessVariableInstruction instruction, Collection<PhpAccessVariableInstruction> accesses) {
        PhpPsiElement curAnchor = instruction.getAnchor();
        if (PhpVariableInferredTypeAnalyzerProcessor.getFunctionCallWithAnchorParameter(curAnchor) != null && PhpCodeInsightUtil.mayBePassByRef((PsiElement)curAnchor, false) != ThreeState.NO) {
            accesses.add(instruction);
        }
    }

    @Nullable
    private static FunctionReference getFunctionCallWithAnchorParameter(PhpPsiElement curAnchor) {
        int parameterIndex;
        PsiElement functionCall;
        PsiElement parent = curAnchor.getParent();
        if (parent instanceof ParameterList && (functionCall = parent.getParent()) instanceof FunctionReference && (parameterIndex = PhpCodeInsightUtil.getParameterIndex((PsiElement)curAnchor)) >= 0) {
            return (FunctionReference)functionCall;
        }
        return null;
    }

    private static boolean isPassByRefStdLibCall(PhpPsiElement curAnchor) {
        FunctionReference call = PhpVariableInferredTypeAnalyzerProcessor.getFunctionCallWithAnchorParameter(curAnchor);
        int index = PhpCodeInsightUtil.getParameterIndex((PsiElement)curAnchor);
        return PhpCodeInsightUtil.isPassByRefStdLibCall(call, index);
    }

    private void addBitwiseAssignedType(PhpType assignedType) {
        if (PhpType.intersects((PhpType)assignedType, (PhpType)PhpType.STRING)) {
            this.setType(PhpType.STRING);
        }
        if (!PhpType.STRING.equals((Object)assignedType)) {
            this.setType(PhpType.INT);
            if (ContainerUtil.all((Collection)assignedType.getTypes(), PhpType::isUnresolved)) {
                this.setType(PhpType.STRING);
            }
        }
    }

    @Override
    public void handleExplicitTraversalTermination() {
        this.myTraversalWasTerminated = true;
    }

    public boolean isStaticDeclaration() {
        return this.myIsStaticDeclaration;
    }

    private Collection<PhpAccessVariableInstruction> getPossibleFirstFunctionArgumentAccess() {
        return this.myPossibleFirstFunctionArgumentAccesses;
    }

    public Collection<PhpAccessVariableInstruction> getStdLibLastFunctionArgumentAccesses() {
        return this.myStdLibLastFunctionArgumentAccesses;
    }

    private static boolean assignmentByRef(PhpPsiElement curAnchor) {
        AssignmentExpression assignment = PhpPsiUtil.getParentOfClass((PsiElement)curAnchor, AssignmentExpression.class);
        return assignment != null && PhpWorkaroundUtil.isAssignByReference(assignment) && assignment.getVariable() == curAnchor && assignment.getValue() instanceof Variable;
    }

    private PhpType getTypeFromReadRefAccess(Variable anchor) {
        PhpType typeFromUsedByRef = this.getTypeFromUsedByRef(anchor);
        if (typeFromUsedByRef != null) {
            return typeFromUsedByRef;
        }
        return PhpType.MIXED;
    }

    private static boolean isAssignedByRef(PsiElement anchor) {
        AssignmentExpression assignment = PhpPsiUtil.getParentOfClass(anchor, AssignmentExpression.class);
        if (assignment != null && PhpWorkaroundUtil.isAssignByReference(assignment) && assignment.getValue() == anchor) {
            return assignment.getVariable() instanceof Variable;
        }
        return false;
    }

    public boolean isAssignedByRef() {
        return this.myAssignedByRef;
    }

    private PhpType getTypeFromUsedByRef(Variable variable) {
        com.jetbrains.php.lang.psi.elements.Function closure = PhpPsiUtil.getParentOfClass((PsiElement)variable, com.jetbrains.php.lang.psi.elements.Function.class);
        if (closure != null && closure.isClosure() && PhpPsiUtil.getUsedVariables(closure).contains(variable)) {
            PhpExitPointInstruction exitPoint = closure.getControlFlow().getExitPoint();
            return PhpVariableInferredTypeAnalyzerProcessor.inferType(variable, variable.getNameCS(), this.myScopeHolder, (PhpInstruction)exitPoint, new PhpVariableInferredTypeAnalyzerProcessor(variable, variable.getNameCS(), this.myScopeHolder, (PhpInstruction)exitPoint));
        }
        return null;
    }

    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
        PhpScopeHolder aClass;
        super.processEntryPointInstruction(instruction);
        if (PhpLangUtil.isThisReference(this.myVariableName)) {
            return false;
        }
        if (PhpLangUtil.isSuperGlobal(this.myVariableName)) {
            this.setType(PhpType.ARRAY);
            return false;
        }
        if (this.myScopeHolder instanceof PhpFile) {
            if (!PhpLangUtil.isThisReference(this.myVariableName)) {
                this.setType(new PhpType().add(PhpTypeSignatureKey.VARIABLE.sign(this.myVariableName)));
            }
            this.myAmbiguous = true;
            return false;
        }
        PhpScopeHolder phpScopeHolder = this.myScopeHolder;
        if (phpScopeHolder instanceof Method) {
            Method method = (Method)phpScopeHolder;
            if (PhpLangUtil.isThisReference(this.myVariableName) && !method.isStatic()) {
                aClass = PhpPsiUtil.getParentOfClass((PsiElement)method, true, PhpClass.class);
                if (aClass != null && PhpLangUtil.isThisReference(this.myVariableName)) {
                    this.setType(aClass.getType());
                    return false;
                }
                return false;
            }
            this.addParameterTypeWithAdjusting((com.jetbrains.php.lang.psi.elements.Function)method);
            return false;
        }
        aClass = this.myScopeHolder;
        if (aClass instanceof com.jetbrains.php.lang.psi.elements.Function) {
            com.jetbrains.php.lang.psi.elements.Function function = (com.jetbrains.php.lang.psi.elements.Function)aClass;
            if (function.isClosure()) {
                if (FunctionImpl.isShortArrowFunction(function) && this.inferTypeFromInstructionFromOuterControlFlow(function)) {
                    return false;
                }
                Collection<Variable> variables = PhpPsiUtil.getUsedVariables(function);
                PhpType type = PhpVariableInferredTypeAnalyzerProcessor.getTypeFromDeclarations(this.myVariableName, variables);
                if (type != null) {
                    this.setType(type);
                    return false;
                }
            }
            this.addParameterTypeWithAdjusting(function);
            return false;
        }
        this.myAmbiguous = true;
        return false;
    }

    public void addParameterTypeWithAdjusting(com.jetbrains.php.lang.psi.elements.Function function) {
        boolean parameterExists;
        boolean bl = parameterExists = !this.addParameterType(function);
        if (!parameterExists) {
            this.myAmbiguous = true;
        }
        if (this.myArrayAccessTypeAdjuster != null && !this.myReadOrOreadRefAccessExists) {
            this.setType(this.myArrayAccessTypeAdjuster.apply(parameterExists ? this.getType() : PhpType.NULL));
        }
    }

    private boolean addParameterType(com.jetbrains.php.lang.psi.elements.Function function) {
        Parameter parameter = (Parameter)ContainerUtil.find((Object[])function.getParameters(), p -> PhpLangUtil.equalsParameterNames(this.myVariableName, p.getName()));
        if (parameter == null) {
            return true;
        }
        boolean declaredTypeIsEmpty = PhpVariableInferredTypeAnalyzerProcessor.isDeclaredTypeEmpty((PhpTypedElement)parameter);
        PhpType parameterType = parameter.getType();
        if (PhpVariableInferredTypeAnalyzerProcessor.isVariadic(parameter)) {
            parameterType = parameterType.pluralise();
        }
        if (declaredTypeIsEmpty && !PhpCodeValidationUtil.isSupportedConstClosureExpressionDefaultValue(parameter.getDefaultValue(), true, true) && (this.getType().isEmpty() && parameter.getDefaultValue() != null || !this.getType().isEmpty() && this.myTraversalWasTerminated)) {
            parameterType = PhpType.or((PhpType)parameterType, (PhpType)PhpType.MIXED);
        }
        this.setType(parameterType);
        if (!parameterType.filterUnknown().isEmpty()) {
            this.removeAmbiguousDfaTypes();
        }
        return false;
    }

    public static boolean isDeclaredTypeEmpty(@NotNull PhpTypedElement parameter) {
        if (parameter == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(3);
        }
        return parameter.getDeclaredType().isEmpty() && parameter.getDocType().isEmpty();
    }

    private static boolean isVariadic(Parameter parameter) {
        if (parameter.isVariadic()) {
            return true;
        }
        PhpDocParamTag tag = parameter.getDocTag();
        return tag != null && tag.isVariadic();
    }

    private void removeAmbiguousDfaTypes() {
        this.myComputedDFAStateTypes.keySet().removeIf(key -> this.myNonComputedDFAStates.contains(key.getInverseInstruction()));
    }

    private boolean inferTypeFromInstructionFromOuterControlFlow(@NotNull com.jetbrains.php.lang.psi.elements.Function function) {
        PhpAccessVariableInstruction instructionInOuterControlFlow;
        PhpScopeHolder outerScopeHolder;
        if (function == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(4);
        }
        if ((outerScopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)function)) != null && (instructionInOuterControlFlow = (PhpAccessVariableInstruction)outerScopeHolder.getControlFlow().getInstruction((PsiElement)this.myVariable, PhpAccessVariableInstruction.class)) != null) {
            PhpVariableInferredTypeAnalyzerProcessor processor2 = new PhpVariableInferredTypeAnalyzerProcessor(this.myVariable, this.myVariableName, outerScopeHolder, (PhpInstruction)instructionInOuterControlFlow);
            this.setType(PhpVariableInferredTypeAnalyzerProcessor.inferTypeDfaBasedTypeStateAware(this.myVariable, this.myVariableName, outerScopeHolder, (PhpInstruction)instructionInOuterControlFlow, processor2));
            return true;
        }
        return false;
    }

    @Nullable
    private static PhpType getTypeFromDeclarations(@NotNull CharSequence variableName, Collection<? extends PhpNamedElement> variables) {
        if (variableName == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(5);
        }
        for (PhpNamedElement phpNamedElement : variables) {
            if (phpNamedElement == null || !PhpLangUtil.equalsVariableNames(variableName, phpNamedElement.getName())) continue;
            return phpNamedElement.getType();
        }
        return null;
    }

    public boolean processCaseConditionInstruction(PhpCaseConditionInstruction instruction) {
        super.processCaseConditionInstruction(instruction);
        PsiElement argument = instruction.getSwitchArgument();
        if (argument instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)argument).getName(), this.myVariableName) || PhpLangUtil.isTrue(argument)) {
            return this.performDataFlowAnalyze(instruction.getCaseArgument(), instruction.getResult(), (PhpBaseCaseConditionInstructionImpl)instruction);
        }
        return true;
    }

    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        super.processConditionInstruction(instruction);
        PsiElement condition = instruction.getCondition();
        if (condition == null) {
            return true;
        }
        if (condition == this.myVariable || this.myProcessedInnerConditions.contains(PhpPsiUtil.unparenthesize(condition))) {
            return true;
        }
        if (condition instanceof Variable && PhpLangUtil.equalsVariableNames(this.myVariableName, ((Variable)condition).getName()) && PhpVariableInferredTypeAnalyzerProcessor.isCoalesceSelfAssignmentVariable(condition)) {
            return false;
        }
        Collection unwrappedOperands = (Collection)CachedValuesManager.getCachedValue((PsiElement)condition, () -> PhpVariableInferredTypeAnalyzerProcessor.doUnwrapOperands(condition));
        this.myProcessedInnerConditions.addAll(unwrappedOperands);
        return this.performDataFlowAnalyze(condition, instruction.getResult(), (PhpConditionInstructionImpl)instruction);
    }

    @NotNull
    private static CachedValueProvider.Result<Collection<PsiElement>> doUnwrapOperands(PsiElement condition) {
        Collection<PsiElement> value = PhpVariableInferredTypeAnalyzerProcessor.unwrapLogicalOperands(condition);
        value.remove(PhpPsiUtil.unparenthesize(condition));
        CachedValueProvider.Result result = CachedValueProvider.Result.createSingleDependency(value, (Object)condition);
        if (result == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(6);
        }
        return result;
    }

    public static boolean isCoalesceSelfAssignmentVariable(@NotNull PsiElement condition) {
        if (condition == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(7);
        }
        return PhpVariableInferredTypeAnalyzerProcessor.isSelfAssignmentVariable(condition, PhpTokenTypes.opCOALESCE_ASGN);
    }

    private static boolean isSelfAssignmentVariable(@NotNull PsiElement condition, TokenSet operationType) {
        if (condition == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(8);
        }
        return condition.getParent() instanceof SelfAssignmentExpression && operationType.contains(((SelfAssignmentExpression)condition.getParent()).getOperationType()) && ((SelfAssignmentExpression)condition.getParent()).getVariable() == condition;
    }

    public static boolean isSelfAssignmentVariable(@NotNull PsiElement condition, IElementType operationType) {
        if (condition == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(9);
        }
        return PhpVariableInferredTypeAnalyzerProcessor.isSelfAssignmentVariable(condition, TokenSet.create((IElementType[])new IElementType[]{operationType}));
    }

    private static Collection<PsiElement> unwrapLogicalOperands(PsiElement condition) {
        condition = PhpPsiUtil.unparenthesize(condition);
        HashSet<PsiElement> res = new HashSet<PsiElement>();
        if (condition instanceof BinaryExpression && PhpTokenTypes.tsLOGICAL_OPS.contains(((BinaryExpression)condition).getOperationType())) {
            PsiElement left = ((BinaryExpression)condition).getLeftOperand();
            ContainerUtil.addIfNotNull(res, (Object)PhpPsiUtil.unparenthesize(left));
            res.addAll(PhpVariableInferredTypeAnalyzerProcessor.unwrapLogicalOperands(left));
            PsiElement right = ((BinaryExpression)condition).getRightOperand();
            ContainerUtil.addIfNotNull(res, (Object)PhpPsiUtil.unparenthesize(right));
            res.addAll(PhpVariableInferredTypeAnalyzerProcessor.unwrapLogicalOperands(right));
            return res;
        }
        ContainerUtil.addIfNotNull(res, (Object)condition);
        return res;
    }

    private boolean performDataFlowAnalyze(@Nullable PsiElement condition, boolean result, @NotNull PhpInstructionWithInversedEx instruction) {
        PhpVariableTypeDFAnalyzer analyzer;
        Map typeMap;
        if (instruction == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(10);
        }
        if ((typeMap = (Map)(analyzer = new PhpVariableTypeDFAnalyzer(this.myVariableName)).performDFA(condition, result)).containsKey(this.myVariableName)) {
            PhpType type = (PhpType)typeMap.get(this.myVariableName);
            if (!type.isEmpty()) {
                this.myComputedDFAStateTypes.computeIfAbsent(instruction, i -> new PhpType()).add(type);
            }
            return !analyzer.completeTypeComputed();
        }
        this.myNonComputedDFAStates.add(instruction);
        return true;
    }

    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
        this.doProcessArrayAccess(instruction);
        return true;
    }

    protected boolean doProcessArrayAccess(PhpArrayAccessInstruction instruction) {
        MultiDimensionalArrayAccessInfo info;
        if (instruction.getAccess().isWrite() && (info = PhpVariableInferredTypeAnalyzerProcessor.getMultiDimensionalArrayAccessInfo(instruction)) != null && this.myVariableName.equals(info.myBaseVariableName)) {
            this.myArrayAccessTypeAdjuster = info.myDimension > 1 ? ADD_ARRAY : REPLACE_NULL_FALSE_WITH_ARRAY;
            return false;
        }
        return true;
    }

    @Nullable
    public static MultiDimensionalArrayAccessInfo getMultiDimensionalArrayAccessInfo(PhpArrayAccessInstruction instruction) {
        CharSequence variableName = instruction.getVariableName();
        if (variableName != null) {
            return new MultiDimensionalArrayAccessInfo(variableName, 1);
        }
        return PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction.getAnchor(), 0);
    }

    @Nullable
    public static CharSequence getBaseVariableName(PhpArrayAccessInstruction instruction) {
        MultiDimensionalArrayAccessInfo info = PhpVariableInferredTypeAnalyzerProcessor.getMultiDimensionalArrayAccessInfo(instruction);
        return info != null ? info.myBaseVariableName : null;
    }

    private static MultiDimensionalArrayAccessInfo getBaseVariableName(PhpPsiElement element, int dimension) {
        if (element instanceof Variable) {
            return new MultiDimensionalArrayAccessInfo(element.getName(), dimension);
        }
        if (element instanceof ArrayAccessExpression) {
            return PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(((ArrayAccessExpression)element).getValue(), dimension + 1);
        }
        return null;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType type = this.getTypeAmbiguousDfaStatesAware();
        if (!type.isEmpty()) {
            PhpType phpType = PhpType.or((PhpType)type, (PhpType)this.myTypeFromExplicitPassByRef);
            if (phpType == null) {
                PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    @NotNull
    private PhpType getTypeAmbiguousDfaStatesAware() {
        PhpType type = super.getType();
        if (this.myComputedDFAStateTypes.isEmpty()) {
            PhpType phpType = type;
            if (phpType == null) {
                PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(13);
            }
            return phpType;
        }
        type = new PhpType().add(type);
        boolean pluralExists = ContainerUtil.exists((Iterable)type.getTypes(), PhpType::isPluralType);
        this.myComputedDFAStateTypes.entrySet().stream().map(e -> this.myNonComputedDFAStates.contains(((PhpInstructionWithInversedEx)e.getKey()).getInverseInstruction()) ? PhpType.or((PhpType)PhpType.MIXED, (PhpType)((PhpType)e.getValue())) : (PhpType)e.getValue()).map(t -> pluralExists ? t.filterOut(PhpType::isArray) : t).forEach(arg_0 -> ((PhpType)type).add(arg_0));
        PhpType phpType = type;
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    @Override
    protected boolean processAccessInstruction(@NotNull PhpAccessInstruction accessInstruction) {
        if (accessInstruction == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(15);
        }
        this.setType(this.getType(accessInstruction));
        return false;
    }

    private PhpType getType(@NotNull PhpAccessInstruction accessInstruction) {
        PhpPsiElement curAnchor;
        if (accessInstruction == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(16);
        }
        if (!PhpLangUtil.isThisReference((PsiElement)accessInstruction.getAnchor()) && (curAnchor = accessInstruction.getAnchor()) instanceof PhpTypedElement) {
            PhpType type = this.getType(curAnchor);
            return this.myArrayAccessTypeAdjuster != null ? this.myArrayAccessTypeAdjuster.apply(type) : type;
        }
        return PhpType.EMPTY;
    }

    protected PhpType getType(PhpPsiElement curAnchor) {
        return PhpTypeInfo.getType((PsiElement)curAnchor);
    }

    @NotNull
    public static PhpType inferTypeDfaBasedTypeStateAware(@NotNull Variable variable, CharSequence variableName, PhpScopeHolder scopeHolder, PhpInstruction instruction, PhpVariableInferredTypeAnalyzerProcessor processor2) {
        if (variable == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(17);
        }
        PhpType type = PhpVariableInferredTypeAnalyzerProcessor.inferType(variable, variableName, scopeHolder, instruction, processor2);
        Collection<PhpInstruction> instructionsToStop = processor2.getInstructionsToStop();
        if (PhpLangUtil.isThisReference((PsiElement)variable)) {
            PhpType phpType = type;
            if (phpType == null) {
                PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(18);
            }
            return phpType;
        }
        PhpType dfaBasedType = PhpVariableInferredTypeAnalyzerProcessor.processDfaBasedTypeState(variable, variableName, instruction, type, true, instructionsToStop);
        PhpType lastFunctionArgumentAccess = PhpVariableInferredTypeAnalyzerProcessor.getTypeFromLastPassByRef(processor2, type, variableName, scopeHolder, variable);
        PhpType phpType = PhpType.or((PhpType)dfaBasedType, (PhpType)lastFunctionArgumentAccess);
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(19);
        }
        return phpType;
    }

    private Collection<PhpInstruction> getInstructionsToStop() {
        return this.myInstructionsToStop;
    }

    private static boolean isExplicitInitIsMissing(CharSequence variableName, PhpScopeHolder scopeHolder, Variable variable) {
        Set<PhpAccessVariableInstruction> firstVariableAccesses = PhpVariableInferredTypeAnalyzerProcessor.getFirstVariableAccesses(variable);
        return !PhpVariableInferredTypeAnalyzerProcessor.isParameter(variableName, scopeHolder) && !ContainerUtil.exists(firstVariableAccesses, i -> !(i.getAccess() instanceof PhpAccessInstruction.ReadOrReadRefAccess) && i.getAccess().isWrite());
    }

    @NotNull
    public static Set<PhpAccessVariableInstruction> getFirstVariableAccesses(Variable variable) {
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)variable, KEY, () -> {
            PhpScopeHolder holder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
            Set instructions = holder != null ? Set.of(PhpControlFlowUtil.getFollowingVariableAccessInstructions((PhpInstruction)holder.getControlFlow().getEntryPoint(), variable.getName(), true)) : Collections.emptySet();
            return CachedValueProvider.Result.create(instructions, (Object[])new Object[]{variable});
        });
        if (set == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(20);
        }
        return set;
    }

    private static boolean isParameter(CharSequence variableName, PhpScopeHolder scopeHolder) {
        return scopeHolder instanceof com.jetbrains.php.lang.psi.elements.Function && ContainerUtil.exists((Object[])((com.jetbrains.php.lang.psi.elements.Function)scopeHolder).getParameters(), p -> PhpLangUtil.equalsParameterNames(p.getName(), variableName));
    }

    @NotNull
    private static PhpType getTypeFromLastPassByRef(PhpVariableInferredTypeAnalyzerProcessor processor2, PhpType type, CharSequence variableName, PhpScopeHolder scopeHolder, @NotNull Variable variable) {
        if (variable == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(21);
        }
        if (type.isEmpty() || processor2.isAmbiguous()) {
            PhpType typeFromStdLib = PhpVariableInferredTypeAnalyzerProcessor.getPassByRefType(processor2.getStdLibLastFunctionArgumentAccesses());
            PhpType typeFromPossibleFirstVariableAccesses = PhpVariableInferredTypeAnalyzerProcessor.getPassByRefType(processor2.getPossibleFirstFunctionArgumentAccess());
            if (!typeFromStdLib.isEmpty() || !typeFromPossibleFirstVariableAccesses.isEmpty() && PhpVariableInferredTypeAnalyzerProcessor.isExplicitInitIsMissing(variableName, scopeHolder, variable)) {
                Set<PhpAccessVariableInstruction> firstVariableAccesses = PhpVariableInferredTypeAnalyzerProcessor.getFirstVariableAccesses(variable);
                List firstVariableAccessesByRef = ContainerUtil.filter(processor2.getPossibleFirstFunctionArgumentAccess(), firstVariableAccesses::contains);
                PhpType phpType = PhpType.or((PhpType)typeFromStdLib, (PhpType)PhpVariableInferredTypeAnalyzerProcessor.getPassByRefType(firstVariableAccessesByRef));
                if (phpType == null) {
                    PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(22);
                }
                return phpType;
            }
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(23);
        }
        return phpType;
    }

    @NotNull
    private static PhpType getPassByRefType(Collection<PhpAccessVariableInstruction> instructions) {
        PhpType phpType = instructions.stream().flatMap(v -> VariableImpl.getSignaturesFromFunctionCall((Variable)ObjectUtils.tryCast((Object)v.getAnchor(), Variable.class)).stream()).map(PhpPassByReferenceParameterTypeProvider::sign).reduce(new PhpType(), PhpType::or);
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(24);
        }
        return phpType;
    }

    @NotNull
    public static PhpType inferType(Variable variable, CharSequence variableName, PhpScopeHolder scopeHolder, PhpInstruction originalInstruction, PhpVariableInferredTypeAnalyzerProcessor processor2) {
        return PhpVariableInferredTypeAnalyzerProcessor.inferType(processor2, variable, variableName, scopeHolder, originalInstruction);
    }

    @NotNull
    public static PhpType inferType(PhpVariableInferredTypeAnalyzerProcessor processor2, Variable variable, CharSequence variableName, PhpScopeHolder scopeHolder, PhpInstruction originalInstruction) {
        PhpControlFlowUtil.processPredecessors(originalInstruction, false, processor2);
        PhpType variableType = processor2.getType();
        if (processor2.isAssignedByRef()) {
            PhpType assignedByRefTypes = new PhpType();
            Collection<PhpAccessVariableInstruction> instructions = PhpVariableInferredTypeAnalyzerProcessor.getByRefAssignedVariablesInstructions(variable, originalInstruction);
            if (!instructions.isEmpty()) {
                Ref ambiguousType = new Ref((Object)Boolean.FALSE);
                List<PhpType> typesFromIndirectByRefAssignment = instructions.stream().map(variablesInstruction -> PhpVariableInferredTypeAnalyzerProcessor.inferTypeFromByRefIndirectAssignment(variableName, scopeHolder, originalInstruction, variableType, variablesInstruction, (Ref<Boolean>)ambiguousType)).filter(Objects::nonNull).toList();
                typesFromIndirectByRefAssignment.forEach(arg_0 -> ((PhpType)assignedByRefTypes).add(arg_0));
                if (!typesFromIndirectByRefAssignment.isEmpty()) {
                    if (((Boolean)ambiguousType.get()).booleanValue()) {
                        PhpType phpType = PhpType.or((PhpType)variableType, (PhpType)assignedByRefTypes);
                        if (phpType == null) {
                            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(25);
                        }
                        return phpType;
                    }
                    PhpType phpType = assignedByRefTypes;
                    if (phpType == null) {
                        PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(26);
                    }
                    return phpType;
                }
            }
        }
        PhpType phpType = variableType;
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(27);
        }
        return phpType;
    }

    private static PhpType inferTypeFromByRefIndirectAssignment(final CharSequence variableName, PhpScopeHolder scopeHolder, PhpInstruction originalInstruction, final PhpType variableType, final PhpAccessVariableInstruction writeByRefInstruction, final Ref<Boolean> ambiguousType) {
        CharSequence variableNameLinkedByRef;
        Variable v = (Variable)ObjectUtils.tryCast((Object)writeByRefInstruction.getAnchor(), Variable.class);
        if (v == null) {
            return PhpType.EMPTY;
        }
        CharSequence charSequence = variableNameLinkedByRef = PhpLangUtil.equalsVariableNames(writeByRefInstruction.getVariableName(), variableName) ? PhpVariableInferredTypeAnalyzerProcessor.getAssignedVariableName(writeByRefInstruction) : writeByRefInstruction.getVariableName();
        if (variableNameLinkedByRef == null) {
            return PhpType.EMPTY;
        }
        PhpVariableInferredTypeAnalyzerProcessor p = new PhpVariableInferredTypeAnalyzerProcessor(v, variableNameLinkedByRef, scopeHolder, originalInstruction){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.num() <= writeByRefInstruction.num()) {
                    if (instruction.num() == writeByRefInstruction.num()) {
                        ambiguousType.set((Object)Boolean.TRUE);
                    }
                    return false;
                }
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName)) {
                    this.setType(variableType);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        };
        PhpControlFlowUtil.processPredecessors(originalInstruction, false, p);
        return p.getType();
    }

    @Nullable
    private static CharSequence getAssignedVariableName(PhpAccessVariableInstruction instruction) {
        Variable assignedVariable = (Variable)ObjectUtils.tryCast((Object)((PhpAccessVariableInstructionImpl)instruction).getAssignedValue(), Variable.class);
        return assignedVariable != null ? assignedVariable.getNameCS() : null;
    }

    private static Collection<PhpAccessVariableInstruction> getByRefAssignedVariablesInstructions(Variable variable, PhpInstruction instruction) {
        final String variableName = variable.getName();
        final HashSet<PhpAccessVariableInstruction> res = new HashSet<PhpAccessVariableInstruction>();
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction i) {
                PhpAccessInstruction.Access access = i.getAccess();
                if (access.isWrite() || access.isWriteRef()) {
                    Variable assignedValue;
                    if (PhpLangUtil.equalsVariableNames(i.getVariableName(), variableName)) {
                        if (PhpVariableInferredTypeAnalyzerProcessor.assignmentByRef(i.getAnchor())) {
                            res.add(i);
                        }
                        return false;
                    }
                    if (access.isWriteRef() && (assignedValue = (Variable)ObjectUtils.tryCast((Object)((PhpAccessVariableInstructionImpl)i).getAssignedValue(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(assignedValue.getName(), variableName)) {
                        res.add(i);
                        return false;
                    }
                }
                return super.processAccessVariableInstruction(i);
            }
        });
        return res;
    }

    @NotNull
    public static PhpType processDfaBasedTypeState(Variable variable, CharSequence variableName, PhpInstruction instruction, PhpType type, boolean processBackEdges, Collection<PhpInstruction> instructionsToStop) {
        PhpDfaBasedTypeStateInferredAnalyzerProcessor dfaStateProcessor = new PhpDfaBasedTypeStateInferredAnalyzerProcessor(variableName, (PsiElement)variable, false, false, instructionsToStop);
        if (processBackEdges) {
            PhpControlFlowUtil.processPredecessors(instruction, false, dfaStateProcessor);
        } else {
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, dfaStateProcessor);
        }
        PhpType phpType = dfaStateProcessor.apply(type);
        PhpDfaBasedTypeStateInferredAnalyzerProcessor negatedDfaStateProcessor = new PhpDfaBasedTypeStateInferredAnalyzerProcessor(variableName, (PsiElement)variable, false, true, instructionsToStop);
        if (processBackEdges) {
            PhpControlFlowUtil.processPredecessors(instruction, false, negatedDfaStateProcessor);
        } else {
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges(instruction, false, negatedDfaStateProcessor);
        }
        PhpType phpType2 = negatedDfaStateProcessor.apply(phpType);
        if (phpType2 == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(28);
        }
        return phpType2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 12, 13, 14, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/typeInference/PhpVariableInferredTypeAnalyzerProcessor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpVariableInferredTypeAnalyzerProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doUnwrapOperands";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAmbiguousDfaStatesAware";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDfaBasedTypeStateAware";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstVariableAccesses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromLastPassByRef";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassByRefType";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "inferType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "processDfaBasedTypeState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredTypeEmpty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeFromInstructionFromOuterControlFlow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromDeclarations";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCoalesceSelfAssignmentVariable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSelfAssignmentVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performDataFlowAnalyze";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processAccessInstruction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDfaBasedTypeStateAware";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromLastPassByRef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 12, 13, 14, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }

    static class MultiDimensionalArrayAccessInfo {
        private final int myDimension;
        private final CharSequence myBaseVariableName;

        MultiDimensionalArrayAccessInfo(CharSequence name, int dimension) {
            this.myDimension = dimension;
            this.myBaseVariableName = name;
        }
    }
}

