/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpAnyExpressionArgument;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpObjectShapeCompletionProvider;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.attributes.PhpArrayKeyDoesNotMatchArrayShapeInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ArrayHashElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpArrayShapeIndexTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocTagAliasTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpArrayShapeBasedOnUsageProvider;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpArrayShapeOfArrayCreationProvider;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpArrayShapesProvider;
import com.jetbrains.php.lang.psi.resolve.types.shapes.PhpDocArrayShapeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpShapeEntriesIndex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrayShapeIndexCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        ArrayAccessExpression arrayAccess;
        if (parameters == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((arrayAccess = PhpPsiUtil.getParentOfClass(parameters.getPosition(), true, ArrayAccessExpression.class)) == null) {
            return;
        }
        ArrayIndex index = arrayAccess.getIndex();
        if (index == null) {
            return;
        }
        PhpPsiElement parent = index.getValue();
        PhpPsiElement value = arrayAccess.getValue();
        PhpArrayShapeIndexCompletionProvider.addValues(result, parent, (PsiElement)value);
    }

    private static void addValues(@NotNull CompletionResultSet result, PhpPsiElement parent, PsiElement value) {
        if (result == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(3);
        }
        if (value == null) {
            return;
        }
        StreamEx keys = StreamEx.of(PhpArrayShapeIndexCompletionProvider.getArrayShapes(value)).map(PhpShapeEntriesIndex.PhpShapeEntry::getKey);
        PhpCompletionContributor.addExpectedValues(result, (PsiElement)parent, (Stream<PhpExpectedFunctionArgument>)keys);
    }

    public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getArrayShapes(PsiElement value) {
        ArrayDeque<PhpExpectedFunctionArgument> parentAccesses = new ArrayDeque<PhpExpectedFunctionArgument>();
        value = PhpArrayShapeIndexCompletionProvider.findTargetValue(value, parentAccesses);
        ArrayList<PhpShapeEntriesIndex.PhpShapeEntry> shapes = new ArrayList<PhpShapeEntriesIndex.PhpShapeEntry>(PhpArrayShapeIndexCompletionProvider.getArrayShapes(value, parentAccesses));
        if (value instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)value;
            String key = fieldReference.getName();
            shapes.addAll(((StreamEx)((StreamEx)StreamEx.of(PhpObjectShapeCompletionProvider.getObjectShapes(fieldReference)).filter(s -> StringUtil.unquoteString((String)s.getKey().getValue()).equals(key))).flatMap(s -> s.getChildren().stream()).filter(s -> !s.isObjectShape())).toList());
        }
        return shapes;
    }

    private static Collection<PhpShapeEntriesIndex.PhpShapeEntry> getArrayShapes(PsiElement value, ArrayDeque<PhpExpectedFunctionArgument> parentAccesses) {
        List arrayShapes = ((StreamEx)StreamEx.of(PhpArrayShapesProvider.EP_NAME.getExtensionList().stream()).append((Object)PhpArrayShapeBasedOnUsageProvider.INSTANCE).append((Object)PhpArrayShapeOfArrayCreationProvider.INSTANCE).flatMap(r -> r.getValues(value, true).stream()).append(PhpArrayShapeIndexCompletionProvider.arrayShapesFromTypes(value))).toList();
        return PhpArrayShapeIndexCompletionProvider.collectShapesByParentAccesses(parentAccesses, arrayShapes);
    }

    public static <T> Collection<PhpShapeEntriesIndex.PhpShapeEntry> collectShapesByParentAccesses(ArrayDeque<T> parentAccesses, BiFunction<? super PhpExpectedFunctionArgument, ? super T, Boolean> accessPredicate, Collection<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapes) {
        for (Object access : parentAccesses) {
            arrayShapes = arrayShapes.stream().filter(shape -> (Boolean)accessPredicate.apply((PhpExpectedFunctionArgument)shape.getKey(), (Object)access) != false || shape.getKey() instanceof PhpAnyExpressionArgument).flatMap(shape -> shape.getChildren().stream()).collect(Collectors.toList());
        }
        return arrayShapes;
    }

    public static Collection<PhpShapeEntriesIndex.PhpShapeEntry> collectShapesByParentAccesses(ArrayDeque<PhpExpectedFunctionArgument> parentAccesses, Collection<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapes) {
        return PhpArrayShapeIndexCompletionProvider.collectShapesByParentAccesses(parentAccesses, (key, access) -> key.getValue().equals(access.getValue()) || key.equals(access) || access instanceof PhpAnyExpressionArgument, arrayShapes);
    }

    @Nullable
    public static PsiElement findTargetValue(PsiElement value, ArrayDeque<PhpExpectedFunctionArgument> parentAccessesToFill) {
        if ((value = PhpArrayShapeIndexCompletionProvider.fillParentAccesses(value, parentAccessesToFill)) instanceof Variable) {
            for (PsiElement item : ((Variable)value).resolveLocal()) {
                PsiElement psiElement;
                if (!(item instanceof Variable)) continue;
                PsiElement array = value;
                while ((psiElement = item.getParent()) instanceof ForeachStatement) {
                    ForeachStatement foreach = (ForeachStatement)psiElement;
                    parentAccessesToFill.addFirst(PhpAnyExpressionArgument.INSTANCE);
                    array = PhpArrayShapeIndexCompletionProvider.fillParentAccesses(foreach.getArray(), parentAccessesToFill);
                    item = foreach.getParent();
                }
                return PhpArrayShapeIndexCompletionProvider.fillParentAccesses(array, parentAccessesToFill);
            }
        }
        return value;
    }

    @Nullable
    private static PsiElement fillParentAccesses(@Nullable PsiElement value, ArrayDeque<PhpExpectedFunctionArgument> parentAccessesToFill) {
        if (value instanceof ArrayCreationExpression) {
            ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)value;
            return PhpArrayShapeIndexCompletionProvider.fillArrayCreationParentAccesses(arrayCreationExpression, parentAccessesToFill);
        }
        if (value instanceof ArrayAccessExpression) {
            ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)value;
            return PhpArrayShapeIndexCompletionProvider.fillArrayAccessParentAccesses((PsiElement)arrayAccessExpression, parentAccessesToFill);
        }
        return value;
    }

    @NotNull
    private static ArrayCreationExpression fillArrayCreationParentAccesses(@NotNull ArrayCreationExpression value, ArrayDeque<PhpExpectedFunctionArgument> parentAccessesToFill) {
        ArrayHashElementImpl arrayHashElement;
        PsiElement psiElement;
        if (value == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(4);
        }
        while ((psiElement = value.getParent().getParent()) instanceof ArrayHashElementImpl && (arrayHashElement = (ArrayHashElementImpl)psiElement).getKey() != null && (psiElement = arrayHashElement.getParent()) instanceof ArrayCreationExpression) {
            ArrayCreationExpression parentArrayCreationExpression = (ArrayCreationExpression)psiElement;
            PhpExpectedFunctionArgument argument = PhpExpectedFunctionArgumentsIndex.getExpectedArgument((PsiElement)arrayHashElement.getKey(), 0, 0, null, false);
            parentAccessesToFill.addFirst(argument);
            value = parentArrayCreationExpression;
        }
        ArrayCreationExpression arrayCreationExpression = value;
        if (arrayCreationExpression == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(5);
        }
        return arrayCreationExpression;
    }

    @Nullable
    private static PsiElement fillArrayAccessParentAccesses(@Nullable PsiElement value, ArrayDeque<PhpExpectedFunctionArgument> parentAccessesToFill) {
        while (value instanceof ArrayAccessExpression) {
            ArrayIndex index = ((ArrayAccessExpression)value).getIndex();
            PhpPsiElement indexValue = index != null ? index.getValue() : null;
            PhpExpectedFunctionArgument parentAccess = PhpArrayShapeIndexCompletionProvider.getParentAccesses(indexValue);
            value = ((ArrayAccessExpression)value).getValue();
            parentAccessesToFill.addFirst(parentAccess);
        }
        return value;
    }

    @NotNull
    public static PhpExpectedFunctionArgument getParentAccesses(PhpPsiElement indexValue) {
        PhpAnyExpressionArgument phpAnyExpressionArgument = PhpArrayKeyDoesNotMatchArrayShapeInspection.isPossibleArrayShapeIndex(indexValue) ? PhpExpectedFunctionArgumentsIndex.getExpectedArgument((PsiElement)indexValue, 0, 0, null, false) : PhpAnyExpressionArgument.INSTANCE;
        if (phpAnyExpressionArgument == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(6);
        }
        return phpAnyExpressionArgument;
    }

    @Nullable
    private static String getTypeNameFromImportTag(@Nullable PsiElement element) {
        PhpDocTag tag;
        PsiElement firstDocIdentifier;
        if (element instanceof PhpDocTag && (firstDocIdentifier = PhpPsiUtil.getChildOfType((PsiElement)(tag = (PhpDocTag)element), PhpDocTokenTypes.DOC_IDENTIFIER)) != null) {
            return firstDocIdentifier.getText();
        }
        return null;
    }

    private static PhpDocType getAliasDocType(@NotNull PhpClass phpClass, @NotNull String typeName) {
        PsiElement aliasIdentifier;
        PhpDocTag importTag;
        PhpDocComment docComment;
        if (phpClass == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(7);
        }
        if (typeName == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(8);
        }
        if ((docComment = phpClass.getDocComment()) != null && (importTag = (PhpDocTag)PhpPsiUtil.getChildByCondition((PsiElement)docComment, (Condition<? super PsiElement>)((Condition)child -> typeName.equals(PhpArrayShapeIndexCompletionProvider.getTypeNameFromImportTag(child))))) != null && (aliasIdentifier = PhpDocTagAliasTypeProvider.getAliasIdentifier(importTag)) != null) {
            return (PhpDocType)PhpPsiUtil.getNextSiblingByCondition(aliasIdentifier, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF);
        }
        return null;
    }

    @NotNull
    private static Stream<PhpShapeEntriesIndex.PhpShapeEntry> resolveShapesFromImportedType(PsiElement value, String signature) {
        String typeName = PhpDocTagAliasTypeProvider.typeNameFromSignature(signature);
        String containingClassFqn = PhpDocTagAliasTypeProvider.classFqnFromSignature(signature);
        if (typeName != null && containingClassFqn != null) {
            Stream<PhpShapeEntriesIndex.PhpShapeEntry> stream = PhpIndex.getInstance((Project)value.getProject()).getClassesByFQN(containingClassFqn).stream().map(classCandidate -> PhpArrayShapeIndexCompletionProvider.getAliasDocType(classCandidate, typeName)).filter(Objects::nonNull).flatMap(docType -> PhpDocArrayShapeProvider.collectShapesFromAttributeList((PsiElement)docType).stream());
            if (stream == null) {
                PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(9);
            }
            return stream;
        }
        Stream<PhpShapeEntriesIndex.PhpShapeEntry> stream = Stream.empty();
        if (stream == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @NotNull
    private static Stream<PhpShapeEntriesIndex.PhpShapeEntry> arrayShapesFromTypes(PsiElement value) {
        Stream<PhpShapeEntriesIndex.PhpShapeEntry> stream = value instanceof PhpReference ? ((PhpReference)value).getSignatureParts().stream().flatMap(s -> PhpDocTagAliasTypeProvider.KEY.signed((String)s) ? PhpArrayShapeIndexCompletionProvider.resolveShapesFromImportedType(value, s) : PhpArrayShapeIndexTP.fetchArrayShapeEntries(value.getProject(), s)) : Stream.empty();
        if (stream == null) {
            PhpArrayShapeIndexCompletionProvider.$$$reportNull$$$0(11);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpArrayShapeIndexCompletionProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpArrayShapeIndexCompletionProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fillArrayCreationParentAccesses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentAccesses";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveShapesFromImportedType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayShapesFromTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addValues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillArrayCreationParentAccesses";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAliasDocType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static class PhpArrayShapeInLiteralCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            ArrayCreationExpression arrayCreationLiteral;
            if (parameters == null) {
                PhpArrayShapeInLiteralCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpArrayShapeInLiteralCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpArrayShapeInLiteralCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((arrayCreationLiteral = PhpPsiUtil.getParentOfClass(parameters.getPosition(), true, ArrayCreationExpression.class)) == null) {
                return;
            }
            PhpPsiElement parent = ArrayCreationExpressionImpl.children(arrayCreationLiteral).stream().filter(child -> PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)parameters.getPosition(), (boolean)false)).map(element -> element instanceof ArrayHashElement ? ((ArrayHashElement)element).getKey() : element.getFirstPsiChild()).filter(Objects::nonNull).findFirst().orElse(null);
            PhpArrayShapeIndexCompletionProvider.addValues(result, parent, (PsiElement)arrayCreationLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpArrayShapeIndexCompletionProvider$PhpArrayShapeInLiteralCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

