/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.ComposerDataService;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComposerAbstractAction
extends AnAction
implements DumbAware {
    public ComposerAbstractAction() {
    }

    public ComposerAbstractAction(@Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description) {
        super(text, description, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ComposerAbstractAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataContext context;
        Project project;
        boolean enabled;
        if (e == null) {
            ComposerAbstractAction.$$$reportNull$$$0(1);
        }
        boolean bl = enabled = (project = ComposerAbstractAction.getValidProject(context = e.getDataContext())) != null;
        if (enabled) {
            enabled = this.getConfigFile(project, context, e.getPlace()) != null;
        }
        e.getPresentation().setEnabled(enabled);
        if (e.isFromContextMenu()) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ComposerAbstractAction.$$$reportNull$$$0(2);
        }
        DataContext context = e.getDataContext();
        Project project = ComposerAbstractAction.getValidProject(context);
        VirtualFile configFile = this.getConfigFile(project, context, e.getPlace());
        if (project != null && configFile != null) {
            this.act(project, configFile, e.getPlace());
        }
    }

    public final void act(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        ComposerDataService service;
        if (project == null) {
            ComposerAbstractAction.$$$reportNull$$$0(3);
        }
        if (configFile == null) {
            ComposerAbstractAction.$$$reportNull$$$0(4);
        }
        if (placeForStatistics == null) {
            ComposerAbstractAction.$$$reportNull$$$0(5);
        }
        if (!(service = ComposerDataService.getInstance(project)).askForValidConfigurationIfNeeded()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(configFile);
        if (document != null) {
            documentManager.saveDocument(document);
        }
        this.doPerformAction(project, configFile, placeForStatistics);
    }

    protected abstract void doPerformAction(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3);

    public abstract String getCommand();

    @Nullable
    private VirtualFile getConfigFile(Project project, DataContext context, @Nullable String place) {
        if (this.isAllowedPlace(place)) {
            VirtualFile file;
            String configPath = ComposerDataService.getInstance(project).getConfigPath();
            if (configPath != null && (file = LocalFileSystem.getInstance().findFileByPath(configPath)) != null) {
                return file;
            }
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (file != null && "composer.json".equals(file.getName())) {
            return file;
        }
        return null;
    }

    protected boolean isAllowedPlace(@Nullable String place) {
        return ActionPlaces.isMainMenuOrActionSearch((String)place);
    }

    @Nullable
    static Project getValidProject(DataContext context) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null || project.isDisposed() || project.isDefault()) {
            return null;
        }
        return project;
    }

    public static void refreshConfigAndLockFiles(@NotNull VirtualFile configFile, @Nullable Runnable afterRefresh) {
        if (configFile == null) {
            ComposerAbstractAction.$$$reportNull$$$0(6);
        }
        VirtualFile parent = configFile.getParent();
        parent.refresh(true, false, () -> {
            ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
            VirtualFile lockFile = parent.findChild("composer.lock");
            if (lockFile != null) {
                filesToRefresh.add(lockFile);
            }
            filesToRefresh.add(configFile);
            LocalFileSystem.getInstance().refreshFiles(filesToRefresh, true, false, afterRefresh);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerAbstractAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerAbstractAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "act";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshConfigAndLockFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

