/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.configData;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackageComposerConfigClient
implements ComposerConfigClient<String> {
    private final String myFrameworkPackage;
    private final String myRelativePath;

    protected PackageComposerConfigClient(@NotNull String frameworkPackage, @NotNull String relativePath) {
        if (frameworkPackage == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(1);
        }
        this.myFrameworkPackage = frameworkPackage;
        this.myRelativePath = relativePath;
    }

    @Override
    public String parse(@NotNull Project project, @NotNull Map<String, JsonElement> elements, @NotNull VirtualFile config) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(3);
        }
        if (config == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(4);
        }
        for (JsonElement element : elements.values()) {
            JsonObject object;
            JsonElement require;
            if (element == null || !element.isJsonObject() || (require = (object = element.getAsJsonObject()).get(this.myFrameworkPackage)) == null || !require.isJsonPrimitive()) continue;
            return require.getAsString();
        }
        return null;
    }

    public boolean hasPackage(@NotNull Project project, @NotNull JsonElement composerRoot, @NotNull VirtualFile config) {
        JsonObject rootObject;
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(5);
        }
        if (composerRoot == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(6);
        }
        if (config == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(7);
        }
        JsonObject jsonObject = rootObject = composerRoot.isJsonObject() ? composerRoot.getAsJsonObject() : null;
        if (rootObject == null) {
            return false;
        }
        for (String path : this.getPath()) {
            JsonElement pathElement = rootObject.get(path);
            if (pathElement == null || this.parse(project, (Map)Map.of(path, pathElement), config) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void consume(String version, @NotNull Project project) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)version)) {
            return;
        }
        String interpreterId = ComposerDataService.getInstance(project).getComposerExecution().getInterpreterId();
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
        this.updateSettings(project, interpreter, null);
    }

    @NotNull
    public String getExecutablePath(@NotNull String vendorPath) {
        if (vendorPath == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(9);
        }
        String string = vendorPath + "/" + StringUtil.trimStart((String)PathUtil.toSystemIndependentName((String)this.myRelativePath), (String)"/");
        if (string == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    protected String findFromComposerVendor(@NotNull Project project, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(11);
        }
        return this.findFromComposerVendor(project, this.myRelativePath, composerConfig);
    }

    @Nullable
    protected String findFromComposerVendor(@NotNull Project project, @NotNull String relativePath, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(12);
        }
        if (relativePath == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(13);
        }
        relativePath = StringUtil.trimStart((String)PathUtil.toSystemIndependentName((String)relativePath), (String)"/");
        VirtualFile vendor = ComposerLibraryServiceFactory.getInstance(project, composerConfig).refreshVendorDir(true, null);
        return vendor != null ? vendor.getPath() + "/" + relativePath : null;
    }

    protected void notify(@NotNull Project project, @NotNull String displayName, @Nullable ComposerLogMessageBuilder.Settings settings) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(14);
        }
        if (displayName == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(15);
        }
        String title = PhpBundle.message("framework.composer.packages.were.changed.0.test.config.title", new Object[0]);
        String message = PhpBundle.message("framework.composer.packages.were.changed.0.test.config.popup", displayName);
        ComposerLogService.getInstance(project).report(title + ". " + message, settings, true, null, false);
    }

    @Override
    @NotNull
    public List<String> getPath() {
        List<String> list = List.of("require", "require-dev");
        if (list == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(16);
        }
        return list;
    }

    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile config) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(17);
        }
    }

    public static void updatePackagesSettings(@NotNull Project project, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            PackageComposerConfigClient.$$$reportNull$$$0(18);
        }
        if (project.isDisposed()) {
            return;
        }
        String interpreterId = ComposerDataService.getInstance(project).getComposerExecution().getInterpreterId();
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
        for (ComposerConfigClient client : (ComposerConfigClient[])EP_NAME.getExtensions()) {
            if (!(client instanceof PackageComposerConfigClient)) continue;
            PackageComposerConfigClient i = (PackageComposerConfigClient)client;
            i.updateSettings(project, interpreter, composerConfig);
        }
    }

    @Nullable
    public ComposerLogMessageBuilder.Settings getSettings() {
        return null;
    }

    public String getFrameworkPackage() {
        return this.myFrameworkPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkPackage";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendorPath";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/configData/PackageComposerConfigClient";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/configData/PackageComposerConfigClient";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutablePath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasPackage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExecutablePath";
                break;
            }
            case 10: 
            case 16: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findFromComposerVendor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateSettings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updatePackagesSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 16 -> new IllegalStateException(string);
        };
    }
}

