/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.update.ComposerAvailablePackageVersionsService;
import com.jetbrains.php.composer.actions.update.ComposerConfigFileListener;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesService;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.composer.json.ComposerInstallNotifier;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.composer.lib.ComposerLibraryStartupActivityKt;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\"\u0018\u0010\u0000\u001a\f0\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\u0002\b\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"COMPOSER_VENDORS_LIBRARY_NAME", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getConfigListeners", "", "Lcom/jetbrains/php/composer/actions/update/ComposerConfigFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "deleteLibrary", "", "libraryName", "module", "Lcom/intellij/openapi/module/Module;", "listenToStubsChanges", "composerLibraryService", "Lcom/jetbrains/php/composer/lib/ComposerLibraryService;", "listenToVendorChanges", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nComposerLibraryStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerLibraryStartupActivity.kt\ncom/jetbrains/php/composer/lib/ComposerLibraryStartupActivityKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class ComposerLibraryStartupActivityKt {
    @NotNull
    private static final String COMPOSER_VENDORS_LIBRARY_NAME;

    @NotNull
    public static final Collection<ComposerConfigFileListener> getConfigListeners(@NotNull Project project, @Nullable VirtualFile context) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List $this$getConfigListeners_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (project.isOpen()) {
            UtilKt.addIfNotNull((List)$this$getConfigListeners_u24lambda_u240, (Object)ComposerInstalledPackagesService.getInstance(project, context));
            UtilKt.addIfNotNull((List)$this$getConfigListeners_u24lambda_u240, (Object)ComposerAvailablePackageVersionsService.Companion.getInstance(project, context));
            if (Intrinsics.areEqual((Object)ComposerConfigManager.Companion.getInstance(project).getMainConfig(), (Object)context)) {
                UtilKt.addIfNotNull((List)$this$getConfigListeners_u24lambda_u240, (Object)ComposerInstallNotifier.getInstance(project));
            }
        }
        return CollectionsKt.build((List)list);
    }

    public static final void deleteLibrary(@NotNull String libraryName, @NotNull Module module) {
        Object object;
        LibraryTable.ModifiableModel libraryTableModel;
        ModifiableRootModel model;
        block2: {
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getModifiableModel(...)");
            model = modifiableRootModel;
            LibraryTable.ModifiableModel modifiableModel = model.getModuleLibraryTable().getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"getModifiableModel(...)");
            libraryTableModel = modifiableModel;
            Library[] libraryArray = libraryTableModel.getLibraries();
            Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getLibraries(...)");
            for (Object object2 : (Object[])libraryArray) {
                Library it = (Library)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)libraryName, (Object)it.getName())) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        Library phpLibrary = (Library)object;
        if (phpLibrary == null) {
            model.dispose();
            return;
        }
        libraryTableModel.removeLibrary(phpLibrary);
        libraryTableModel.commit();
        model.commit();
    }

    private static final void listenToStubsChanges(Project project, ComposerLibraryService composerLibraryService) {
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)composerLibraryService);
        Topic<PhpRuntimeConfiguration.DefaultStubsPathListener> topic = PhpRuntimeConfiguration.DefaultStubsPathListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new PhpRuntimeConfiguration.DefaultStubsPathListener(composerLibraryService){
            final /* synthetic */ ComposerLibraryService $composerLibraryService;
            {
                this.$composerLibraryService = $composerLibraryService;
            }

            public void pathChanged(String oldPath, String newPath) {
                VirtualFile virtualFile;
                VirtualFile oldFile;
                if (!this.$composerLibraryService.isUpdatingLibrary()) {
                    return;
                }
                VirtualFile virtualFile2 = this.$composerLibraryService.getStubsFileFromComposer();
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile stubsFileFromComposer = virtualFile2;
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
                LocalFileSystem fileSystem = localFileSystem;
                if (StringUtil.isEmpty((String)oldPath)) {
                    v2 = null;
                } else {
                    String string = oldPath;
                    Intrinsics.checkNotNull((Object)string);
                    v2 = oldFile = fileSystem.findFileByPath(string);
                }
                if (StringUtil.isEmpty((String)newPath)) {
                    virtualFile = null;
                } else {
                    String string = newPath;
                    Intrinsics.checkNotNull((Object)string);
                    virtualFile = fileSystem.findFileByPath(string);
                }
                VirtualFile newFile = virtualFile;
                boolean isOldStub = Intrinsics.areEqual((Object)stubsFileFromComposer, (Object)oldFile);
                boolean isNewStub = Intrinsics.areEqual((Object)stubsFileFromComposer, (Object)newFile);
                if (isOldStub == isNewStub) {
                    return;
                }
                this.$composerLibraryService.resetLibrariesAndExcludedPaths(CollectionsKt.emptyList(), SetsKt.emptySet(), true, true);
            }
        });
    }

    private static final void listenToVendorChanges(Project project, Disposable disposable) {
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(disposable);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    VirtualFile containingDir;
                    VirtualFile file;
                    if (!(vFileEvent instanceof VFileCreateEvent) || (file = ((VFileCreateEvent)vFileEvent).getFile()) == null || !file.isDirectory()) continue;
                    ComposerLibraryService libraryManager = ComposerLibraryServiceFactory.Companion.getInstance(this.$project, file);
                    VirtualFile vendorDir = libraryManager.getVendorDir();
                    if (libraryManager.getConfig() == null || vendorDir == null) continue;
                    if (Intrinsics.areEqual((Object)vendorDir, (Object)file)) {
                        VirtualFile[] virtualFileArray = file.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                        if (!(((Object[])virtualFileArray).length == 0)) {
                            VirtualFile virtualFile = libraryManager.getConfig();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getConfig(...)");
                            this.afterVendorChanged(virtualFile);
                            return;
                        }
                    }
                    if (!Intrinsics.areEqual((Object)vendorDir, (Object)(containingDir = file.getParent()))) continue;
                    VirtualFile[] virtualFileArray = file.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                    if (!(!(((Object[])virtualFileArray).length == 0))) continue;
                    VirtualFile virtualFile = libraryManager.getConfig();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getConfig(...)");
                    this.afterVendorChanged(virtualFile);
                    return;
                }
            }

            private final void afterVendorChanged(VirtualFile composerConfig) {
                ComposerUtils.refreshVendorDir(composerConfig);
                ComposerAbstractAction.refreshConfigAndLockFiles(composerConfig, () -> listenToVendorChanges.1.afterVendorChanged$lambda$0(this.$project, composerConfig));
            }

            private static final void afterVendorChanged$lambda$0(Project $project, VirtualFile $composerConfig) {
                PackageComposerConfigClient.updatePackagesSettings($project, $composerConfig);
            }
        });
    }

    public static final /* synthetic */ void access$listenToStubsChanges(Project project, ComposerLibraryService composerLibraryService) {
        ComposerLibraryStartupActivityKt.listenToStubsChanges(project, composerLibraryService);
    }

    public static final /* synthetic */ void access$listenToVendorChanges(Project project, Disposable disposable) {
        ComposerLibraryStartupActivityKt.listenToVendorChanges(project, disposable);
    }

    public static final /* synthetic */ String access$getCOMPOSER_VENDORS_LIBRARY_NAME$p() {
        return COMPOSER_VENDORS_LIBRARY_NAME;
    }

    static {
        String string = PhpBundle.message("framework.composer.vendors.library.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        COMPOSER_VENDORS_LIBRARY_NAME = string;
    }
}

