/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerJsonForm;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.run.ComposerScriptRunConfigurationEditor;
import com.jetbrains.php.composer.run.ComposerScriptRunConfigurationSettings;
import com.jetbrains.php.run.PhpRunConfiguration;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerScriptRunConfiguration
extends PhpRunConfiguration<ComposerScriptRunConfigurationSettings> {
    protected ComposerScriptRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(2);
        }
        super(project, factory, name);
    }

    @Override
    @NotNull
    protected ComposerScriptRunConfigurationSettings createSettings() {
        ComposerScriptRunConfigurationSettings settings = new ComposerScriptRunConfigurationSettings();
        settings.setPathToComposerJson(ComposerDataService.getInstance(this.getProject()).getConfigPath());
        ComposerScriptRunConfigurationSettings composerScriptRunConfigurationSettings = settings;
        if (composerScriptRunConfigurationSettings == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(3);
        }
        return composerScriptRunConfigurationSettings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new ComposerScriptRunConfigurationEditor(this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        ComposerScriptRunConfigurationSettings settings = (ComposerScriptRunConfigurationSettings)this.getSettings();
        ValidationInfo validationInfo = ComposerJsonForm.validateComposerJsonPath(settings.getPathToComposerJson(), null, this.getProject());
        if (validationInfo != null) {
            throw new RuntimeConfigurationError(validationInfo.message);
        }
        if (StringUtil.isEmpty((String)settings.getScript())) {
            throw new RuntimeConfigurationError(PhpBundle.message("framework.composer.run.script.missing", new Object[0]));
        }
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        ComposerScriptRunConfigurationSettings settings;
        String pathToComposerJson;
        VirtualFile configFile;
        if (executor == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(5);
        }
        if ((configFile = VfsUtil.findFileByIoFile((File)new File(pathToComposerJson = (settings = (ComposerScriptRunConfigurationSettings)this.getSettings()).getPathToComposerJson()), (boolean)true)) == null) {
            throw new ExecutionException(PhpBundle.message("framework.composer.file.0.is.not.found", pathToComposerJson));
        }
        return this.createState(settings, configFile);
    }

    @NotNull
    public RunProfileState createState(final @NotNull ComposerScriptRunConfigurationSettings settings, final @NotNull VirtualFile configFile) {
        if (settings == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(6);
        }
        if (configFile == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(7);
        }
        return new RunProfileState(){

            public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                Project project;
                if (runner == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ComposerUtils.isProjectUntrusted(project = ComposerScriptRunConfiguration.this.getProject())) {
                    return null;
                }
                ComposerDataService service = ComposerDataService.getInstance(project);
                if (!service.askForValidConfigurationIfNeeded()) {
                    return null;
                }
                List<String> command = ComposerScriptRunConfiguration.collectCommand(settings);
                ComposerExecution execution = service.getComposerExecution();
                String workingDirectory = configFile.getParent().getPath();
                ProcessHandler processHandler = execution.createProcessHandler(project, workingDirectory, command, StringUtil.join(command, (String)" "));
                ConsoleViewImpl console = new ConsoleViewImpl(project, true);
                console.attachToProcess(processHandler);
                return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/jetbrains/php/composer/run/ComposerScriptRunConfiguration$1", "execute"));
            }
        };
    }

    @NotNull
    private static List<String> collectCommand(@NotNull ComposerScriptRunConfigurationSettings settings) {
        String commandLineParameters;
        if (settings == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(8);
        }
        List options = (commandLineParameters = settings.getCommandLineParameters()) == null ? Collections.emptyList() : ParametersListUtil.parse((String)commandLineParameters);
        List<String> list = ComposerUtils.getRunScriptCommand(settings.getScript(), options);
        if (list == null) {
            ComposerScriptRunConfiguration.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/run/ComposerScriptRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/run/ComposerScriptRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9 -> new IllegalStateException(string);
        };
    }
}

