/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.config.PhpInterpreterBasedConfig;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectSharedConfiguration;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.PhpProjectWorkspaceConfigurationListener;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersConfigurable;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpreterConfigurationForm
implements Disposable {
    private JPanel myMainPanel;
    private JBLabel myInterpreterLabel;
    protected JPanel myCustomizablePanel;
    protected PhpInterpreterComboBox myInterpreterComboBox;
    protected Project myProject;
    protected PhpInterpreterBasedConfig myInterpreterBasedConfig;
    private boolean myIsEditable;

    public PhpInterpreterConfigurationForm(@NotNull Project project, final @NotNull PhpInterpreterBasedConfig config) {
        if (project == null) {
            PhpInterpreterConfigurationForm.$$$reportNull$$$0(0);
        }
        if (config == null) {
            PhpInterpreterConfigurationForm.$$$reportNull$$$0(1);
        }
        this.myIsEditable = true;
        this.myProject = project;
        this.myInterpreterBasedConfig = config;
        this.$$$setupUI$$$();
        PhpInterpretersManagerImpl.getInstance(this.myProject);
        this.initBrowseAction(project, config);
        this.myInterpreterLabel.setLabelFor((Component)((Object)this.myInterpreterComboBox));
        if (this.myProject.isInitialized()) {
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(PhpProjectSharedConfiguration.StateChangedListener.TOPIC, (Object)new PhpProjectSharedConfiguration.StateChangedListener(){

                public void stateChanged() {
                    String name = config.getInterpreterName();
                    if (StringUtil.isNotEmpty((String)name)) {
                        PhpInterpreterConfigurationForm.this.myInterpreterComboBox.reset(name);
                    }
                    PhpInterpreterConfigurationForm.this.onInterpreterChange();
                }
            });
        }
        this.showCustomizablePanel(false);
        Disposer.register((Disposable)this, (Disposable)this.myInterpreterComboBox);
    }

    private void initBrowseAction(final @NotNull Project project, final @NotNull PhpInterpreterBasedConfig config) {
        if (project == null) {
            PhpInterpreterConfigurationForm.$$$reportNull$$$0(2);
        }
        if (config == null) {
            PhpInterpreterConfigurationForm.$$$reportNull$$$0(3);
        }
        this.myInterpreterComboBox.setProject(project);
        this.myInterpreterComboBox.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName;
                String oldName;
                PhpInterpreter updated;
                PhpInterpretersConfigurable configurable = new PhpInterpretersConfigurable(project, PhpInterpreterConfigurationForm.this.myInterpreterComboBox.getSelectedItemName());
                PhpInterpreter oldSelected = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(config.getInterpreterName());
                boolean isOk = PhpUiUtil.editConfigurable(project, (Configurable)configurable);
                if (isOk && oldSelected != null && (updated = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(oldSelected.getId())) != null && !StringUtil.equals((CharSequence)(oldName = oldSelected.getName()), (CharSequence)(newName = updated.getName()))) {
                    PhpProjectConfigurationFacade.getInstance(project).onSelectedInterpreterRename(config, oldName, newName);
                }
                if (isOk && PhpInterpreterConfigurationForm.this.myIsEditable) {
                    PhpInterpreterConfigurationForm.this.myInterpreterComboBox.reset(configurable.getLastSelectedItemName());
                } else {
                    PhpInterpreterConfigurationForm.this.myInterpreterComboBox.reset();
                }
            }
        });
    }

    public void setInterpreterEditable(boolean editable) {
        this.myIsEditable = editable;
        this.myInterpreterComboBox.getComboBox().setEnabled(editable);
    }

    @NotNull
    public JPanel getMainComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpInterpreterConfigurationForm.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    protected void onInterpreterChange() {
    }

    public void showCustomizablePanel(boolean show) {
        this.myCustomizablePanel.setVisible(show);
    }

    public void setAnchor(JComponent anchor) {
        this.myInterpreterLabel.setAnchor(anchor);
    }

    @Nullable
    public String getInterpreterName() {
        return this.myInterpreterComboBox.getSelectedItemName();
    }

    public void addInterpreterListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            PhpInterpreterConfigurationForm.$$$reportNull$$$0(5);
        }
        this.myInterpreterComboBox.addChangeListener(listener);
    }

    @Nullable
    public PhpInterpreter findSelectedInterpreter() {
        return PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreter(this.getInterpreterName());
    }

    @Nullable
    public PhpSdkAdditionalData findSelectedInterpreterData() {
        PhpInterpreter interpreter = this.findSelectedInterpreter();
        return interpreter == null ? null : interpreter.getPhpSdkAdditionalData();
    }

    private void createUIComponents() {
        this.myInterpreterComboBox = this.createInterpreterComboBox();
    }

    @NotNull
    protected PhpInterpreterComboBox createInterpreterComboBox() {
        return new PhpInterpreterComboBox(null, null, false);
    }

    public void dispose() {
        this.myInterpreterBasedConfig = null;
    }

    public boolean isModified() {
        String oldInterpreter = StringUtil.notNullize((String)this.myInterpreterBasedConfig.getInterpreterName());
        return !StringUtil.notNullize((String)this.getInterpreterName()).equals(oldInterpreter);
    }

    public void apply() {
        String oldInterpreterName = this.myInterpreterBasedConfig.getInterpreterName();
        String newInterpreterName = this.getInterpreterName();
        if (!StringUtil.notNullize((String)newInterpreterName).equals(StringUtil.notNullize((String)oldInterpreterName))) {
            this.myInterpreterBasedConfig.setInterpreterName(newInterpreterName);
            ((PhpProjectWorkspaceConfigurationListener)this.myProject.getMessageBus().syncPublisher(PhpProjectWorkspaceConfiguration.TOPIC)).interpreterChanged();
        }
    }

    public void reset() {
        this.myInterpreterComboBox.reset(this.myInterpreterBasedConfig.getInterpreterName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpInterpreterConfigurationForm";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpInterpreterConfigurationForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initBrowseAction";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addInterpreterListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.createUIComponents();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        PhpInterpreterComboBox phpInterpreterComboBox = this.myInterpreterComboBox;
        jPanel4.add((Component)((Object)phpInterpreterComboBox), "Center");
        this.myInterpreterLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpInterpreterConfigurationForm.class).getString("PhpProjectConfigurable.interpreter"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomizablePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

