/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCache;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoUtil;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Pair;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpInterpretersPhpInfoCacheBase
implements PersistentStateComponent<Element>,
PhpInterpretersPhpInfoCache {
    private static final String PHPINFO = "phpinfo";
    private static final String PHP_INFO_CACHE = "phpInfoCache";
    private static final String INTERPRETER = "interpreter";
    private static final String NAME = "name";
    private static final String ROOT = "root";
    private final Map<String, PhpInfo> myPhpInfoCache = new HashMap<String, PhpInfo>();

    @Override
    @NotNull
    public Map<String, PhpInfo> getPhpInfoCache() {
        Map<String, PhpInfo> map = this.myPhpInfoCache;
        if (map == null) {
            PhpInterpretersPhpInfoCacheBase.$$$reportNull$$$0(0);
        }
        return map;
    }

    public Element getState() {
        Element root = new Element(ROOT);
        if (this.myPhpInfoCache.isEmpty()) {
            return root;
        }
        Element element = new Element(PHP_INFO_CACHE);
        for (Map.Entry<String, PhpInfo> cache : this.myPhpInfoCache.entrySet()) {
            Element interpreter = new Element(INTERPRETER);
            interpreter.setAttribute(NAME, cache.getKey());
            interpreter.addContent(XmlSerializer.serialize((Object)cache.getValue()));
            element.addContent(interpreter);
        }
        root.addContent(element);
        return root;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            PhpInterpretersPhpInfoCacheBase.$$$reportNull$$$0(1);
        }
        this.myPhpInfoCache.clear();
        Element cache = element.getChild(PHP_INFO_CACHE);
        if (cache == null) {
            return;
        }
        List children = cache.getChildren(INTERPRETER);
        for (Object child : children) {
            Element interpreterElement = (Element)child;
            String name = interpreterElement.getAttributeValue(NAME);
            Element infoElement = interpreterElement.getChild(PHPINFO);
            PhpInfo info = (PhpInfo)XmlSerializer.deserialize((Element)infoElement, PhpInfo.class);
            if (!StringUtil.isNotEmpty((String)name)) continue;
            List<PhpDebuggerInfo> debugger = info.getDebuggers();
            if (debugger.isEmpty()) {
                String debuggerName = infoElement.getAttributeValue("debugger");
                String version = infoElement.getAttributeValue("debugger_version");
                if (StringUtil.isNotEmpty((String)debuggerName)) {
                    debugger.add(new PhpDebuggerInfo(debuggerName, version, null));
                }
            }
            this.myPhpInfoCache.put(name, info);
        }
    }

    @Override
    public void setPhpInfo(@NotNull String interpreterName, @Nullable PhpInfo phpInfo) {
        if (interpreterName == null) {
            PhpInterpretersPhpInfoCacheBase.$$$reportNull$$$0(2);
        }
        Map<String, PhpInfo> phpInfoCache = this.getPhpInfoCache();
        if (phpInfo == null) {
            phpInfoCache.remove(interpreterName);
        } else {
            phpInfoCache.put(interpreterName, phpInfo);
        }
    }

    @Override
    @Nullable
    public PhpInfo getPhpInfo(@Nullable String interpreterName) {
        return interpreterName == null ? null : this.getPhpInfoCache().get(interpreterName);
    }

    public void removePhpInfo(@Nullable String interpreterName) {
        if (interpreterName != null) {
            this.getPhpInfoCache().remove(interpreterName);
        }
    }

    @Override
    @Nullable
    public PhpInfo updateAnGet(@NotNull Project project, @Nullable String interpreterName, @Nullable JComponent parentComponent) {
        Pair<PhpInfo, PhpNonPersistedInfo> info;
        if (project == null) {
            PhpInterpretersPhpInfoCacheBase.$$$reportNull$$$0(3);
        }
        return (info = this.updateAnGetWholeInfo(project, interpreterName, parentComponent)) == null ? null : (PhpInfo)info.getFirst();
    }

    @Override
    @Nullable
    public Pair<PhpInfo, PhpNonPersistedInfo> updateAnGetWholeInfo(@NotNull Project project, @Nullable String interpreterName, @Nullable JComponent parentComponent) {
        if (project == null) {
            PhpInterpretersPhpInfoCacheBase.$$$reportNull$$$0(4);
        }
        if (interpreterName == null) {
            return null;
        }
        Pair<PhpInfo, PhpNonPersistedInfo> phpInfo = null;
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
        if (interpreter != null) {
            if (!this.canUpdateInfo(interpreter)) {
                return null;
            }
            phpInfo = PhpInfoUtil.getWholePhpInfo(project, interpreter, parentComponent);
        }
        this.setPhpInfo(interpreterName, phpInfo == null ? null : (PhpInfo)phpInfo.getFirst());
        return phpInfo;
    }

    protected abstract boolean canUpdateInfo(@NotNull PhpInterpreter var1);

    @Override
    public void clear() {
        this.getPhpInfoCache().clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpretersPhpInfoCacheBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpInfoCache";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersPhpInfoCacheBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPhpInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateAnGet";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateAnGetWholeInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

