/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpInterpreterConfigurationActivity;
import com.jetbrains.php.config.interpreters.PhpInterpreterDecorator;
import com.jetbrains.php.config.interpreters.PhpLocalInterpreterDecorator;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSdkAdditionalData
implements SdkAdditionalData {
    public static final String DEFAULT_NAME = "PHP";
    public static final String DEBUGGER_ID = "debugger_id";
    public static final String DEBUGGER_EXTENSION = "debugger_extension";
    public static final String CUSTOM_INI = "custom_ini";
    public static final String CONFIGURATION_OPTIONS = "configuration_options";
    @Nullable
    private String myDebuggerId = "php.debugger.XDebug";
    @Nullable
    private String myDebuggerExtension = null;
    @Nullable
    private String myInterpreterId;
    @Nullable
    private String myCustomIniPath;
    @NotNull
    protected List<PhpConfigurationOptionData> myConfigurationOptions = new ArrayList<PhpConfigurationOptionData>();

    @Nullable
    public String getDebuggerId() {
        return this.myDebuggerId;
    }

    public void setDebuggerId(@Nullable String debuggerId) {
        this.myDebuggerId = debuggerId;
    }

    @Nullable
    public String getDebuggerExtension() {
        return this.myDebuggerExtension;
    }

    public void setDebuggerExtension(@Nullable String debuggerExtension) {
        this.myDebuggerExtension = debuggerExtension;
    }

    @Nullable
    public String getInterpreterId() {
        return this.myInterpreterId;
    }

    public void setInterpreterId(@Nullable String interpreterId) {
        this.myInterpreterId = interpreterId;
    }

    @Nullable
    public String getCustomIniPath() {
        return this.myCustomIniPath;
    }

    public void setCustomIniPath(@Nullable String customIniPath) {
        this.myCustomIniPath = customIniPath;
    }

    @NotNull
    public List<PhpConfigurationOptionData> getConfigurationOptions() {
        return PhpSdkAdditionalData.cloneConfigurationOptions(this.myConfigurationOptions);
    }

    public void setConfigurationOptions(@NotNull List<PhpConfigurationOptionData> configurationOptions) {
        if (configurationOptions == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(0);
        }
        this.myConfigurationOptions = PhpSdkAdditionalData.cloneConfigurationOptions(configurationOptions);
    }

    @NotNull
    public static List<PhpConfigurationOptionData> cloneConfigurationOptions(@NotNull List<? extends PhpConfigurationOptionData> configurationOptions) {
        List options;
        if (configurationOptions == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(1);
        }
        List list = (options = ContainerUtil.map(configurationOptions, PhpConfigurationOptionData.CLONE_FUNCTION)).isEmpty() ? new ArrayList() : options;
        if (list == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NlsContexts.DialogMessage
    @Nullable
    public String validate(@Nullable Project project, @Nullable JComponent parent) {
        return null;
    }

    @NotNull
    public PhpInterpreterDecorator getDecorator() {
        PhpLocalInterpreterDecorator phpLocalInterpreterDecorator = PhpLocalInterpreterDecorator.INSTANCE;
        if (phpLocalInterpreterDecorator == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(3);
        }
        return phpLocalInterpreterDecorator;
    }

    @Nullable
    public String getPathToExecutable(@Nullable String homePath) {
        try {
            return PhpCommandSettingsBuilder.findPhpBinary(homePath).getPresentableUrl();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nls
    @NotNull
    public String suggestName(@Nullable PhpInfo phpInfo) {
        PhpLanguageLevel level;
        if (phpInfo != null && (level = PhpInterpreterConfigurationActivity.parse(phpInfo)) != null) {
            String string = "PHP " + level.getPresentableName();
            if (string == null) {
                PhpSdkAdditionalData.$$$reportNull$$$0(4);
            }
            return string;
        }
        return DEFAULT_NAME;
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(5);
        }
        rootElement.setAttribute(DEBUGGER_ID, StringUtil.notNullize((String)this.getDebuggerId()));
        if (StringUtil.isNotEmpty((String)this.getDebuggerExtension())) {
            rootElement.setAttribute(DEBUGGER_EXTENSION, this.getDebuggerExtension());
        }
        if (StringUtil.isNotEmpty((String)this.getCustomIniPath())) {
            rootElement.setAttribute(CUSTOM_INI, this.getCustomIniPath());
        }
        if (!this.myConfigurationOptions.isEmpty()) {
            Element options = new Element(CONFIGURATION_OPTIONS);
            for (PhpConfigurationOptionData option : this.myConfigurationOptions) {
                Element element = XmlSerializer.serialize((Object)option);
                options.addContent(element);
            }
            rootElement.addContent(options);
        }
    }

    @NotNull
    public static PhpSdkAdditionalData load(@Nullable Element element) {
        PhpSdkAdditionalData data = new PhpSdkAdditionalData();
        PhpSdkAdditionalData.load(data, element);
        PhpSdkAdditionalData phpSdkAdditionalData = data;
        if (phpSdkAdditionalData == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(6);
        }
        return phpSdkAdditionalData;
    }

    protected static void load(@NotNull PhpSdkAdditionalData data, @Nullable Element element) {
        if (data == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(7);
        }
        if (element != null) {
            Element options;
            Attribute customIni;
            Attribute debugger;
            Attribute debuggerId = element.getAttribute(DEBUGGER_ID);
            if (debuggerId != null && StringUtil.isNotEmpty((String)debuggerId.getValue())) {
                data.setDebuggerId(debuggerId.getValue());
            }
            if ((debugger = element.getAttribute(DEBUGGER_EXTENSION)) != null && StringUtil.isNotEmpty((String)debugger.getValue())) {
                data.setDebuggerExtension(debugger.getValue());
            }
            if ((customIni = element.getAttribute(CUSTOM_INI)) != null && StringUtil.isNotEmpty((String)customIni.getValue())) {
                data.setCustomIniPath(customIni.getValue());
            }
            if ((options = element.getChild(CONFIGURATION_OPTIONS)) != null) {
                ArrayList<PhpConfigurationOptionData> configurationOptions = new ArrayList<PhpConfigurationOptionData>();
                for (Element child : options.getChildren()) {
                    PhpConfigurationOptionData option = (PhpConfigurationOptionData)XmlSerializer.deserialize((Element)child, PhpConfigurationOptionData.class);
                    configurationOptions.add(option);
                }
                data.setConfigurationOptions(configurationOptions);
            }
        }
    }

    @NotNull
    public PhpSdkAdditionalData copy() {
        PhpSdkAdditionalData copy = new PhpSdkAdditionalData();
        this.copyTo(copy);
        PhpSdkAdditionalData phpSdkAdditionalData = copy;
        if (phpSdkAdditionalData == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(8);
        }
        return phpSdkAdditionalData;
    }

    protected void copyTo(@NotNull PhpSdkAdditionalData copy) {
        if (copy == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(9);
        }
        copy.setDebuggerId(this.getDebuggerId());
        copy.setDebuggerExtension(this.getDebuggerExtension());
        copy.setConfigurationOptions(this.getConfigurationOptions());
        copy.setCustomIniPath(this.getCustomIniPath());
    }

    public String toPresentablePath() {
        return "local";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpSdkAdditionalData data = (PhpSdkAdditionalData)o;
        if (!StringUtil.equals((CharSequence)this.myDebuggerId, (CharSequence)data.myDebuggerId)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myCustomIniPath, (CharSequence)data.myCustomIniPath)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myDebuggerExtension, (CharSequence)data.myDebuggerExtension)) {
            return false;
        }
        return this.myConfigurationOptions.equals(data.myConfigurationOptions);
    }

    public int hashCode() {
        int result = StringUtil.notNullize((String)this.myDebuggerId).hashCode();
        result += 31 * StringUtil.notNullize((String)this.myDebuggerExtension).hashCode();
        result += 31 * StringUtil.notNullize((String)this.myCustomIniPath).hashCode();
        for (PhpConfigurationOptionData option : this.myConfigurationOptions) {
            result += 31 * result + option.hashCode();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpSdkAdditionalData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpSdkAdditionalData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneConfigurationOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationOptions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cloneConfigurationOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 8 -> new IllegalStateException(string);
        };
    }
}

