/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters.herd;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpreterPath;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpretersManager;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpretersManagerKt;
import com.jetbrains.php.config.interpreters.herd.PhpHerdMainInterpreterPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"findInstalledLaravelHerdBinaries", "", "Lcom/jetbrains/php/config/interpreters/herd/PhpHerdInterpreterPath;", "isValidPhpBinary", "", "path", "Ljava/nio/file/Path;", "intellij.php.impl"})
public final class PhpHerdInterpretersManagerKt {
    @NotNull
    public static final List<PhpHerdInterpreterPath> findInstalledLaravelHerdBinaries() {
        if (!SystemInfo.isWindows && !SystemInfo.isMac) {
            return CollectionsKt.emptyList();
        }
        PhpHerdInterpretersManager herdInterpretersManager = PhpHerdInterpretersManager.Companion.getInstance();
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem localFileSystem2 = localFileSystem;
        Path path = Paths.get(herdInterpretersManager.getHerdDirectory() + "/bin", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path herdBinPath = path;
        if (!Files.isDirectory(herdBinPath, new LinkOption[0])) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)PathsKt.listDirectoryEntries$default((Path)herdBinPath, null, (int)1, null)), (Function1)findInstalledLaravelHerdBinaries.1.INSTANCE), arg_0 -> PhpHerdInterpretersManagerKt.findInstalledLaravelHerdBinaries$lambda$0(localFileSystem2, herdInterpretersManager, arg_0)));
    }

    private static final boolean isValidPhpBinary(Path path) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && PhpHerdInterpretersManager.Companion.getInstance().isValidPhpBinary(path);
    }

    private static final PhpHerdInterpreterPath findInstalledLaravelHerdBinaries$lambda$0(LocalFileSystem $localFileSystem, PhpHerdInterpretersManager $herdInterpretersManager, Path binaryFile) {
        PhpHerdInterpreterPath phpHerdInterpreterPath;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)binaryFile, (String)"binaryFile");
        VirtualFile virtualFile2 = virtualFile = $localFileSystem.findFileByPath(((Object)binaryFile).toString());
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            phpHerdInterpreterPath = $herdInterpretersManager.isMainLaravelHerdInterpreter(it) ? (PhpHerdInterpreterPath)new PhpHerdMainInterpreterPath(((Object)binaryFile.getFileName()).toString(), it) : new PhpHerdInterpreterPath(((Object)binaryFile.getFileName()).toString(), it);
        } else {
            boolean bl = false;
            ApplicationManager.getApplication().invokeLater(() -> PhpHerdInterpretersManagerKt.findInstalledLaravelHerdBinaries$lambda$0$1$0($localFileSystem, binaryFile));
            phpHerdInterpreterPath = null;
        }
        return phpHerdInterpreterPath;
    }

    private static final void findInstalledLaravelHerdBinaries$lambda$0$1$0(LocalFileSystem $localFileSystem, Path $binaryFile) {
        $localFileSystem.refreshAndFindFileByPath(((Object)$binaryFile).toString());
    }

    public static final /* synthetic */ boolean access$isValidPhpBinary(Path path) {
        return PhpHerdInterpretersManagerKt.isValidPhpBinary(path);
    }
}

