/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters.herd;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.herd.PhpHerdInterpretersManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/php/config/interpreters/herd/PhpWindowsHerdInterpretersManager;", "Lcom/jetbrains/php/config/interpreters/herd/PhpHerdInterpretersManager;", "<init>", "()V", "herdDirectory", "", "getHerdDirectory", "()Ljava/lang/String;", "herdXdebugDirectory", "getHerdXdebugDirectory", "mainInterpreterName", "getMainInterpreterName", "isValidPhpBinary", "", "path", "Ljava/nio/file/Path;", "isLaravelHerdInterpreter", "interpreter", "Lcom/jetbrains/php/config/interpreters/PhpInterpreter;", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpWindowsHerdInterpretersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpWindowsHerdInterpretersManager.kt\ncom/jetbrains/php/config/interpreters/herd/PhpWindowsHerdInterpretersManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,22:1\n1#2:23\n*E\n"})
public final class PhpWindowsHerdInterpretersManager
extends PhpHerdInterpretersManager {
    @NotNull
    private final String herdDirectory = FileUtil.toSystemIndependentName((String)System.getProperty("user.home")) + "/.config/herd";
    @NotNull
    private final String herdXdebugDirectory = FileUtil.toSystemIndependentName((String)System.getenv("ProgramFiles")) + "/Herd/resources/app.asar.unpacked/resources/bin/xdebug";
    @NotNull
    private final String mainInterpreterName;

    private PhpWindowsHerdInterpretersManager() {
        super(null);
        this.mainInterpreterName = "php.bat";
    }

    @Override
    @NotNull
    public String getHerdDirectory() {
        return this.herdDirectory;
    }

    @Override
    @NotNull
    public String getHerdXdebugDirectory() {
        return this.herdXdebugDirectory;
    }

    @Override
    @NotNull
    public String getMainInterpreterName() {
        return this.mainInterpreterName;
    }

    @Override
    public boolean isValidPhpBinary(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CharSequence charSequence = ((Object)path.getFileName()).toString();
        return new Regex("^php(\\d{2})?\\.bat$").matches(charSequence);
    }

    @Override
    public boolean isLaravelHerdInterpreter(@NotNull PhpInterpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        String string = interpreter.getHomePath();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            String string2 = FileUtil.toSystemIndependentName((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            bl = StringsKt.startsWith$default((String)string2, (String)this.getHerdDirectory(), (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }
}

