/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.config.library.PhpLibraryRoot;
import com.jetbrains.php.config.library.PhpLibraryRootProvider;
import com.jetbrains.php.config.library.PhpLibraryRootUtil;
import com.jetbrains.php.config.library.PhpRuntimeExtensionsEntity;
import com.jetbrains.php.config.library.PhpRuntimeRootEntityWorkspaceFileIndexContributor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRuntimeLibraryRootsProvider
extends IndexableSetContributor {
    private static final Logger LOG = Logger.getInstance(PhpRuntimeLibraryRootsProvider.class);
    private static final String GIT_VCS_NAME = "Git";
    private static final Key<SimpleModificationTracker> TRACKER = Key.create((String)"phpRuntimeLibraryRoots");

    private static boolean useWorkspaceModelForPhpRuntime() {
        return Registry.is((String)"php.use.workspace.model.for.runtime.support.configuration", (boolean)true);
    }

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> getAdditionalProjectRootsToIndex(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(1);
        }
        if (PhpRuntimeLibraryRootsProvider.useWorkspaceModelForPhpRuntime()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(2);
            }
            return set;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !PhpRuntimeLibraryRootsProvider.hasWebModules(project)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(3);
            }
            return set;
        }
        return PhpRuntimeLibraryRootsProvider.getLibraryRoots(project);
    }

    @NotNull
    private static StreamEx<VirtualFile> getLibraryRootsFromExtensionPoint(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(4);
        }
        Map<String, Boolean> extensions = PhpRuntimeConfiguration.getInstance(project).getExtensions();
        WorkspaceFileIndex workspaceFileIndex = WorkspaceFileIndex.getInstance((Project)project);
        StreamEx streamEx = (StreamEx)((StreamEx)((StreamEx)StreamEx.of(PhpRuntimeLibraryRootsProvider.getLibraryRootsBeforeFiltering(project)).peek(extension -> LOG.trace("Extension '" + extension.getName() + "' " + (extensions.getOrDefault(extension.getName(), true) != false ? "added" : "ignored")))).filter(extension -> extensions.getOrDefault(extension.getName(), true))).filter(extension -> (Boolean)ReadAction.nonBlocking(() -> workspaceFileIndex.findFileSet(extension, true, true, true, false, true, false) == null).executeSynchronously());
        if (streamEx == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(5);
        }
        return streamEx;
    }

    private static Stream<? extends VirtualFile> expandChildrenDirectories(VirtualFile e) {
        final ArrayList res = new ArrayList();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)e, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file.isDirectory()) {
                    res.add(file);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/config/library/PhpRuntimeLibraryRootsProvider$1", "visitFile"));
            }
        });
        return res.stream();
    }

    @NotNull
    public static Set<VirtualFile> getLibraryRootsBeforeFiltering(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(6);
        }
        LOG.trace("Collecting PHP Runtime modules...");
        Map modules = (Map)((StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Collection)PhpLibraryRoot.EP_NAME.getExtensionList()).map(PhpLibraryRoot::getProvider).peek(provider -> LOG.trace("Provider '" + String.valueOf(provider.getClass()) + "' from '" + PathUtil.getJarPathForClass((Class)provider.getClass()) + "'"))).filter(PhpLibraryRootProvider::isRuntime)).flatMap(provider -> provider.getLibraryRoots(project)).map(VirtualFile::getChildren).flatMap(Arrays::stream).filter(VirtualFile::isDirectory)).remove(module -> module.getName().startsWith("."))).peek(module -> LOG.trace("Module '" + module.getName() + "' " + (module.findChild(".ignore") == null ? "added" : "ignored")))).collect(Collectors.toMap(VirtualFile::getName, Function.identity(), (curr, next) -> next));
        Set<VirtualFile> set = modules.values().stream().filter(root -> root.findChild(".ignore") == null).collect(Collectors.toSet());
        if (set == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static boolean hasWebModules(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(8);
        }
        return ContainerUtil.or((Object[])ModuleManager.getInstance((Project)project).getModules(), ModuleTypeWithWebFeatures::isAvailable);
    }

    @NotNull
    public static Set<VirtualFile> getLibraryRoots(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(9);
        }
        if (PhpRuntimeLibraryRootsProvider.useWorkspaceModelForPhpRuntime()) {
            ImmutableEntityStorage current = WorkspaceModel.getInstance((Project)project).getCurrentSnapshot();
            Sequence urls = SequencesKt.flatMapIterable((Sequence)current.entities(PhpRuntimeExtensionsEntity.class), entity -> entity.getRoots());
            Sequence files = SequencesKt.mapNotNull((Sequence)urls, url -> VirtualFileUrls.getVirtualFile((VirtualFileUrl)url));
            Set set = SequencesKt.toSet((Sequence)files);
            if (set == null) {
                PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(10);
            }
            return set;
        }
        return PhpRuntimeLibraryRootsProvider.getLibraryRootsWithoutWorkspaceModel(project, false);
    }

    @NotNull
    private static Set<VirtualFile> getLibraryRootsWithoutWorkspaceModel(@NotNull Project project, boolean expanded) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(!PhpRuntimeLibraryRootsProvider.useWorkspaceModelForPhpRuntime());
        ProgressManager.checkCanceled();
        CachedValueProvider provider = expanded ? () -> PhpRuntimeLibraryRootsProvider.doGetRootsInternal(project, true) : () -> PhpRuntimeLibraryRootsProvider.doGetRootsInternal(project, false);
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, provider);
        if (set == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    private static CachedValueProvider.Result<Set<VirtualFile>> doGetRootsInternal(@NotNull Project project, boolean expanded) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(13);
        }
        LOG.assertTrue(!PhpRuntimeLibraryRootsProvider.useWorkspaceModelForPhpRuntime());
        Set roots = PhpRuntimeLibraryRootsProvider.getLibraryRootsFromExtensionPoint(project).flatMap(e -> expanded ? PhpRuntimeLibraryRootsProvider.expandChildrenDirectories(e) : Stream.of(e)).toSet();
        return PhpRuntimeLibraryRootsProvider.createCacheResult(roots, project, roots.toArray());
    }

    public static boolean isInStubRoots(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(14);
        }
        if (PhpRuntimeLibraryRootsProvider.useWorkspaceModelForPhpRuntime()) {
            return PhpRuntimeRootEntityWorkspaceFileIndexContributor.isUnderRuntimeRoot(project, file);
        }
        return PhpRuntimeLibraryRootsProvider.getLibraryRootsWithoutWorkspaceModel(project, true).contains(file.getParent());
    }

    @NotNull
    public static <T> CachedValueProvider.Result<T> createCacheResult(@Nullable T value, @NotNull Project project, Object ... deps) {
        SimpleModificationTracker tracker;
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(15);
        }
        if ((tracker = (SimpleModificationTracker)TRACKER.get((UserDataHolder)project)) == null) {
            tracker = new SimpleModificationTracker();
            TRACKER.set((UserDataHolder)project, (Object)tracker);
        }
        CachedValueProvider.Result result = CachedValueProvider.Result.create(value, (Object[])new Object[]{tracker, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, deps});
        if (result == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(16);
        }
        return result;
    }

    @Deprecated
    @Nullable
    public static VirtualFile findFile(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(17);
        }
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(18);
        }
        return PhpRuntimeLibraryRootsProvider.getLibraryRoots(project).stream().map(root -> root.findChild(name)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public static void firePhpRuntimeRootsChanged(@NotNull Project project, @NotNull Collection<VirtualFile> oldRoots) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(19);
        }
        if (oldRoots == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(20);
        }
        PhpRuntimeLibraryRootsProvider.ensureWorkspaceEntitiesAreUpToDate(project);
        if (!PhpRuntimeLibraryRootsProvider.useWorkspaceModelForPhpRuntime()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                PhpRuntimeLibraryRootsProvider.invalidateCache(project);
                Set<VirtualFile> newRoots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(project);
                String presentableLibraryName = PhpBundle.message("PhpProjectConfigurable.php.runtime", new Object[0]);
                AdditionalLibraryRootsListener.fireAdditionalLibraryChanged((Project)project, (String)presentableLibraryName, (Collection)oldRoots, newRoots, (String)presentableLibraryName);
            });
        }
    }

    private static void invalidateCache(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(21);
        }
        LOG.trace("Cache invalidated");
        SimpleModificationTracker tracker = (SimpleModificationTracker)TRACKER.get((UserDataHolder)project);
        if (tracker != null) {
            tracker.incModificationCount();
        }
    }

    public static void applyNewStubsPath(@NotNull String previousDefaultStubsPath, @NotNull String newDefaultStubsPath, @NotNull Project project) {
        if (previousDefaultStubsPath == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(22);
        }
        if (newDefaultStubsPath == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(23);
        }
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(24);
        }
        PhpRuntimeLibraryRootsProvider.closePreviousStubFiles(project);
        PhpRuntimeLibraryRootsProvider.updateGitMappings(previousDefaultStubsPath, newDefaultStubsPath, project);
    }

    private static void closePreviousStubFiles(@NotNull Project project) {
        Predicate<VirtualFile> isFromStubs;
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(25);
        }
        if (PhpRuntimeLibraryRootsProvider.useWorkspaceModelForPhpRuntime()) {
            isFromStubs = file -> PhpRuntimeRootEntityWorkspaceFileIndexContributor.isUnderRuntimeRoot(project, file);
        } else {
            Set<VirtualFile> roots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(project);
            if (roots.isEmpty()) {
                return;
            }
            isFromStubs = file -> VfsUtilCore.isUnder((VirtualFile)file, (Set)roots);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (fileEditorManager != null) {
            ((StreamEx)((StreamEx)StreamEx.of((Object[])EditorFactory.getInstance().getAllEditors()).filter(editor -> editor.getProject() == project)).select(EditorEx.class).map(EditorEx::getVirtualFile).nonNull().filter(isFromStubs)).forEach(arg_0 -> ((FileEditorManager)fileEditorManager).closeFile(arg_0));
        }
    }

    private static void updateGitMappings(@NotNull String previousDefaultStubsPath, @NotNull String newDefaultStubsPath, @NotNull Project project) {
        VirtualFile git;
        VirtualFile file;
        if (previousDefaultStubsPath == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(26);
        }
        if (newDefaultStubsPath == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(27);
        }
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(28);
        }
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        List mappings = manager.getDirectoryMappings();
        if (!previousDefaultStubsPath.isEmpty()) {
            mappings = ContainerUtil.filter((Collection)mappings, mapping -> !mapping.getVcs().equals(GIT_VCS_NAME) || !mapping.getDirectory().equals(previousDefaultStubsPath));
        }
        if (!newDefaultStubsPath.isEmpty() && (file = VfsUtil.findFileByIoFile((File)new File(newDefaultStubsPath), (boolean)true)) != null && (git = file.findChild(".git")) != null && git.isDirectory()) {
            mappings = VcsUtil.addMapping((List)mappings, (String)newDefaultStubsPath, (String)GIT_VCS_NAME);
        }
        if (!previousDefaultStubsPath.isEmpty() || !newDefaultStubsPath.isEmpty()) {
            manager.setDirectoryMappings(mappings);
        }
    }

    public static void projectOpened(Project project) {
        PhpRuntimeLibraryRootsProvider.ensureWorkspaceEntitiesAreUpToDate(project);
        if (!ApplicationManager.getApplication().isUnitTestMode() || PhpRuntimeLibraryRootsProvider.hasWebModules(project)) {
            return;
        }
        project.getMessageBus().connect().subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void modulesAdded(@NotNull Project project, @NotNull List<? extends Module> modules) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (modules == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!ContainerUtil.exists(modules, ModuleTypeWithWebFeatures::isAvailable)) {
                    return;
                }
                for (Module otherModule : ModuleManager.getInstance((Project)project).getModules()) {
                    if (!ModuleTypeWithWebFeatures.isAvailable((Module)otherModule) || modules.contains(otherModule)) continue;
                    return;
                }
                PhpRuntimeLibraryRootsProvider.firePhpRuntimeRootsChanged(project, Collections.emptyList());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "modules";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/config/library/PhpRuntimeLibraryRootsProvider$2";
                objectArray[2] = "modulesAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void ensureWorkspaceEntitiesAreUpToDate(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeLibraryRootsProvider.$$$reportNull$$$0(29);
        }
        List roots = !PhpRuntimeLibraryRootsProvider.useWorkspaceModelForPhpRuntime() || ApplicationManager.getApplication().isUnitTestMode() && !PhpRuntimeLibraryRootsProvider.hasWebModules(project) ? Collections.emptyList() : PhpRuntimeLibraryRootsProvider.getLibraryRootsFromExtensionPoint(project).toList();
        PhpLibraryRootUtil.registerRuntimeRoots(project, roots, () -> PhpRuntimeLibraryRootsProvider.invalidateCache(project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 6, 8, 9, 11, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpRuntimeLibraryRootsProvider";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoots";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousDefaultStubsPath";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDefaultStubsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRootsToIndex";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpRuntimeLibraryRootsProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectRootsToIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRootsFromExtensionPoint";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRootsBeforeFiltering";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRootsWithoutWorkspaceModel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCacheResult";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectRootsToIndex";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRootsFromExtensionPoint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRootsBeforeFiltering";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasWebModules";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRootsWithoutWorkspaceModel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doGetRootsInternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInStubRoots";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createCacheResult";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "firePhpRuntimeRootsChanged";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "invalidateCache";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyNewStubsPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "closePreviousStubFiles";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateGitMappings";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "ensureWorkspaceEntitiesAreUpToDate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 6, 8, 9, 11, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> new IllegalArgumentException(string);
        };
    }
}

