/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.servers.PhpServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="PhpServers", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class PhpServersWorkspaceStateComponent
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PhpServersWorkspaceStateComponent.class);
    private static final SerializationFilter myFilter = new SkipDefaultValuesSerializationFilters();
    private static final String SHARED_SERVER = "shared_server";
    private final Project myProject;
    private List<PhpServer> myServers = new ArrayList<PhpServer>();
    private final Map<String, Boolean> mySharedConfigurations = new HashMap<String, Boolean>();
    private final Map<String, List<PathMappingSettings.PathMapping>> myLibraryPathMappingsForShared = new HashMap<String, List<PathMappingSettings.PathMapping>>();

    public PhpServersWorkspaceStateComponent(Project project) {
        this.myProject = project;
    }

    public static PhpServersWorkspaceStateComponent getInstance(@NotNull Project project) {
        if (project == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(0);
        }
        return (PhpServersWorkspaceStateComponent)project.getService(PhpServersWorkspaceStateComponent.class);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(1);
        }
        return project;
    }

    @XCollection(elementName="servers")
    public List<PhpServer> getServers() {
        return this.myServers;
    }

    public void setServers(@NotNull List<PhpServer> servers) {
        if (servers == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(2);
        }
        this.myServers = servers;
    }

    public Element getState() {
        Element root = new Element("state");
        List<PhpServer> servers = this.myServers;
        if (!servers.isEmpty()) {
            Element serversElement = new Element("servers");
            for (PhpServer server : servers) {
                this.serializeServerConfiguration(server, null, serversElement);
            }
            root.addContent(serversElement);
        }
        return root;
    }

    public void serializeServerConfiguration(@NotNull PhpServer server, @Nullable Condition<PathMappingSettings.PathMapping> mappingsFilter, @NotNull Element parent) {
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(4);
        }
        Element serverElement = XmlSerializer.serialize((Object)server, (SerializationFilter)myFilter);
        PhpServersWorkspaceStateComponent.serializePathMappings(server, mappingsFilter, serverElement, parent);
    }

    private static void serializePathMappings(@NotNull PhpServer server, @Nullable Condition<PathMappingSettings.PathMapping> mappingsFilter, @NotNull Element serverElement, @NotNull Element parent) {
        List mappings;
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(5);
        }
        if (serverElement == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(7);
        }
        List list = mappings = mappingsFilter == null ? server.getSerializedMappings() : ContainerUtil.filter(server.getSerializedMappings(), mappingsFilter);
        if (!mappings.isEmpty()) {
            Element mappingsRoot = new Element("path_mappings");
            for (PathMappingSettings.PathMapping mapping : mappings) {
                Element mappingElement = XmlSerializer.serialize((Object)mapping, (SerializationFilter)myFilter);
                mappingsRoot.addContent(mappingElement);
            }
            serverElement.addContent(mappingsRoot);
        }
        parent.addContent(serverElement);
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(8);
        }
        this.clear(false);
        Element rootElement = PhpServersWorkspaceStateComponent.extractServerRootElement(element);
        if (rootElement != null) {
            for (Element serverElement : rootElement.getChildren("server")) {
                PhpServer server = PhpServersWorkspaceStateComponent.deserializeServerConfiguration(serverElement);
                this.addServer(server, false);
            }
            List sharedServerElements = rootElement.getChildren(SHARED_SERVER);
            for (Element serverElement : sharedServerElements) {
                List<PathMappingSettings.PathMapping> mappings;
                Attribute id = serverElement.getAttribute("id");
                if (id == null || !StringUtil.isNotEmpty((String)id.getValue()) || (mappings = PhpServersWorkspaceStateComponent.deserializePathMappings(serverElement)) == null) continue;
                this.myLibraryPathMappingsForShared.put(id.getValue(), mappings);
            }
        }
    }

    public void loadServers(@NotNull Element rootElement, boolean isShared) {
        if (rootElement == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(9);
        }
        this.removeConfigurations(isShared);
        for (Element serverElement : rootElement.getChildren("server")) {
            PhpServer server = PhpServersWorkspaceStateComponent.deserializeServerConfiguration(serverElement);
            this.addServer(server, isShared);
        }
        for (PhpServer server : this.myServers) {
            List<PathMappingSettings.PathMapping> libraryMappings;
            if (!this.isConfigurationShared(server) || (libraryMappings = this.myLibraryPathMappingsForShared.remove(server.getId())) == null || libraryMappings.isEmpty()) continue;
            List<PathMappingSettings.PathMapping> projectPathMappings = server.getMappings();
            if (projectPathMappings == null) {
                projectPathMappings = new ArrayList<PathMappingSettings.PathMapping>();
            }
            projectPathMappings.addAll(libraryMappings);
        }
    }

    @NotNull
    private static PhpServer deserializeServerConfiguration(@NotNull Element serverElement) {
        if (serverElement == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(10);
        }
        PhpServer server = (PhpServer)XmlSerializer.deserialize((Element)serverElement, PhpServer.class);
        List<PathMappingSettings.PathMapping> mappings = PhpServersWorkspaceStateComponent.deserializePathMappings(serverElement);
        if (mappings != null) {
            server.setSerializedMappings(mappings);
        }
        PhpServer phpServer = server;
        if (phpServer == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(11);
        }
        return phpServer;
    }

    @Nullable
    private static List<PathMappingSettings.PathMapping> deserializePathMappings(@NotNull Element serverElement) {
        Element mappingRoot;
        if (serverElement == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(12);
        }
        if ((mappingRoot = serverElement.getChild("path_mappings")) != null) {
            List<Element> mappingElements = PhpServersWorkspaceStateComponent.extractMappings(mappingRoot);
            ArrayList<PathMappingSettings.PathMapping> mappings = new ArrayList<PathMappingSettings.PathMapping>();
            for (Element mappingElement : mappingElements) {
                Attribute remotePath;
                Attribute localPath = mappingElement.getAttribute("local_path");
                if (localPath == null) {
                    localPath = mappingElement.getAttribute("local-root");
                }
                if ((remotePath = mappingElement.getAttribute("remote_path")) == null) {
                    remotePath = mappingElement.getAttribute("remote-root");
                }
                if (localPath == null || remotePath == null) continue;
                PathMappingSettings.PathMapping mapping = new PathMappingSettings.PathMapping(localPath.getValue(), remotePath.getValue());
                mappings.add(mapping);
            }
            return mappings;
        }
        return null;
    }

    private void addServer(@NotNull PhpServer server, boolean shared) {
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(13);
        }
        Iterator<PhpServer> iterator = this.myServers.iterator();
        while (iterator.hasNext()) {
            PhpServer phpServer = iterator.next();
            if (!StringUtil.equals((CharSequence)phpServer.getId(), (CharSequence)server.getId())) continue;
            if (shared) {
                LOG.info("Replacing existing server with the shared one with the same id");
                if (!phpServer.equals(server)) {
                    this.myLibraryPathMappingsForShared.put(phpServer.getId(), ContainerUtil.filter(phpServer.getMappings(), mapping -> {
                        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(mapping.getLocalRoot());
                        return file != null && (Boolean)ReadAction.compute(() -> !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(file)) != false;
                    }));
                }
            } else {
                LOG.warn("Trying to create server '" + server.getName() + "' when another one with the same id exists");
            }
            iterator.remove();
        }
        this.myServers.add(server);
        this.mySharedConfigurations.put(server.getId(), shared);
    }

    @NotNull
    private static List<Element> extractMappings(@NotNull Element mappings) {
        List oldMappings;
        if (mappings == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(14);
        }
        if (!(oldMappings = mappings.getChildren("path_mapping")).isEmpty()) {
            List list = oldMappings;
            if (list == null) {
                PhpServersWorkspaceStateComponent.$$$reportNull$$$0(15);
            }
            return list;
        }
        List list = mappings.getChildren("mapping");
        if (list == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    private static Element extractServerRootElement(@NotNull Element element) {
        if (element == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(17);
        }
        List options = element.getChildren("option");
        for (Element option : options) {
            Attribute name = option.getAttribute("name");
            if (name == null || !name.getValue().equals("servers")) continue;
            return option;
        }
        return element.getChild("servers");
    }

    @NotNull
    public List<PhpServer> getPhpServerConfigurations(boolean shared) {
        List result = null;
        for (PhpServer configuration : this.myServers) {
            if (this.isConfigurationShared(configuration) != shared) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(configuration);
        }
        List list = ContainerUtil.notNullize(result);
        if (list == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(18);
        }
        return list;
    }

    public boolean isConfigurationShared(@NotNull PhpServer server) {
        Boolean shared;
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(19);
        }
        return (shared = this.mySharedConfigurations.get(server.getId())) != null && shared != false;
    }

    public void setConfigurationShared(@NotNull PhpServer server, boolean shared) {
        if (server == null) {
            PhpServersWorkspaceStateComponent.$$$reportNull$$$0(20);
        }
        if (this.isConfigurationShared(server) != shared) {
            this.mySharedConfigurations.put(server.getId(), shared);
        }
    }

    private void clear(boolean allConfigurations) {
        if (allConfigurations) {
            this.myServers.clear();
            this.mySharedConfigurations.clear();
            this.myLibraryPathMappingsForShared.clear();
        } else {
            this.myLibraryPathMappingsForShared.clear();
            this.removeConfigurations(false);
        }
    }

    public void removeConfigurations(boolean shared) {
        Iterator<PhpServer> it = this.myServers.iterator();
        while (it.hasNext()) {
            PhpServer server = it.next();
            if (this.isConfigurationShared(server) != shared) continue;
            if (shared) {
                this.mySharedConfigurations.put(server.getId(), false);
                continue;
            }
            it.remove();
            this.mySharedConfigurations.remove(server.getId());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 11, 15, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/servers/PhpServersWorkspaceStateComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 3: 
            case 5: 
            case 13: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverElement";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/servers/PhpServersWorkspaceStateComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeServerConfiguration";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMappings";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpServerConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setServers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serializeServerConfiguration";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serializePathMappings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadServers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeServerConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserializePathMappings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addServer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractMappings";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractServerRootElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationShared";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationShared";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 11, 15, 16, 18 -> new IllegalStateException(string);
        };
    }
}

