/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpMethodBreakpointProperties;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.connection.PhpDebugPathExtractor;
import com.jetbrains.php.debug.stepFilters.PhpStepFiltersConfiguration;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpStackFrame;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpDebugDriver<C extends PhpDebugConnection> {
    protected static boolean isSkipped(@NotNull DbgpStackFrame frame, @NotNull PhpStepFiltersConfiguration.State state, @NotNull PhpDebugProcess<XdebugConnection> debugProcess) {
        if (frame == null) {
            PhpDebugDriver.$$$reportNull$$$0(0);
        }
        if (state == null) {
            PhpDebugDriver.$$$reportNull$$$0(1);
        }
        if (debugProcess == null) {
            PhpDebugDriver.$$$reportNull$$$0(2);
        }
        String functionName = frame.functionName;
        String remoteFileUrl = frame.remoteFileUrl;
        if (functionName == null || remoteFileUrl == null) {
            return false;
        }
        PhpPathMapper pathMapper = debugProcess.getPathMapper();
        boolean isInSkippedFile = false;
        if (pathMapper != null) {
            String localPath = pathMapper.getLocalPath(remoteFileUrl);
            if (SystemInfo.isWindows && localPath != null && localPath.startsWith("/")) {
                localPath = FileUtil.toSystemDependentName((String)StringUtil.trimStart((String)localPath, (String)"/"));
            }
            isInSkippedFile = state.getSkippedFiles().contains(localPath);
        }
        return state.isSkipMagicMethods() && PhpDebugDriver.isMagicMethod(functionName) && !PhpDebugDriver.isConstructor(functionName) || state.isSkipConstructors() && PhpDebugDriver.isConstructor(functionName) || state.getSkippedFunctions().contains(functionName) || isInSkippedFile;
    }

    @NotNull
    public abstract String getSessionIdName();

    public abstract boolean isConditionalBreakpointSupported(XBreakpoint<? extends XBreakpointProperties> var1);

    public abstract boolean isExceptionalBreakpointSupported();

    public abstract boolean isMethodBreakpointSupported();

    public abstract void registerBreakpoint(@NotNull C var1, @NotNull String var2, int var3, @Nullable String var4, @NotNull String var5, @NotNull PhpDebugProcess.RegisterBreakpointCallback var6);

    public abstract void registerExceptionBreakpoint(@NotNull C var1, @NotNull String var2, @NotNull PhpDebugProcess.RegisterBreakpointCallback var3);

    public abstract void registerMethodBreakpoint(@NotNull C var1, @NotNull PhpMethodBreakpointProperties var2, @NotNull PhpDebugProcess.RegisterBreakpointCallback var3);

    public abstract void unregisterBreakpoint(@NotNull C var1, @NotNull String var2, @NotNull PhpDebugProcess.UnregisterBreakpointCallback var3);

    public abstract void registerAdditionalActions(@NotNull DefaultActionGroup var1, @NotNull DefaultActionGroup var2, @NotNull DefaultActionGroup var3, PhpDebugProcess<C> var4);

    @Nullable
    public abstract XValueMarkerProvider<? extends XValue, String> createValueMarkerProvider();

    public abstract void registerHandlers(@NotNull PhpDebugProcess<C> var1);

    public abstract void registerErrorOutputHandler(@NotNull PhpDebugProcess<C> var1, @NotNull PhpDebugProcess.ErrorOutputHandler var2);

    public abstract void startStepOver(@NotNull C var1);

    public abstract void startStepInto(@NotNull C var1);

    public abstract void startFilteredStepInto(@NotNull PhpDebugProcess<C> var1, @NotNull C var2, PhpStepFiltersConfiguration.State var3);

    public abstract void startSmartStepInto(@NotNull PhpDebugProcess<C> var1);

    public abstract void startStepOut(@NotNull C var1);

    public abstract void resume(@NotNull C var1);

    public abstract void stop(@NotNull C var1);

    public abstract void start(@NotNull PhpDebugProcess<C> var1);

    @NotNull
    public abstract PhpDebugPathExtractor createPathFromUrlExtractor();

    public static boolean isMagicMethod(@NotNull String name) {
        List<String> splitCalls;
        int length;
        if (name == null) {
            PhpDebugDriver.$$$reportNull$$$0(3);
        }
        if ((length = (splitCalls = PhpDebugDriver.splitMethodName(name)).size()) > 0) {
            return PhpLangUtil.isMagicMethod(splitCalls.get(length - 1));
        }
        return false;
    }

    public static boolean isConstructor(@NotNull String name) {
        List<String> splitCalls;
        int length;
        if (name == null) {
            PhpDebugDriver.$$$reportNull$$$0(4);
        }
        if ((length = (splitCalls = PhpDebugDriver.splitMethodName(name)).size()) > 1) {
            return splitCalls.get(length - 1).startsWith("__construct") || splitCalls.get(length - 1).equals(splitCalls.get(length - 2));
        }
        return false;
    }

    public static List<String> splitMethodName(@NotNull String fullName) {
        List dynamicRef;
        if (fullName == null) {
            PhpDebugDriver.$$$reportNull$$$0(5);
        }
        if ((dynamicRef = StringUtil.split((String)fullName, (String)"->")).size() > 1) {
            return dynamicRef;
        }
        return StringUtil.split((String)fullName, (String)"::");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpDebugDriver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSkipped";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMagicMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "splitMethodName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

