/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common.debugConsole;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableConsumer;
import com.jetbrains.php.debug.TypeInfo;
import com.jetbrains.php.debug.common.PhpEvaluationResultProcessor;
import com.jetbrains.php.debug.common.PhpEvaluator;
import com.jetbrains.php.debug.common.PhpNavigatableValue;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpEvaluationErrorHandler {
    public static void handle(@NotNull PhpEvaluator evaluator, final @NotNull NullableConsumer<? super String> errorConsumer) {
        if (evaluator == null) {
            PhpEvaluationErrorHandler.$$$reportNull$$$0(0);
        }
        if (errorConsumer == null) {
            PhpEvaluationErrorHandler.$$$reportNull$$$0(1);
        }
        evaluator.evaluateCodeFragment("error_get_last()", new PhpEvaluationResultProcessor(){

            @Override
            public void success(@NotNull String value, @NotNull TypeInfo typeInfo, @NotNull PhpNavigatableValue navigatableValue) {
                Map<String, String> children;
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (typeInfo == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (navigatableValue == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((children = navigatableValue.getLoadedChildren()) != null && !children.isEmpty()) {
                    String file = children.get("file");
                    String message = children.get("message");
                    if (StringUtil.isNotEmpty((String)file) && 1.isErrorFromEvaluatedCode(file) && StringUtil.isNotEmpty((String)message)) {
                        StringBuilder builder2 = new StringBuilder(message.length());
                        PhpFatalErrorType type = PhpFatalErrorType.get(children.get("type"));
                        if (type != null) {
                            builder2.append(type.getName()).append(": ");
                        }
                        builder2.append(message);
                        errorConsumer.consume((Object)builder2.toString());
                        return;
                    }
                }
                errorConsumer.consume(null);
            }

            private static boolean isErrorFromEvaluatedCode(@NotNull String file) {
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                return StringUtil.startsWith((CharSequence)file, (CharSequence)"xdebug://debug-eval") || StringUtil.startsWith((CharSequence)file, (CharSequence)"variable expression");
            }

            @Override
            public void error(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(4);
                }
                errorConsumer.consume(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeInfo";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "navigatableValue";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/common/debugConsole/PhpEvaluationErrorHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "success";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isErrorFromEvaluatedCode";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "evaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "errorConsumer";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/debug/common/debugConsole/PhpEvaluationErrorHandler";
        objectArray[2] = "handle";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum PhpFatalErrorType {
        E_ERROR(1, "PHP Fatal error"),
        E_PARSE(4, "PHP Parse error"),
        E_COMPILE_ERROR(64, "PHP Fatal error");

        private final int myCode;
        private final String myName;

        private PhpFatalErrorType(int code, String name) {
            if (name == null) {
                PhpFatalErrorType.$$$reportNull$$$0(0);
            }
            this.myCode = code;
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        @Nullable
        public static PhpFatalErrorType get(String code) {
            try {
                int c = Integer.parseInt(code);
                for (PhpFatalErrorType type : PhpFatalErrorType.values()) {
                    if (type.myCode != c) continue;
                    return type;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/debug/common/debugConsole/PhpEvaluationErrorHandler$PhpFatalErrorType", "<init>"));
        }
    }
}

