/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.connection;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpServersConfigurable;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public final class PhpDebugNotification {
    public static void showNotification(@NotNull Project project, @NotNull String serverName) {
        if (project == null) {
            PhpDebugNotification.$$$reportNull$$$0(0);
        }
        if (serverName == null) {
            PhpDebugNotification.$$$reportNull$$$0(1);
        }
        String message = PhpBundle.message("debug.php.external.connection.finished.warning", serverName);
        String title = PhpBundle.message("debug.php.external.connection.finished.warning.title", new Object[0]);
        PhpDebugUtil.showWarningBalloon(project, title, message, new PhpDebugNotificationListener(project, serverName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serverName";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/debug/connection/PhpDebugNotification";
        objectArray[2] = "showNotification";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpDebugNotificationListener
    implements NotificationListener {
        private final Project myProject;
        private final String myServerName;

        PhpDebugNotificationListener(@NotNull Project project, @NotNull String serverName) {
            if (project == null) {
                PhpDebugNotificationListener.$$$reportNull$$$0(0);
            }
            if (serverName == null) {
                PhpDebugNotificationListener.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myServerName = serverName;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                PhpDebugNotificationListener.$$$reportNull$$$0(2);
            }
            if (event == null) {
                PhpDebugNotificationListener.$$$reportNull$$$0(3);
            }
            PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(this.myProject).getState();
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = event.getDescription();
                if ("ignore".equals(description)) {
                    state.setNotifyIfSessionWasFinishedWithoutBeingPaused(false);
                    notification.expire();
                } else if ("break".equals(description)) {
                    state.setBreakAtFirstLine(true);
                    String title = PhpBundle.message("debug.php.external.connection.finished.break.at.first.line.title", new Object[0]);
                    String message = PhpBundle.message("debug.php.external.connection.finished.break.at.first.line", new Object[0]);
                    PhpDebugUtil.showWarningBalloon(this.myProject, title, message, null);
                } else if ("servers".equals(description)) {
                    PhpServersConfigurable.openSettings(this.myProject, this.myServerName);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugNotification$PhpDebugNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

