/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpPathMappingsConverter;
import com.jetbrains.php.debug.ui.PhpMappingsFromDeploymentDetectorForm;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMappingsFromDeploymentImporterForm
extends PhpMappingsFromDeploymentDetectorForm {
    private static final Logger LOG = Logger.getInstance(PhpMappingsFromDeploymentImporterForm.class);
    private final JTextField myDeploymentRootField;
    private final DocumentAdapter myPathTextFieldListener;
    @NotNull
    private final Disposable myDisposable;
    private volatile WebServerConfig.RemotePath myRelativeRemotePath;
    @NotNull
    private final Alarm myReloadAlarm;
    private boolean myDisposed;

    public PhpMappingsFromDeploymentImporterForm(final @NotNull String remoteFilePath, @NotNull List<Project> projects, @NotNull NullableConsumer<VirtualFile> selectedFileProcessor) {
        if (remoteFilePath == null) {
            PhpMappingsFromDeploymentImporterForm.$$$reportNull$$$0(0);
        }
        if (projects == null) {
            PhpMappingsFromDeploymentImporterForm.$$$reportNull$$$0(1);
        }
        if (selectedFileProcessor == null) {
            PhpMappingsFromDeploymentImporterForm.$$$reportNull$$$0(2);
        }
        super(remoteFilePath, projects, selectedFileProcessor);
        this.myDisposed = false;
        this.myDisposable = Disposer.newDisposable();
        this.myReloadAlarm = new Alarm((JComponent)this.myMainPanel, this.myDisposable);
        this.myDeploymentRootField = new JTextField();
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(0, 0, 0, 5);
        gc.gridx = 0;
        gc.gridy = 2;
        JBLabel label = new JBLabel();
        label.setText(PhpBundle.message("debug.server.import.from.deployment.deployment.root.label", new Object[0]));
        label.setLabelFor((Component)this.myDeploymentRootField);
        this.myConfigurationPanel.add((Component)label, gc);
        this.myPathTextFieldListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpMappingsFromDeploymentImporterForm.this.scheduleInfoComputation(remoteFilePath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/debug/ui/PhpMappingsFromDeploymentImporterForm$1", "textChanged"));
            }
        };
        this.myDeploymentRootField.getDocument().addDocumentListener((DocumentListener)this.myPathTextFieldListener);
        gc.insets = new Insets(0, 0, 0, 0);
        gc.gridx = 1;
        gc.fill = 2;
        this.myConfigurationPanel.add((Component)this.myDeploymentRootField, gc);
    }

    @Override
    @Nullable
    protected WebServerConfig.RemotePath getRemoteFilePath() {
        return this.myRelativeRemotePath;
    }

    private void scheduleInfoComputation(@NotNull String remotePath) {
        if (remotePath == null) {
            PhpMappingsFromDeploymentImporterForm.$$$reportNull$$$0(3);
        }
        if (this.myDisposed) {
            return;
        }
        this.myReloadAlarm.cancelAllRequests();
        this.myReloadAlarm.addComponentRequest(() -> this.updateLocalFilePath(remotePath), 200);
    }

    public void updateLocalFilePath(@NotNull String remotePath) {
        String pathToRoot;
        if (remotePath == null) {
            PhpMappingsFromDeploymentImporterForm.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(pathToRoot = this.getPathToDeploymentRoot()))) {
            String relative = PhpPathMappingsConverter.getPathRemainder(remotePath, pathToRoot, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Update local file path, deployment root: " + pathToRoot + ", full path: " + remotePath + ", relative: " + relative);
            }
            this.myRelativeRemotePath = StringUtil.isEmpty((String)relative) ? null : new WebServerConfig.RemotePath(relative);
        } else {
            this.myRelativeRemotePath = null;
        }
        this.updateLocalFile(this.myRelativeRemotePath);
    }

    @Override
    @NotNull
    protected JBLabel createMessage() {
        JBLabel label = new JBLabel();
        label.setText(PhpBundle.message("debug.server.import.from.deployment.no.deployment.configurations.message", new Object[0]));
        label.setIcon(UIUtil.getBalloonWarningIcon());
        label.setToolTipText(PhpBundle.message("debug.server.import.from.deployment.no.deployment.configurations.tooltip", new Object[0]));
        JBLabel jBLabel = label;
        if (jBLabel == null) {
            PhpMappingsFromDeploymentImporterForm.$$$reportNull$$$0(5);
        }
        return jBLabel;
    }

    @Override
    @NotNull
    protected Condition<WebServerConfig> createWebServerFilter(@NotNull WebServerConfig.RemotePath path) {
        if (path == null) {
            PhpMappingsFromDeploymentImporterForm.$$$reportNull$$$0(6);
        }
        Condition condition = Conditions.alwaysTrue();
        if (condition == null) {
            PhpMappingsFromDeploymentImporterForm.$$$reportNull$$$0(7);
        }
        return condition;
    }

    @NotNull
    private String getPathToDeploymentRoot() {
        String string = this.myDeploymentRootField == null ? "" : StringUtil.notNullize((String)this.myDeploymentRootField.getText());
        if (string == null) {
            PhpMappingsFromDeploymentImporterForm.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    protected List<PathMappingSettings.PathMapping> getPathMappings() {
        WebServerConfig webConfig = this.myWebServerCombo.getSelectedServer();
        if (webConfig == null) {
            LOG.warn(PhpBundle.message("debug.server.can.not.detect.path.mappings.from.deployment", new Object[0]));
            return null;
        }
        return PhpPathMappingsConverter.getMappings(this.getSelectedProject(), webConfig, this.getPathToDeploymentRoot());
    }

    @Override
    public void disposeUI() {
        super.disposeUI();
        this.myDeploymentRootField.getDocument().removeDocumentListener((DocumentListener)this.myPathTextFieldListener);
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFileProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/ui/PhpMappingsFromDeploymentImporterForm";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/ui/PhpMappingsFromDeploymentImporterForm";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createWebServerFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToDeploymentRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleInfoComputation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalFilePath";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createWebServerFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

