/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.XdebugConfiguration;
import com.jetbrains.php.debug.validation.configuration.ZendDebugConfiguration;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.xml.sax.Attributes;

public abstract class PhpDebugConfiguration {
    protected static final String REQ_MODE = "req";
    protected static final String JIT_MODE = "jit";

    public abstract void validate(@NotNull List<PhpInfoValidationMessage> var1, @Nullable PhpProjectDebugConfiguration.State var2, @Nullable String var3, @Nullable String var4, boolean var5, Project var6);

    @Nullable
    public static PhpDebugConfiguration parse(@NotNull Project project, @NotNull Attributes attributes) {
        String name;
        if (project == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(1);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)(name = attributes.getValue("name")), (CharSequence)"xdebug")) {
            return XdebugConfiguration.parseConfiguration(project, attributes);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"Zend Debugger")) {
            return ZendDebugConfiguration.parseConfiguration(attributes);
        }
        return null;
    }

    @NotNull
    @Nls
    protected static String getDescriptionByMessage(@Nls @NotNull String message, @Nullable String documentationUrl) {
        if (message == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)documentationUrl)) {
            String string = message;
            if (string == null) {
                PhpDebugConfiguration.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = message + "<br>" + PhpDebugConfiguration.getDocumentation(documentationUrl);
        if (string == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @Nls
    protected static String getDescription(@PropertyKey(resourceBundle="messages.PhpBundle") @NotNull @PropertyKey(resourceBundle="messages.PhpBundle") @NotNull String messageKey, @Nullable String documentationUrl) {
        if (messageKey == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(5);
        }
        String message = PhpBundle.message(messageKey, new Object[0]);
        return PhpDebugConfiguration.getDescriptionByMessage(message, documentationUrl);
    }

    @NotNull
    @Nls
    protected static String getDocumentation(@NotNull String documentationUrl) {
        if (documentationUrl == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(6);
        }
        String string = PhpBundle.message("php.web.server.validation.reference.to.documentation", documentationUrl);
        if (string == null) {
            PhpDebugConfiguration.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected static boolean isLocalhost(@Nullable String host) {
        return "localhost".equals(host) || "127.0.0.1".equals(host);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/configuration/PhpDebugConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/configuration/PhpDebugConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionByMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionByMessage";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7 -> new IllegalStateException(string);
        };
    }
}

