/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.xdebug.dbgp.messages.BreakpointGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.BreakpointRemoveResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.BreakpointSetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextNamesResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.EvalResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.InitNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PhpErrorNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PhpResolvedBreakpointNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PhpUnknownNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyValueResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ProxyInitResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ProxyStopResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.SetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StackGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StatusResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StdoutNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ValidationResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.XdebugVariableNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.cloud.CloudConnectionResponse;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DbgpUtil {
    public static final String DBGP_PREFIX = "dbgp://";
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    public static final String BASE64 = "base64";
    public static final int DEFAULT_MAX_DEPTH = 3;
    public static final int DEFAULT_MAX_CHILDREN = 100;
    public static final Namespace DBGP_NAMESPACE = Namespace.getNamespace((String)"urn:debugger_protocol_v1");
    public static final String XDEBUG_NAMESPACE_PREFIX = "xdebug";
    public static final Namespace XDEBUG_NAMESPACE = Namespace.getNamespace((String)"xdebug", (String)"http://xdebug.org/dbgp/xdebug");
    public static final String ELEMENT_INIT = "init";
    public static final String ELEMENT_CLOUD_INIT = "cloudinit";
    public static final String ELEMENT_CLOUD_STOP = "cloudstop";
    public static final String ELEMENT_NOTIFY = "notify";
    public static final String ELEMENT_PROPERTY = "property";
    public static final String ELEMENT_CONTEXT = "context";
    public static final String ELEMENT_ERROR = "error";
    public static final String ELEMENT_MESSAGE = "message";
    public static final String ELEMENT_BREAKPOINT = "breakpoint";
    public static final String ELEMENT_RESPONSE = "response";
    public static final String ELEMENT_STREAM = "stream";
    public static final String ELEMENT_LOCATION = "location";
    public static final String ATTR_RESPONSE_ID = "transaction_id";
    public static final String ATTR_RESPONSE_COMMAND = "command";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_FUNCTION = "function";
    public static final String ATTR_EXCEPTION = "exception";
    public static final String ATTR_EXCEPTION_CODE = "code";
    public static final String ATTR_STACK = "stack";
    public static final String ATTR_LEVEL = "level";
    public static final String ATTR_LINENO = "lineno";
    public static final String ATTR_WHERE = "where";
    public static final String ATTR_STATUS = "status";
    public static final String ATTR_REASON = "reason";
    public static final String ATTR_SUCCESS = "success";
    public static final String ATTR_SUPPORTED = "supported";
    public static final String ATTR_STATE = "state";
    public static final String ATTR_ID = "id";
    public static final String ATTR_RESOLVED = "resolved";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ENCODING = "encoding";
    public static final String ATTR_IDEKEY = "idekey";
    public static final String STREAM_TYPE_STDOUT = "stdout";
    public static final String STREAM_TYPE_STDERR = "stderr";
    private static final Logger LOG = Logger.getInstance(DbgpUtil.class);
    private static final Pattern DUPLICATE_ATTRIBUTE_PATTERN = Pattern.compile("(\\s([\\w:]+)=\"[^\"]*\")([^>]*?)\\s\\2=\"[^\"]*\"");

    private DbgpUtil() {
    }

    @Nullable
    public static String getXdebugAttribute(@NotNull String attributeName, @NotNull Element packet) {
        String value;
        if (attributeName == null) {
            DbgpUtil.$$$reportNull$$$0(0);
        }
        if (packet == null) {
            DbgpUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(value = packet.getAttributeValue(attributeName, XDEBUG_NAMESPACE)))) {
            return value;
        }
        Namespace namespace = packet.getNamespace(XDEBUG_NAMESPACE_PREFIX);
        return packet.getAttributeValue(attributeName, namespace);
    }

    @Nullable
    public static Element getXdebugTag(@NotNull Element packet, @NotNull String tagName) {
        Element tag;
        if (packet == null) {
            DbgpUtil.$$$reportNull$$$0(2);
        }
        if (tagName == null) {
            DbgpUtil.$$$reportNull$$$0(3);
        }
        if ((tag = packet.getChild(tagName, XDEBUG_NAMESPACE)) != null) {
            return tag;
        }
        Namespace namespace = packet.getNamespace(XDEBUG_NAMESPACE_PREFIX);
        return packet.getChild(tagName, namespace);
    }

    @NotNull
    private static Element readDocumentFromProxyServer(@NotNull InputStream is) throws IOException {
        int size;
        int i;
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(4);
        }
        ByteArrayOutputStream packetSizeBuffer = new ByteArrayOutputStream();
        while ((i = is.read()) != 0 && i != -1) {
            packetSizeBuffer.write(i);
        }
        String text = packetSizeBuffer.toString(StandardCharsets.UTF_8);
        try {
            size = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return DbgpUtil.parseDocument(text);
        }
        return DbgpUtil.getDocument(is, size);
    }

    @NotNull
    private static Element readDocument(@NotNull InputStream is) throws IOException {
        int size;
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(5);
        }
        ByteArrayOutputStream packetSizeBuffer = new ByteArrayOutputStream();
        while (true) {
            int i;
            if ((i = is.read()) == -1) {
                throw new IOException("input stream is finished");
            }
            if (i == 0) break;
            packetSizeBuffer.write(i);
        }
        try {
            size = Integer.parseInt(packetSizeBuffer.toString(StandardCharsets.UTF_8));
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid packet: cannot parse size, got " + DbgpUtil.dump(packetSizeBuffer));
            throw new IOException(PhpBundle.message("dbgp.invalid.packet", new Object[0]));
        }
        return DbgpUtil.getDocument(is, size);
    }

    @NotNull
    private static Element getDocument(@NotNull InputStream is, int size) throws IOException {
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(6);
        }
        ByteArrayOutputStream packetBuffer = new ByteArrayOutputStream(size);
        int count = 0;
        while (count++ <= size) {
            int i = is.read();
            if (i == -1) {
                throw new EOFException();
            }
            if (i == 0) {
                if (count >= size) continue;
                LOG.warn("Invalid packet size: " + count + " while expected " + size);
                LOG.warn("Last packet: " + DbgpUtil.dump(packetBuffer));
                throw new IOException(PhpBundle.message("dbgp.invalid.packet", new Object[0]));
            }
            packetBuffer.write(i);
        }
        return DbgpUtil.parseDocument(packetBuffer.toString(StandardCharsets.UTF_8));
    }

    @NotNull
    public static Element parseDocument(@NotNull String is) throws IOException {
        Element element;
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(7);
        }
        String sanitized = DbgpUtil.removeDuplicateAttributes(is);
        StringBuilder packet = new StringBuilder(sanitized);
        boolean dump = false;
        int i = 0;
        while (i < packet.length()) {
            char c = packet.charAt(i);
            if (Verifier.isXMLCharacter((int)c)) {
                ++i;
                continue;
            }
            LOG.warn("Illegal symbol in packet: 0x" + Integer.toHexString(c));
            dump = true;
            packet.deleteCharAt(i);
        }
        if (dump) {
            LOG.warn(sanitized);
        }
        try {
            element = JDOMUtil.load((CharSequence)packet);
        }
        catch (JDOMException e) {
            if (!dump) {
                LOG.warn("Could not parse packet", (Throwable)e);
                LOG.warn(is);
            } else {
                LOG.warn("Could not parse the last packet", (Throwable)e);
            }
            throw new IOException(PhpBundle.message("dbgp.invalid.packet", new Object[0]));
        }
        if (element == null) {
            DbgpUtil.$$$reportNull$$$0(8);
        }
        return element;
    }

    @NotNull
    private static String removeDuplicateAttributes(@NotNull String xml) {
        String result;
        if (xml == null) {
            DbgpUtil.$$$reportNull$$$0(9);
        }
        if (!(result = DUPLICATE_ATTRIBUTE_PATTERN.matcher(xml).replaceAll("$1$3")).equals(xml)) {
            LOG.warn("Removed duplicate XML attributes from Xdebug response");
        }
        String string = result;
        if (string == null) {
            DbgpUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @TestOnly
    @NotNull
    public static DbgpInputMessage parsePacket(@NotNull String packet) throws IOException, JDOMException {
        if (packet == null) {
            DbgpUtil.$$$reportNull$$$0(11);
        }
        return DbgpUtil.parsePacket(JDOMUtil.load((CharSequence)packet));
    }

    @NotNull
    private static DbgpInputMessage parsePacket(@NotNull Element packet) throws IOException {
        String rootTagName;
        if (packet == null) {
            DbgpUtil.$$$reportNull$$$0(12);
        }
        if (ELEMENT_RESPONSE.equals(rootTagName = packet.getName())) {
            @NonNls String commandName = packet.getAttributeValue(ATTR_RESPONSE_COMMAND);
            if (commandName == null) {
                throw new IOException("Deserialization exception: Cannot find attribute command name in response");
            }
            Element errorTag = packet.getChild(ELEMENT_ERROR, DBGP_NAMESPACE);
            if (errorTag != null) {
                DbgpInputMessage dbgpInputMessage = new ErrorResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(13);
                }
                return dbgpInputMessage;
            }
            if (DbgpRequest.STATUS_RESPONSE_SET.contains(StringUtil.toLowerCase((String)commandName))) {
                DbgpInputMessage dbgpInputMessage = new StatusResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(14);
                }
                return dbgpInputMessage;
            }
            if ("breakpoint_set".equalsIgnoreCase(StringUtil.toLowerCase((String)commandName))) {
                DbgpInputMessage dbgpInputMessage = new BreakpointSetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(15);
                }
                return dbgpInputMessage;
            }
            if ("breakpoint_get".equalsIgnoreCase(StringUtil.toLowerCase((String)commandName))) {
                DbgpInputMessage dbgpInputMessage = new BreakpointGetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(16);
                }
                return dbgpInputMessage;
            }
            if ("breakpoint_remove".equalsIgnoreCase(StringUtil.toLowerCase((String)commandName))) {
                DbgpInputMessage dbgpInputMessage = new BreakpointRemoveResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(17);
                }
                return dbgpInputMessage;
            }
            if ("eval".equalsIgnoreCase(StringUtil.toLowerCase((String)commandName))) {
                DbgpInputMessage dbgpInputMessage = new EvalResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(18);
                }
                return dbgpInputMessage;
            }
            if ("property_get".equalsIgnoreCase(StringUtil.toLowerCase((String)commandName))) {
                DbgpInputMessage dbgpInputMessage = new PropertyGetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(19);
                }
                return dbgpInputMessage;
            }
            if ("property_value".equalsIgnoreCase(commandName)) {
                DbgpInputMessage dbgpInputMessage = new PropertyValueResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(20);
                }
                return dbgpInputMessage;
            }
            if ("stack_get".equalsIgnoreCase(commandName)) {
                DbgpInputMessage dbgpInputMessage = new StackGetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(21);
                }
                return dbgpInputMessage;
            }
            if ("context_names".equalsIgnoreCase(commandName)) {
                DbgpInputMessage dbgpInputMessage = new ContextNamesResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(22);
                }
                return dbgpInputMessage;
            }
            if ("context_get".equalsIgnoreCase(commandName)) {
                DbgpInputMessage dbgpInputMessage = new ContextGetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(23);
                }
                return dbgpInputMessage;
            }
            if (DbgpRequest.SET_RESPONSE_SET.contains(StringUtil.toLowerCase((String)commandName))) {
                DbgpInputMessage dbgpInputMessage = new SetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(24);
                }
                return dbgpInputMessage;
            }
            if ("phpstorm_validation".equalsIgnoreCase(commandName)) {
                DbgpInputMessage dbgpInputMessage = new ValidationResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(25);
                }
                return dbgpInputMessage;
            }
        } else if (ELEMENT_STREAM.equals(rootTagName)) {
            String streamType = packet.getAttributeValue(ATTR_TYPE);
            if (STREAM_TYPE_STDOUT.equals(streamType)) {
                DbgpInputMessage dbgpInputMessage = new StdoutNotification().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(26);
                }
                return dbgpInputMessage;
            }
        } else {
            if (ELEMENT_INIT.equals(rootTagName)) {
                DbgpInputMessage dbgpInputMessage = new InitNotification().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(27);
                }
                return dbgpInputMessage;
            }
            if (ELEMENT_CLOUD_INIT.equals(rootTagName)) {
                DbgpInputMessage dbgpInputMessage = new CloudConnectionResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(28);
                }
                return dbgpInputMessage;
            }
            if (ELEMENT_CLOUD_STOP.equals(rootTagName)) {
                DbgpInputMessage dbgpInputMessage = new CloudConnectionResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(29);
                }
                return dbgpInputMessage;
            }
            if (ELEMENT_NOTIFY.equals(rootTagName)) {
                String name = packet.getAttributeValue(ATTR_NAME);
                if (StringUtil.equals((CharSequence)name, (CharSequence)ELEMENT_ERROR)) {
                    DbgpInputMessage dbgpInputMessage = new PhpErrorNotification().deserialize(packet);
                    if (dbgpInputMessage == null) {
                        DbgpUtil.$$$reportNull$$$0(30);
                    }
                    return dbgpInputMessage;
                }
                if (StringUtil.equals((CharSequence)name, (CharSequence)"breakpoint_resolved")) {
                    DbgpInputMessage dbgpInputMessage = new PhpResolvedBreakpointNotification().deserialize(packet);
                    if (dbgpInputMessage == null) {
                        DbgpUtil.$$$reportNull$$$0(31);
                    }
                    return dbgpInputMessage;
                }
                if (StringUtil.equals((CharSequence)name, (CharSequence)"user")) {
                    DbgpInputMessage dbgpInputMessage = new XdebugVariableNotification().deserialize(packet);
                    if (dbgpInputMessage == null) {
                        DbgpUtil.$$$reportNull$$$0(32);
                    }
                    return dbgpInputMessage;
                }
                DbgpInputMessage dbgpInputMessage = new PhpUnknownNotification().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(33);
                }
                return dbgpInputMessage;
            }
            if ("proxyinit".equalsIgnoreCase(rootTagName)) {
                DbgpInputMessage dbgpInputMessage = new ProxyInitResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(34);
                }
                return dbgpInputMessage;
            }
            if ("proxystop".equalsIgnoreCase(rootTagName)) {
                DbgpInputMessage dbgpInputMessage = new ProxyStopResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(35);
                }
                return dbgpInputMessage;
            }
        }
        throw new IOException("Unknown dbgp root tag:" + rootTagName);
    }

    @NotNull
    public static DbgpInputMessage readMessage(@NotNull InputStream is) throws IOException {
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(36);
        }
        return DbgpUtil.parsePacket(DbgpUtil.readDocument(is));
    }

    @NotNull
    public static DbgpInputMessage readMessageFromProxyServer(@NotNull InputStream is) throws IOException {
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(37);
        }
        return DbgpUtil.parsePacket(DbgpUtil.readDocumentFromProxyServer(is));
    }

    @NotNull
    private static String dump(@NotNull ByteArrayOutputStream buffer) {
        if (buffer == null) {
            DbgpUtil.$$$reportNull$$$0(38);
        }
        String string = "BASE64[" + Base64.getEncoder().encodeToString(buffer.toByteArray()) + "]";
        if (string == null) {
            DbgpUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    public static String encode(String expression, String encoding) throws UnsupportedEncodingException {
        return Base64.getEncoder().encodeToString(expression.getBytes(encoding));
    }

    public static boolean toBoolean(@Nullable String value) {
        return TRUE.equals(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/dbgp/DbgpUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/DbgpUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDocument";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicateAttributes";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePacket";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getXdebugAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getXdebugTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readDocumentFromProxyServer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readDocument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseDocument";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 39: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicateAttributes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parsePacket";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "readMessage";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readMessageFromProxyServer";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 39 -> new IllegalStateException(string);
        };
    }
}

