/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.debug.connection.OutputMessage;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DbgpOutputMessage
implements OutputMessage {
    public static final String PROXYINIT_REQUEST = "proxyinit";
    public static final String PROXYSTOP_REQUEST = "proxystop";
    private static final String PARAMETER_FORMAT = " -{0} {1}";
    protected static final String PARAMETER_PORT = "p";
    protected static final String PARAMETER_IDE_KEY = "k";
    protected static final String PARAMETER_MULTIPLE_SESSIONS = "m";
    protected final String myName;
    protected final List<Pair<String, String>> myParameters;

    public DbgpOutputMessage(@NotNull String name) {
        if (name == null) {
            DbgpOutputMessage.$$$reportNull$$$0(0);
        }
        this.myParameters = new ArrayList<Pair<String, String>>();
        this.myName = name;
    }

    public void serialize(Writer out) throws IOException {
        out.write(this.myName);
        for (Pair<String, String> parameter : this.myParameters) {
            DbgpOutputMessage.writeOption(out, (String)parameter.getFirst(), (String)parameter.getSecond());
        }
    }

    protected static void writeOption(@NotNull Writer out, @NotNull String optionName, @NotNull String optionValue) throws IOException {
        if (out == null) {
            DbgpOutputMessage.$$$reportNull$$$0(1);
        }
        if (optionName == null) {
            DbgpOutputMessage.$$$reportNull$$$0(2);
        }
        if (optionValue == null) {
            DbgpOutputMessage.$$$reportNull$$$0(3);
        }
        out.write(MessageFormat.format(PARAMETER_FORMAT, optionName, DbgpOutputMessage.encodeValue(optionValue)));
    }

    @NotNull
    private static String encodeValue(@NotNull String optionValue) {
        if (optionValue == null) {
            DbgpOutputMessage.$$$reportNull$$$0(4);
        }
        if (optionValue.contains(" ") || optionValue.contains("\u0000")) {
            String string = (String)StringUtil.QUOTER.apply(StringUtil.escapeQuotes((String)StringUtil.escapeBackSlashes((String)optionValue).replace("\u0000", "\\0")));
            if (string == null) {
                DbgpOutputMessage.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = optionValue;
        if (string == null) {
            DbgpOutputMessage.$$$reportNull$$$0(6);
        }
        return string;
    }

    public DbgpOutputMessage addParameter(@NonNls @NotNull String name, int value) {
        if (name == null) {
            DbgpOutputMessage.$$$reportNull$$$0(7);
        }
        return this.addParameter(name, String.valueOf(value));
    }

    public DbgpOutputMessage addParameter(@NonNls @NotNull String name, boolean value) {
        if (name == null) {
            DbgpOutputMessage.$$$reportNull$$$0(8);
        }
        return this.addParameter(name, value ? 1 : 0);
    }

    public DbgpOutputMessage addParameter(@NonNls @NotNull String name, @NonNls @NotNull String value) {
        if (name == null) {
            DbgpOutputMessage.$$$reportNull$$$0(9);
        }
        if (value == null) {
            DbgpOutputMessage.$$$reportNull$$$0(10);
        }
        this.myParameters.add((Pair<String, String>)Pair.create((Object)name, (Object)value));
        return this;
    }

    public String toString() {
        return this.myName + StringUtil.join(this.myParameters, pair -> (String)pair.first + " " + (String)pair.second, (String)" ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/dbgp/messages/DbgpOutputMessage";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/messages/DbgpOutputMessage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeOption";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "encodeValue";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

