/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.jetbrains.php.debug.TypeInfo;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpExceptionBreak;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbgpProperty
implements TypeInfo {
    private static final int NUMBER_OF_CHILDREN_TO_PRINT = 100;
    private static final String STRING_TYPE = "string";
    private static final String OBJECT_TYPE = "object";
    private static final String ARRAY_TYPE = "array";
    private static final String BOOL_TYPE = "bool";
    private static final String INT_TYPE = "int";
    private static final String FLOAT_TYPE = "float";
    private static final String DOUBLE_TYPE = "double";
    public static final String RESOURCE_TYPE = "resource";
    public static final String NULL_TYPE = "null";
    public static final String UNINITIALIZED_TYPE = "uninitialized";
    private static final Logger LOG = Logger.getInstance(DbgpProperty.class);
    private static final String ATTR_ENCODING = "encoding";
    private static final String TRUE_BOOLEAN = "1";
    private static final String LINE_INDENT = "  ";
    private final Value myShortName;
    private final Value myFullName;
    private final String myType;
    private final Value myClassName;
    private final boolean myIsConstant;
    private final boolean myHasChildren;
    private final String myDefaultEncoding;
    private final Value myRawValue;
    private final int myValueSize;
    private final int myChildCount;
    private final String myAddress;
    private final List<DbgpProperty> myLoadedChildren;
    private final boolean myIsStaticField;
    private final boolean myIsReturnValue;
    private final String myFacet;

    public DbgpProperty(@NotNull Element element) throws IOException {
        Element valueElement;
        if (element == null) {
            DbgpProperty.$$$reportNull$$$0(0);
        }
        this.myLoadedChildren = new ArrayList<DbgpProperty>();
        this.myShortName = DbgpProperty.getExtendedProperty(element, "name");
        this.myFullName = DbgpProperty.getExtendedProperty(element, "fullname");
        this.myType = element.getAttributeValue("type");
        this.myClassName = DbgpProperty.getExtendedProperty(element, "classname");
        this.myIsConstant = DbgpUtil.toBoolean(element.getAttributeValue("constant"));
        this.myFacet = element.getAttributeValue("facet");
        this.myIsReturnValue = this.myFacet != null && StringUtil.split((String)this.myFacet, (String)" ").contains("return_value");
        this.myIsStaticField = this.myFacet != null && StringUtil.split((String)this.myFacet, (String)" ").contains("static");
        this.myHasChildren = DbgpUtil.toBoolean(element.getAttributeValue("children"));
        this.myDefaultEncoding = element.getAttributeValue(ATTR_ENCODING);
        this.myChildCount = StringUtilRt.parseInt((String)element.getAttributeValue("numchildren"), (int)0);
        this.myAddress = element.getAttributeValue("address");
        this.myValueSize = StringUtilRt.parseInt((String)element.getAttributeValue("size"), (int)0);
        String rawValue = element.getText();
        String encoding = this.myDefaultEncoding;
        if (StringUtil.isEmpty((String)rawValue) && (valueElement = element.getChild("value", DbgpUtil.DBGP_NAMESPACE)) != null) {
            rawValue = valueElement.getValue();
            encoding = valueElement.getAttributeValue(ATTR_ENCODING);
        }
        this.myRawValue = new Value(rawValue, encoding == null ? this.myDefaultEncoding : encoding);
        List elements = element.getChildren("property", DbgpUtil.DBGP_NAMESPACE);
        for (Object o : elements) {
            DbgpProperty child = new DbgpProperty((Element)o);
            if ("CLASSNAME".equals(child.getShortName("UTF-8"))) continue;
            this.myLoadedChildren.add(child);
        }
    }

    @NotNull
    private String getPresentationAsInVarDump(@NotNull String encoding, @NotNull String prefix) {
        if (encoding == null) {
            DbgpProperty.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            DbgpProperty.$$$reportNull$$$0(2);
        }
        StringBuilder builder2 = new StringBuilder(prefix);
        if (this.isFloat() || this.isInt()) {
            builder2.append(this.myType).append("(").append((String)this.getLoadedValue((String)encoding).first).append(")");
        } else if (this.isBoolean()) {
            builder2.append(this.myType).append("(").append(((String)this.getLoadedValue((String)encoding).first).equals(TRUE_BOOLEAN)).append(")");
        } else if (this.isNull()) {
            builder2.append(this.myType.toUpperCase(Locale.ROOT));
        } else if (this.isString()) {
            builder2.append(this.myType).append("(").append(this.myValueSize).append(") ").append((String)this.getLoadedValue((String)encoding).first);
        } else if (this.isObject() || this.isArray()) {
            int remainingCount;
            List children = this.getLoadedChildren().stream().limit(100L).toList();
            if (this.isObject()) {
                builder2.append("class ").append(this.myClassName.getValue(encoding)).append(" (").append(this.myChildCount).append(") {\n");
                for (DbgpProperty child : children) {
                    builder2.append(prefix).append(LINE_INDENT).append(child.getFacet()).append(" $").append(child.getShortName(encoding)).append(" =>\n").append(child.getPresentationAsInVarDump(encoding, LINE_INDENT)).append("\n");
                }
            } else {
                builder2.append(this.myType).append("(").append(this.myChildCount).append(") {\n");
                for (int index = 0; index < children.size(); ++index) {
                    DbgpProperty childProperty = (DbgpProperty)children.get(index);
                    builder2.append(prefix).append(LINE_INDENT).append("[").append(childProperty.getShortName(encoding)).append("]=>\n").append(childProperty.getPresentationAsInVarDump(encoding, LINE_INDENT)).append("\n");
                }
            }
            if ((remainingCount = this.myChildCount - 100) > 0) {
                builder2.append("\n").append(prefix).append(LINE_INDENT).append("(").append(remainingCount).append(" more elements)...\n");
            }
            builder2.append(prefix).append("}");
        }
        String string = builder2.toString();
        if (string == null) {
            DbgpProperty.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentationAsInVarDump(@NotNull String encoding) {
        if (encoding == null) {
            DbgpProperty.$$$reportNull$$$0(4);
        }
        return this.getPresentationAsInVarDump(encoding, "");
    }

    public boolean isReturnValue() {
        return this.myIsReturnValue;
    }

    @Nullable
    private static Value getExtendedProperty(@NotNull Element element, @NotNull String name) {
        Element child;
        String value;
        if (element == null) {
            DbgpProperty.$$$reportNull$$$0(5);
        }
        if (name == null) {
            DbgpProperty.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)(value = element.getAttributeValue(name))) && (child = element.getChild(name, DbgpUtil.DBGP_NAMESPACE)) != null) {
            String encoding = child.getAttributeValue(ATTR_ENCODING);
            return new Value(child.getValue(), encoding);
        }
        return new Value(value);
    }

    public DbgpProperty(@NotNull DbgpExceptionBreak exception) {
        if (exception == null) {
            DbgpProperty.$$$reportNull$$$0(7);
        }
        this.myLoadedChildren = new ArrayList<DbgpProperty>();
        this.myFullName = this.myShortName = new Value("Exception");
        this.myType = OBJECT_TYPE;
        this.myClassName = new Value(exception.getExceptionName());
        this.myIsConstant = false;
        this.myIsStaticField = false;
        this.myIsReturnValue = false;
        this.myHasChildren = true;
        this.myDefaultEncoding = null;
        this.myRawValue = new Value("");
        this.myValueSize = 0;
        this.myAddress = null;
        this.myFacet = null;
        boolean hasCode = StringUtil.isNotEmpty((String)exception.getCode());
        int n = this.myChildCount = hasCode ? 2 : 1;
        if (hasCode) {
            this.myLoadedChildren.add(new DbgpProperty("code", exception.getCode(), INT_TYPE, null));
        }
        this.myLoadedChildren.add(new DbgpProperty("message", exception.getMessage(), STRING_TYPE, null));
    }

    protected DbgpProperty(@NotNull String name, @NotNull String value, @NotNull String type, @Nullable String className) {
        if (name == null) {
            DbgpProperty.$$$reportNull$$$0(8);
        }
        if (value == null) {
            DbgpProperty.$$$reportNull$$$0(9);
        }
        if (type == null) {
            DbgpProperty.$$$reportNull$$$0(10);
        }
        this.myLoadedChildren = new ArrayList<DbgpProperty>();
        this.myFullName = this.myShortName = new Value(name);
        this.myType = type;
        this.myClassName = className != null ? new Value(className) : null;
        this.myIsConstant = false;
        this.myIsStaticField = false;
        this.myIsReturnValue = false;
        this.myHasChildren = false;
        this.myDefaultEncoding = "";
        this.myRawValue = new Value(value);
        this.myValueSize = STRING_TYPE.equals(type) ? value.length() : 0;
        this.myChildCount = 0;
        this.myAddress = null;
        this.myFacet = null;
    }

    public String getShortName(@NotNull String targetEncoding) {
        if (targetEncoding == null) {
            DbgpProperty.$$$reportNull$$$0(11);
        }
        return this.myShortName.getValue(targetEncoding);
    }

    @NotNull
    public String getFullName(@NotNull String targetEncoding, boolean forEvaluation) {
        if (targetEncoding == null) {
            DbgpProperty.$$$reportNull$$$0(12);
        }
        String value = this.myFullName.getValue(targetEncoding);
        if (forEvaluation) {
            int l = value.indexOf(42);
            int r = value.lastIndexOf(42);
            if (l >= 0 && r > l) {
                String string = value.substring(0, l) + value.substring(r + 1);
                if (string == null) {
                    DbgpProperty.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        String string = value;
        if (string == null) {
            DbgpProperty.$$$reportNull$$$0(14);
        }
        return string;
    }

    public String getClassName(@NotNull String targetEncoding) {
        if (targetEncoding == null) {
            DbgpProperty.$$$reportNull$$$0(15);
        }
        return this.myClassName.getValue(targetEncoding);
    }

    public boolean isInitialized() {
        return !UNINITIALIZED_TYPE.equals(this.myType);
    }

    @Override
    public boolean isNull() {
        return NULL_TYPE.equals(this.myType);
    }

    @Override
    public boolean isString() {
        return STRING_TYPE.equals(this.myType);
    }

    public boolean isArray() {
        return ARRAY_TYPE.equals(this.myType);
    }

    public boolean isObject() {
        return OBJECT_TYPE.equals(this.myType);
    }

    public boolean isConstant() {
        return this.myIsConstant;
    }

    public boolean isStaticField() {
        return this.myIsStaticField;
    }

    @Override
    public boolean isBoolean() {
        return BOOL_TYPE.equals(this.myType);
    }

    @Override
    public boolean isNumber() {
        return INT_TYPE.equals(this.myType) || FLOAT_TYPE.equals(this.myType) || DOUBLE_TYPE.equals(this.myType);
    }

    public boolean isInt() {
        return INT_TYPE.equals(this.myType);
    }

    @Override
    public boolean isFloat() {
        return FLOAT_TYPE.equals(this.myType) || DOUBLE_TYPE.equals(this.myType);
    }

    public boolean isResource() {
        return RESOURCE_TYPE.equals(this.myType);
    }

    public boolean hasChildren() {
        return this.myHasChildren;
    }

    public String getEncoding() {
        return this.myDefaultEncoding;
    }

    public String getFacet() {
        return this.myFacet;
    }

    @NotNull
    public Pair<String, Integer> getLoadedValue(@NotNull String encoding) {
        if (encoding == null) {
            DbgpProperty.$$$reportNull$$$0(16);
        }
        String rawValue = this.myRawValue.myValue;
        if ("base64".equals(this.myRawValue.myEncoding)) {
            Pair pair;
            try {
                byte[] decoded = Base64.getDecoder().decode(rawValue);
                pair = Pair.create((Object)new String(decoded, encoding), (Object)decoded.length);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Throwable)e);
                Pair pair2 = Pair.empty();
                if (pair2 == null) {
                    DbgpProperty.$$$reportNull$$$0(18);
                }
                return pair2;
            }
            if (pair == null) {
                DbgpProperty.$$$reportNull$$$0(17);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)rawValue, (Object)rawValue.length());
        if (pair == null) {
            DbgpProperty.$$$reportNull$$$0(19);
        }
        return pair;
    }

    public int getValueSize() {
        return this.myValueSize;
    }

    public int getChildCount() {
        return this.myChildCount;
    }

    public List<DbgpProperty> getLoadedChildren() {
        return this.myLoadedChildren;
    }

    public String getAddress() {
        return this.myAddress;
    }

    public String getType() {
        return this.myType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 13, 14, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTR_ENCODING;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/dbgp/model/DbgpProperty";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEncoding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/model/DbgpProperty";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationAsInVarDump";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationAsInVarDump";
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getClassName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLoadedValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 13, 14, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    private static class Value {
        @NotNull
        private final String myValue;
        @Nullable
        private final String myEncoding;

        Value(@Nullable String value) {
            this.myValue = StringUtil.notNullize((String)value);
            this.myEncoding = null;
        }

        Value(@Nullable String value, @Nullable String encoding) {
            this.myValue = StringUtil.notNullize((String)value);
            this.myEncoding = encoding;
        }

        @NotNull
        public String getValue(@NotNull String targetEncoding) {
            if (targetEncoding == null) {
                Value.$$$reportNull$$$0(0);
            }
            if (this.myEncoding != null && "base64".equals(this.myEncoding)) {
                byte[] decoded = Base64.getDecoder().decode(this.myValue);
                try {
                    return new String(decoded, targetEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error((Throwable)e);
                    return "";
                }
            }
            String string = this.myValue;
            if (string == null) {
                Value.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetEncoding";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/xdebug/dbgp/model/DbgpProperty$Value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/model/DbgpProperty$Value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

