/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.install;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.EdtReplacementThread;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.xdebug.install.XdebugDownloader;
import com.jetbrains.php.debug.xdebug.install.XdebugUtilsKt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugDownloaderLinux
extends XdebugDownloader {
    AnAction generateSsh;

    public XdebugDownloaderLinux(@NotNull Project project, @NotNull String phpinfo, @Nullable XDebugSession session, @Nullable String phpHomePath) {
        if (project == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(0);
        }
        if (phpinfo == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(1);
        }
        super(project, phpinfo, session, phpHomePath);
        this.generateSsh = NotificationAction.createSimpleExpiring((String)PhpBundle.message("PhpInterpreterConfigurable.generate.xdebug.extension", new Object[0]), () -> {
            this.analyseInfoFromPhpInfo(null);
            this.download();
            this.generateAndOpenShellScript();
        });
    }

    @Override
    protected void install() {
        this.runInstallationShellScript(null);
    }

    @Override
    public AnAction[] getActions() {
        return new AnAction[]{this.downloadAndInstall, this.generateSsh};
    }

    @Override
    public void downloadAndInstall(@NotNull Consumer<ProcessOutput> outputConsumer) {
        if (outputConsumer == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(2);
        }
        this.analyseInfoFromPhpInfo(() -> outputConsumer.accept(null));
        this.download();
        this.runInstallationShellScript(outputConsumer);
        this.updatePhpIni();
    }

    private void runInstallationShellScript(@Nullable Consumer<ProcessOutput> outputConsumer) {
        if (!this.isConfigurationValid()) {
            return;
        }
        try {
            Path unzipAndBuildScriptPath = this.createScript("unzipAndBuildXdebug", XdebugUtilsKt::getUnzipAndBuildScript);
            GeneralCommandLine unzipAndBuildCommandLine = this.createCommandLine(unzipAndBuildScriptPath, false);
            Path installationScriptPath = this.createScript("installXdebug", XdebugUtilsKt::getXdebugMovementAndConfigUpdateScript);
            GeneralCommandLine installationCommandLine = this.createCommandLine(installationScriptPath, true);
            Task.Backgroundable task = this.getBackgroundableTask(unzipAndBuildCommandLine, installationCommandLine, outputConsumer);
            task.queue();
        }
        catch (ExecutionException | IOException throwable) {
            // empty catch block
        }
    }

    private void generateAndOpenShellScript() {
        if (!this.isConfigurationValid()) {
            return;
        }
        try {
            this.tryOpenFileScriptInEditor();
        }
        catch (ExecutionException | IOException throwable) {
            // empty catch block
        }
    }

    private void tryOpenFileScriptInEditor() throws IOException, ExecutionException {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        Path scriptPath = this.createScript("compileAndInstallXdebug", XdebugUtilsKt::getInstallationScript);
        VirtualFile file = VfsUtil.findFile((Path)scriptPath, (boolean)true);
        if (file == null) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(file);
        if (psiFile != null) {
            EditorHelper.openInEditor((PsiElement)psiFile);
        }
    }

    @NotNull
    private GeneralCommandLine createCommandLine(Path scriptPath, boolean sudo) throws IOException, ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"sh", scriptPath.toAbsolutePath().toString()});
        commandLine.setWorkDirectory(this.myProject.getBasePath());
        GeneralCommandLine generalCommandLine = sudo ? ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)PhpBundle.message("move.xdebug.file.to.the.extensions.directory.and.update.configuration.file", new Object[0])) : commandLine;
        if (generalCommandLine == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(3);
        }
        return generalCommandLine;
    }

    private boolean isConfigurationValid() {
        return this.myDownloadedFile != null && this.myPhpHomePath != null;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Task.Backgroundable getBackgroundableTask(final @NotNull GeneralCommandLine nonSudoCommandLine, final @NotNull GeneralCommandLine sudoCommandLine, final @Nullable Consumer<ProcessOutput> callback) {
        if (nonSudoCommandLine == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(4);
        }
        if (sudoCommandLine == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(5);
        }
        return new Task.Backgroundable(this.myProject, PhpBundle.message("xdebug.compile.task", new Object[0]), true){
            ProcessOutput myProcessOutput;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CapturingProcessHandler handler = new CapturingProcessHandler(nonSudoCommandLine);
                    this.myProcessOutput = handler.runProcessWithProgressIndicator(indicator);
                    if (this.myProcessOutput.getExitCode() != 0) {
                        return;
                    }
                    handler = new CapturingProcessHandler(sudoCommandLine){

                        protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                            return new CapturingProcessAdapter(processOutput){

                                public void processTerminated(@NotNull ProcessEvent event) {
                                    if (event == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    ApplicationManager.getApplication().invokeLater(() -> {
                                        XdebugDownloaderLinux.this.restartDebug();
                                        LocalFileSystem.getInstance().refreshAndFindFileByPath(XdebugDownloaderLinux.this.phpiniPath);
                                    });
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderLinux$1$1$1", "processTerminated"));
                                }
                            };
                        }
                    };
                    this.myProcessOutput = handler.runProcessWithProgressIndicator(indicator);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }

            public void onFinished() {
                super.onFinished();
                if (this.myProcessOutput != null && callback != null) {
                    callback.accept(this.myProcessOutput);
                }
            }

            @NotNull
            public EdtReplacementThread whereToRunCallbacks() {
                EdtReplacementThread edtReplacementThread = EdtReplacementThread.EDT;
                if (edtReplacementThread == null) {
                    1.$$$reportNull$$$0(1);
                }
                return edtReplacementThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderLinux$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderLinux$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "whereToRunCallbacks";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private Path createScript(@NotNull String scriptName, @NotNull BiFunction<XdebugDownloader, Path, String> scriptGenerator) throws IOException, ExecutionException {
        if (scriptName == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(6);
        }
        if (scriptGenerator == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(7);
        }
        assert (this.myDownloadedFile != null);
        assert (this.myPhpHomePath != null);
        Path path = this.myDownloadedFile.toNioPath();
        String scriptText = scriptGenerator.apply(this, path);
        Path path2 = ExecUtil.createTempExecutableScript((String)scriptName, (String)".sh", (String)scriptText).toPath();
        if (path2 == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(8);
        }
        return path2;
    }

    @Override
    protected String getName(String link) {
        return Objects.requireNonNull(StringUtil.substringAfterLast((String)link, (String)"/"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpinfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderLinux";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonSudoCommandLine";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sudoCommandLine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderLinux";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "downloadAndInstall";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundableTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createScript";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }
}

