/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerServer;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerServerConnectionManager;
import com.jetbrains.php.debug.zend.debugger.ZendDebuggerDriver;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.util.QueryString;
import com.jetbrains.php.util.connection.PhpConnectionInitCallback;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZendDebuggerExtension
implements PhpDebugExtension {
    public static final ZendDebuggerExtension INSTANCE = new ZendDebuggerExtension();
    public static final String ID = "ZendDebugger";
    public static final String NAME = "Zend Debugger";
    private static final String ZEND_DEBUGGER_ALLOW_HOSTS = "zend_debugger.allow_hosts";
    private static final String ZEND_DEBUGGER_ENABLE_COVERAGE = "zend_debugger.enable_coverage";
    private static final String ENV_QUERY_STRING = "QUERY_STRING";

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public List<PhpConfigurationOption> getDebugConfigurationsOptions(@NotNull Project project, @NotNull String remoteHost, @NotNull PhpInterpreter interpreter) {
        if (project == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(0);
        }
        if (remoteHost == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(1);
        }
        if (interpreter == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(2);
        }
        String allowedHosts = PhpProjectDebugConfiguration.getInstance(project).getZendDebuggerHost();
        List<PhpConfigurationOption> list = List.of(new PhpConfigurationOption(ZEND_DEBUGGER_ALLOW_HOSTS, allowedHosts));
        if (list == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public PhpIncomingDebugConnectionServer startDebugServer(@NotNull Project project, @Nullable PhpConnectionInitCallback callback) throws ExecutionException {
        if (project == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(4);
        }
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
        assert (state != null);
        int debugPort = state.getZendDebuggerDebugPort();
        PhpIncomingDebugConnectionServer phpIncomingDebugConnectionServer = this.startDebugServer(project, debugPort, callback);
        if (phpIncomingDebugConnectionServer == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(5);
        }
        return phpIncomingDebugConnectionServer;
    }

    @Override
    @NotNull
    public PhpIncomingDebugConnectionServer startLocalDebugServer(@NotNull Project project) throws ExecutionException {
        if (project == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(6);
        }
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
        assert (state != null);
        int debugPort = state.getZendDebuggerDebugPort();
        PhpIncomingDebugConnectionServer phpIncomingDebugConnectionServer = this.startDebugServer(project, debugPort, null);
        if (phpIncomingDebugConnectionServer == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(7);
        }
        return phpIncomingDebugConnectionServer;
    }

    @Override
    @NotNull
    public PhpIncomingDebugConnectionServer startDebugServer(@NotNull Project project, int port, @Nullable PhpConnectionInitCallback callback) throws ExecutionException {
        if (project == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(8);
        }
        ZendDebuggerServer server = (ZendDebuggerServer)ZendDebuggerServerConnectionManager.getInstance().start(port);
        if (callback != null) {
            callback.onInit(null);
        }
        ZendDebuggerServer zendDebuggerServer = server;
        if (zendDebuggerServer == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(9);
        }
        return zendDebuggerServer;
    }

    @Override
    @NotNull
    public PhpDebugConnectionManager createDebugConnectionManager() {
        return new PhpDebugConnectionManager();
    }

    @Override
    @NotNull
    public PhpDebugDriver getDebugDriver() {
        ZendDebuggerDriver zendDebuggerDriver = ZendDebuggerDriver.INSTANCE;
        if (zendDebuggerDriver == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(10);
        }
        return zendDebuggerDriver;
    }

    @Override
    @NotNull
    public Map<String, String> getDebugEnv(@NotNull Project project, boolean breakAtTheFirstLine, @NotNull String sessionId) {
        if (project == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(11);
        }
        if (sessionId == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(12);
        }
        HashMap<String, String> envParams = new HashMap<String, String>();
        envParams.put(ENV_QUERY_STRING, this.getDebugQuery(project, breakAtTheFirstLine, sessionId).toString());
        HashMap<String, String> hashMap = envParams;
        if (hashMap == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public QueryString getDebugQuery(@NotNull Project project, boolean breakAtFistLine, @NotNull String sessionId) {
        if (project == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(14);
        }
        if (sessionId == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(15);
        }
        QueryString queryString = new QueryString();
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
        assert (state != null);
        int debugPort = state.getZendDebuggerDebugPort();
        queryString.addParameter("start_debug", "1");
        queryString.addParameter("send_sess_end", "1");
        queryString.addParameter("debug_start_session", "1");
        queryString.addParameter("debug_session_id", sessionId);
        queryString.addParameter("debug_port", String.valueOf(debugPort));
        queryString.addParameter("debug_host", PhpProjectDebugConfiguration.getInstance(project).getZendDebuggerHost());
        if (breakAtFistLine) {
            queryString.addParameter("debug_stop", "1");
        }
        QueryString queryString2 = queryString;
        if (queryString2 == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(16);
        }
        return queryString2;
    }

    @NotNull
    public static Map<String, String> getCoverageEnv(@NotNull Project project, @NotNull String sessionId) {
        if (project == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(17);
        }
        if (sessionId == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(18);
        }
        HashMap<String, String> envParams = new HashMap<String, String>();
        envParams.put(ENV_QUERY_STRING, ZendDebuggerExtension.getCoverageQuery(project, sessionId).toString());
        HashMap<String, String> hashMap = envParams;
        if (hashMap == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(19);
        }
        return hashMap;
    }

    @NotNull
    private static QueryString getCoverageQuery(@NotNull Project project, @NotNull String sessionId) {
        if (project == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(20);
        }
        if (sessionId == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(21);
        }
        QueryString queryString = new QueryString();
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(project).getState();
        assert (state != null);
        int debugPort = state.getZendDebuggerDebugPort();
        queryString.addParameter("start_debug", "1");
        queryString.addParameter("start_profile", "1");
        queryString.addParameter("send_debug_header", "1");
        queryString.addParameter("no_remote", "1");
        queryString.addParameter("send_sess_end", "1");
        queryString.addParameter("debug_start_session", "1");
        queryString.addParameter("debug_session_id", sessionId);
        queryString.addParameter("debug_port", String.valueOf(debugPort));
        queryString.addParameter("debug_host", PhpProjectDebugConfiguration.getInstance(project).getZendDebuggerHost());
        queryString.addParameter("debug_coverage", "1");
        QueryString queryString2 = queryString;
        if (queryString2 == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(22);
        }
        return queryString2;
    }

    @NotNull
    public static List<PhpConfigurationOption> getCoverageConfigurationsOptions() {
        List<PhpConfigurationOption> list = Collections.singletonList(new PhpConfigurationOption(ZEND_DEBUGGER_ENABLE_COVERAGE, 1));
        if (list == null) {
            ZendDebuggerExtension.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 9, 10, 13, 16, 19, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHost";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/zend/ZendDebuggerExtension";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/zend/ZendDebuggerExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugConfigurationsOptions";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugServer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startLocalDebugServer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugDriver";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugEnv";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugQuery";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageEnv";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageQuery";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageConfigurationsOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDebugConfigurationsOptions";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startDebugServer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startLocalDebugServer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDebugEnv";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDebugQuery";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageEnv";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageQuery";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 9, 10, 13, 16, 19, 22, 23 -> new IllegalStateException(string);
        };
    }
}

