/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend;

import com.intellij.util.TimeoutUtil;
import com.jetbrains.php.debug.zend.ZendDebugUtil;
import com.jetbrains.php.debug.zend.messages.GetScriptProfilerInfoResponse;
import com.jetbrains.php.debug.zend.messages.ZendDebugInputMessage;
import com.jetbrains.php.debug.zend.messages.ZendDebugMessage;
import com.jetbrains.php.debug.zend.messages.ZendDebugOutputMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public final class ZendProtocolDumperTool {
    private static final int myDebuggerPort = 10137;
    private static final int myIDEPort = 10138;
    private static final String myIDEIPV4Address = "172.26.240.248";

    public static void main(String[] args) {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(10137);
            System.out.println("start listening on port 10137");
        }
        catch (IOException e) {
            return;
        }
        try {
            try {
                while (true) {
                    Socket socket = serverSocket.accept();
                    System.out.println("debugger socket created");
                    new Tunnel(socket).start();
                }
            }
            catch (IOException iOException) {
                try {
                    System.out.println("stop listening on port 10137");
                    serverSocket.close();
                }
                catch (IOException iOException2) {}
            }
        }
        catch (Throwable throwable) {
            try {
                System.out.println("stop listening on port 10137");
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static class Tunnel
    extends Thread {
        private final Socket myDebuggerSocket;

        public Tunnel(Socket debuggerSocket) {
            super("zend dumper");
            this.myDebuggerSocket = debuggerSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Socket ideSocket = null;
            try {
                InputStream fromDebugger = this.myDebuggerSocket.getInputStream();
                OutputStream toDebugger = this.myDebuggerSocket.getOutputStream();
                try {
                    ideSocket = new Socket(InetAddress.getByName(ZendProtocolDumperTool.myIDEIPV4Address), 10138);
                    InputStream fromIde = ideSocket.getInputStream();
                    OutputStream toIde = ideSocket.getOutputStream();
                    System.out.println("ide socket created, port 10138");
                    Thread fromDebuggerToIde = new Thread(() -> {
                        try {
                            DataInputStream dataFromDebugger = new DataInputStream(fromDebugger);
                            DataOutputStream dataToIde = new DataOutputStream(toIde);
                            while (true) {
                                int packetLength = dataFromDebugger.readInt();
                                byte[] packet = new byte[packetLength];
                                dataFromDebugger.readFully(packet);
                                Tunnel.analyzePacketFromDebugger(packet);
                                dataToIde.writeInt(packetLength);
                                dataToIde.write(packet);
                                dataToIde.flush();
                            }
                        }
                        catch (IOException e) {
                            System.out.println("stop to write from debugger to ide");
                            return;
                        }
                    }, "zend protocol dump");
                    Thread fromIdeToDebugger = new Thread(() -> {
                        try {
                            DataOutputStream dataToDebugger = new DataOutputStream(toDebugger);
                            DataInputStream dataFromIde = new DataInputStream(fromIde);
                            while (true) {
                                int packetLength = dataFromIde.readInt();
                                byte[] packet = new byte[packetLength];
                                dataFromIde.readFully(packet);
                                Tunnel.analyzePacketFromIde(packet);
                                dataToDebugger.writeInt(packetLength);
                                dataToDebugger.write(packet);
                                dataToDebugger.flush();
                            }
                        }
                        catch (IOException e) {
                            System.out.println("stop to write from ide to debugger");
                            return;
                        }
                    }, "zend proto2 dump");
                    fromDebuggerToIde.start();
                    fromIdeToDebugger.start();
                    while (fromDebuggerToIde.isAlive() && fromIdeToDebugger.isAlive()) {
                        TimeoutUtil.sleep((long)10000L);
                    }
                }
                catch (IOException e) {
                    if (ideSocket != null) {
                        ideSocket.close();
                    }
                    throw new IOException();
                }
            }
            catch (IOException e) {
                System.out.println("socket closed");
            }
            finally {
                try {
                    this.myDebuggerSocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        public static void analyzePacketFromDebugger(byte[] packet) {
            try {
                ZendDebugInputMessage message = ZendDebugUtil.readMessage(packet);
                if (message != null) {
                    Tunnel.analyzeMessageFromDebugger(message);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void analyzeMessageFromDebugger(@NotNull ZendDebugMessage message) {
            if (message == null) {
                Tunnel.$$$reportNull$$$0(0);
            }
            if (message instanceof GetScriptProfilerInfoResponse) {
                GetScriptProfilerInfoResponse.FunctionInfo[] functionInfos;
                GetScriptProfilerInfoResponse scriptProfilerInfoResponse = (GetScriptProfilerInfoResponse)message;
                for (GetScriptProfilerInfoResponse.FunctionInfo functionInfo : functionInfos = scriptProfilerInfoResponse.getFunctionInfos()) {
                    System.out.println(functionInfo.getTotalTimeS());
                }
                System.out.println();
            }
            System.out.println(message.toString());
        }

        public static void analyzePacketFromIde(byte[] packet) {
            try {
                ZendDebugOutputMessage message = ZendDebugUtil.parsePacketToDebugger(packet);
                if (message != null) {
                    Tunnel.analyzeMessageFromIDE(message);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void analyzeMessageFromIDE(@NotNull ZendDebugOutputMessage message) {
            if (message == null) {
                Tunnel.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "message";
            objectArray2[1] = "com/jetbrains/php/debug/zend/ZendProtocolDumperTool$Tunnel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "analyzeMessageFromDebugger";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "analyzeMessageFromIDE";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

