/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.injection;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.injection.PhpInjectorBase;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpFunctionParameterLanguageInjectorBase
extends PhpInjectorBase {
    private static final Condition<PsiElement> MAY_HAVE_LANGUAGE_PARAMETER_INJECTION = e -> e instanceof FunctionReference || e instanceof PhpAttribute || e instanceof NewExpression;

    @Override
    @Nullable
    public Language doGetInjectedLanguage(@NotNull PsiElement context) {
        ParameterListOwner parameterListOwner;
        if (context == null) {
            PhpFunctionParameterLanguageInjectorBase.$$$reportNull$$$0(0);
        }
        if ((parameterListOwner = (ParameterListOwner)PhpPsiUtil.getParentByCondition(context, MAY_HAVE_LANGUAGE_PARAMETER_INJECTION, (Condition<? super PsiElement>)Statement.INSTANCEOF)) == null) {
            return null;
        }
        List<PsiElement> arguments = Arrays.asList(parameterListOwner.getParameters());
        int argumentIndex = ContainerUtil.indexOf(arguments, p -> PhpFunctionParameterLanguageInjectorBase.isPartOfInjectedArgument(context, p));
        if (argumentIndex < 0) {
            return null;
        }
        PhpReference reference = PhpWorkaroundUtil.getFunctionReferenceToResolve((PsiElement)parameterListOwner);
        if (reference == null || !this.canResolveToFunctionWithParameterToInject(reference)) {
            return null;
        }
        for (Function f : PhpWorkaroundUtil.resolveTargetFunctions(reference)) {
            Parameter param = PhpParamsInspection.getMappedParam(arguments, Arrays.asList(f.getParameters()), argumentIndex);
            Language language = param != null ? this.getLanguageToInject(f, param) : null;
            if (language == null) continue;
            return language;
        }
        return null;
    }

    protected abstract boolean canResolveToFunctionWithParameterToInject(@NotNull PhpReference var1);

    @Nullable
    protected String getNameToCheckResolve(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpFunctionParameterLanguageInjectorBase.$$$reportNull$$$0(1);
        }
        if (reference instanceof FunctionReference) {
            return reference.getName();
        }
        if (reference instanceof ClassReference) {
            return "__construct";
        }
        return null;
    }

    protected abstract Language getLanguageToInject(Function var1, Parameter var2);

    private static boolean isPartOfInjectedArgument(@NotNull PsiElement context, PsiElement argument) {
        if (context == null) {
            PhpFunctionParameterLanguageInjectorBase.$$$reportNull$$$0(2);
        }
        return argument == context || argument instanceof ConcatenationExpression && PhpCompletionContributor.unwrapOperands((BinaryExpression)((ConcatenationExpression)argument)).contains(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/injection/PhpFunctionParameterLanguageInjectorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetInjectedLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNameToCheckResolve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPartOfInjectedArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

