/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpEditorOptions;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.findUsages.PhpGotoTargetRendererProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpElementWithModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final Comparator<PhpNamedElement> PHP_NAMED_ELEMENT_COMPARATOR = Comparator.comparing(PhpNamedElement::getFQN);
    public static final String SPACE = "&nbsp;";
    public static final String BREAK = "<br>";

    @NotNull
    public String getName() {
        String string = PhpBundle.message("extends.implements.overrides", new Object[0]);
        if (string == null) {
            PhpLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static void findChildren(PhpNamedElement element, Collection<? super LineMarkerInfo<?>> markers) {
        Project project = element.getProject();
        if (element instanceof PhpClass) {
            PsiElement identifier;
            boolean subclassExists;
            PhpClass clazz = (PhpClass)element;
            Icon icon = clazz.isInterface() ? PhpIcons.IMPLEMENTED : PhpIcons.OVERRIDEN;
            PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
            boolean bl = clazz.isTrait() ? !phpIndex.getTraitUsages(clazz).isEmpty() : (subclassExists = PhpClassHierarchyUtils.subclassExists((PhpClass)clazz));
            if (subclassExists && (identifier = element.getNameIdentifier()) != null) {
                markers.add(new LineMarkerInfo(identifier, identifier.getTextRange(), icon, (com.intellij.util.Function)new PhpClassOverridenTooltipGenerator(clazz, (PsiElement)element, project), (GutterIconNavigationHandler)new PhpClassGutterIconNavigationHandler(clazz), GutterIconRenderer.Alignment.LEFT));
            }
        } else if (element instanceof Method || element instanceof Field) {
            PsiElement identifier = element.getNameIdentifier();
            MyHierarchyMemberProcessor memberProcessor = new MyHierarchyMemberProcessor(false){

                @Override
                public boolean process(PhpClassMember member, PhpClass subClass, PhpClass baseClass) {
                    super.process(member, subClass, baseClass);
                    return false;
                }
            };
            PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)((PhpClassMember)element), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)memberProcessor);
            if (!memberProcessor.myMembers.isEmpty()) {
                PhpLineMarkerProvider.registerLineMarker((PhpClassMember)element, identifier, markers, PhpLineMarkerProvider::findChildrenMembers, memberProcessor.icon);
            }
        } else if (element instanceof PhpTraitUseRule) {
            PhpLineMarkerProvider.registerOverriddingTraitUseRuleMethod(element, markers);
        }
    }

    public static Collection<? extends PhpNamedElement> findChildrenMembers(PhpClassMember m) {
        MyHierarchyMemberProcessor memberProcessor = new MyHierarchyMemberProcessor(false);
        PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)m, (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)memberProcessor);
        memberProcessor.myMembers.sort(PHP_NAMED_ELEMENT_COMPARATOR);
        return memberProcessor.myMembers;
    }

    private static void registerOverriddingTraitUseRuleMethod(PhpNamedElement element, Collection<? super LineMarkerInfo<?>> markers) {
        PsiElement nameIdentifier;
        Method method = ((PhpTraitUseRule)element).getMethod();
        if (method == null) {
            return;
        }
        PhpClass containingClass = PhpPsiUtil.getParentOfClass((PsiElement)element, PhpClass.class);
        if (containingClass == null) {
            return;
        }
        MethodReference originalReference = ((PhpTraitUseRule)element).getOriginalReference();
        ASTNode nameNode = originalReference != null ? originalReference.getNameNode() : null;
        PsiElement psiElement = nameIdentifier = nameNode != null ? nameNode.getPsi() : null;
        if (nameIdentifier == null) {
            return;
        }
        MyHierarchyMemberProcessor memberProcessor = new MyHierarchyMemberProcessor(false);
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (PhpClass)containingClass, (m, subClass, baseClass) -> memberProcessor.process(m, subClass, baseClass) && !memberProcessor.myMembers.isEmpty());
        if (!memberProcessor.myMembers.isEmpty()) {
            PhpLineMarkerProvider.registerLineMarker((PhpClassMember)method, nameIdentifier, markers, m -> PhpLineMarkerProvider.getOverridingTraitUseRuleMethods(m, containingClass), memberProcessor.icon);
        }
    }

    private static Collection<? extends PhpNamedElement> getOverridingTraitUseRuleMethods(PhpClassMember member, PhpClass containingClass) {
        MyHierarchyMemberProcessor memberProcessor = new MyHierarchyMemberProcessor(false);
        PhpClassHierarchyUtils.processOverridingMethods((Method)((Method)member), (PhpClass)containingClass, (m, subClass, baseClass) -> memberProcessor.process(m, subClass, baseClass));
        memberProcessor.myMembers.sort(PHP_NAMED_ELEMENT_COMPARATOR);
        return memberProcessor.myMembers;
    }

    private static void registerLineMarker(PhpClassMember element, PsiElement identifier, Collection<? super LineMarkerInfo<?>> markers, java.util.function.Function<PhpClassMember, Collection<? extends PhpNamedElement>> elementsSupplier, Icon icon) {
        if (identifier == null) {
            return;
        }
        markers.add(new LineMarkerInfo(identifier, identifier.getTextRange(), icon, (com.intellij.util.Function)new PhpMemberOverridenTooltipGenerator(element, elementsSupplier), (GutterIconNavigationHandler)new PhpMemberGutterIconNavigationHandler(element, elementsSupplier), GutterIconRenderer.Alignment.LEFT));
    }

    @Nls
    private static String getChildTitle(PhpNamedElement element) {
        return element instanceof PhpClass && ((PhpClass)element).isInterface() ? PhpBundle.message("gutter.overriden.select.implementation.title", element.getName()) : PhpBundle.message("gutter.overriden.select.subclass.title", element.getName());
    }

    @Nls
    private static String getPinTitle(PhpNamedElement element) {
        return element instanceof PhpClass && ((PhpClass)element).isInterface() ? PhpBundle.message("gutter.pin.overriden.select.implementation.title", element.getName()) : PhpBundle.message("gutter.pin.overriden.select.subclass.title", element.getName());
    }

    private static void findParents(PhpNamedElement element, Collection<? super LineMarkerInfo<?>> markers) {
        if (element instanceof Method || element instanceof Field) {
            PsiElement identifier;
            MyHierarchyMemberProcessor memberProcessor = new MyHierarchyMemberProcessor(true);
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)((PhpClassMember)element), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)memberProcessor);
            if (!memberProcessor.myMembers.isEmpty() && (identifier = element.getNameIdentifier()) != null) {
                Project project = identifier.getProject();
                markers.add(new LineMarkerInfo(identifier, identifier.getTextRange(), memberProcessor.icon, (com.intellij.util.Function)new OverridesTooltipGenerator(memberProcessor.myMembers, project), (GutterIconNavigationHandler)new PhpParentGutterIconNavigationHandler(memberProcessor.myMembers, PhpBundle.message("gutter.overriding.select.title", new Object[0]), PhpBundle.message("gutter.pin.overriding.select.title", element.getName()), project), GutterIconRenderer.Alignment.LEFT));
            }
        }
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((parent = element.getParent()) instanceof PhpNamedElement && ((PhpNamedElement)parent).getDocComment() != null) {
            return null;
        }
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.kwFUNCTION, PhpTokenTypes.kwCLASS, PhpTokenTypes.kwNAMESPACE)) {
            PsiElement modifierList;
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.kwFUNCTION) && (modifierList = PhpPsiUtil.getChildOfType(parent, PhpElementTypes.MODIFIER_LIST)) != null && modifierList.getFirstChild() != null) {
                return null;
            }
            if (this.shouldShowSeparatorFor(parent)) {
                return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)element, (EditorColorsManager)EditorColorsManager.getInstance());
            }
        }
        if (parent instanceof PhpModifierList && parent.getFirstChild() == element && this.shouldShowSeparatorFor(parent.getParent())) {
            return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)element, (EditorColorsManager)EditorColorsManager.getInstance());
        }
        if (PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_COMMENT_START) && parent instanceof PhpDocComment && this.shouldShowSeparatorFor(((PhpDocComment)parent).getOwner())) {
            return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)element, (EditorColorsManager)EditorColorsManager.getInstance());
        }
        return null;
    }

    public boolean shouldShowSeparatorFor(PsiElement owner) {
        if (owner instanceof Function) {
            return DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS && !StringUtil.isEmpty((String)((Function)owner).getName()) && !(owner instanceof PhpDocMethod);
        }
        return PhpEditorOptions.getInstance().SHOW_CLASS_SEPARATORS && (owner instanceof PhpClass && !((PhpClass)owner).isAnonymous() || owner instanceof PhpNamespace);
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            PhpLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            PhpLineMarkerProvider.$$$reportNull$$$0(3);
        }
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof PhpNamedElement)) continue;
            PhpLineMarkerProvider.findChildren((PhpNamedElement)psiElement, result);
            PhpLineMarkerProvider.findParents((PhpNamedElement)psiElement, result);
        }
    }

    private static Collection<? extends PhpNamedElement> getSubClasses(SmartPsiElementPointer<PhpClass> aClass) {
        PhpClass clazz = (PhpClass)aClass.getElement();
        if (clazz == null) {
            return Collections.emptyList();
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)clazz.getProject());
        return clazz.isTrait() ? phpIndex.getTraitUsages(clazz) : phpIndex.getAllSubclasses(clazz.getFQN());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    static class PhpClassOverridenTooltipGenerator
    extends OverridenTooltipGenerator {
        private final SmartPsiElementPointer<PhpClass> myClass;

        PhpClassOverridenTooltipGenerator(PhpClass phpClass, PsiElement element, Project project) {
            super(element, project);
            this.myClass = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)phpClass);
        }

        @Override
        protected Collection<? extends PhpNamedElement> getElements() {
            return PhpLineMarkerProvider.getSubClasses(this.myClass);
        }
    }

    public static class PhpClassGutterIconNavigationHandler
    extends PhpGutterIconNavigationHandler {
        private final SmartPsiElementPointer<PhpClass> myClass;

        public PhpClassGutterIconNavigationHandler(PhpClass phpClass) {
            super(PhpLineMarkerProvider.getChildTitle((PhpNamedElement)phpClass), PhpLineMarkerProvider.getPinTitle((PhpNamedElement)phpClass));
            this.myClass = SmartPointerManager.getInstance((Project)phpClass.getProject()).createSmartPsiElementPointer((PsiElement)phpClass);
        }

        @Override
        protected Collection<? extends PhpNamedElement> getElements() {
            return PhpLineMarkerProvider.getSubClasses(this.myClass);
        }
    }

    private static class MyHierarchyMemberProcessor
    implements PhpClassHierarchyUtils.HierarchyClassMemberProcessor {
        private Icon icon;
        private final ArrayList<PhpClassMember> myMembers = new ArrayList();
        private final boolean up;

        MyHierarchyMemberProcessor(boolean up) {
            this.up = up;
        }

        public boolean process(PhpClassMember member, PhpClass subClass, PhpClass baseClass) {
            if (member instanceof Field) {
                boolean isConstant = ((Field)member).isConstant();
                Field superField = baseClass.findOwnFieldByName((CharSequence)member.getName(), isConstant);
                if (superField != null && MyHierarchyMemberProcessor.isAnyPrivate(member, (PhpClassMember)superField)) {
                    return false;
                }
                if (subClass.isInterface() || baseClass.isInterface()) {
                    return false;
                }
                this.icon = this.up ? PhpIcons.OVERRIDES : PhpIcons.OVERRIDEN;
                this.myMembers.add(member);
                return true;
            }
            if (member instanceof Method) {
                boolean b;
                Method superMethod = baseClass.findOwnMethodByName((CharSequence)member.getName());
                if (superMethod != null && MyHierarchyMemberProcessor.isAnyPrivate(member, (PhpClassMember)superMethod)) {
                    return false;
                }
                boolean bl = b = baseClass.isInterface() == subClass.isInterface();
                this.icon = this.up ? (b ? PhpIcons.OVERRIDES : PhpIcons.IMPLEMENTS) : (b ? PhpIcons.OVERRIDEN : PhpIcons.IMPLEMENTED);
                this.myMembers.add(member);
                return true;
            }
            return false;
        }

        private static boolean isAnyPrivate(PhpClassMember member, PhpClassMember superMember) {
            PhpModifier.Access superAccess = superMember.getModifier().getAccess();
            PhpModifier.Access childAccess = member.getModifier().getAccess();
            return childAccess.isPrivate() || superAccess.isPrivate();
        }
    }

    static class PhpMemberOverridenTooltipGenerator
    extends OverridenTooltipGenerator {
        private final SmartPsiElementPointer<PhpClassMember> myMember;
        private final java.util.function.Function<PhpClassMember, Collection<? extends PhpNamedElement>> myElementsSupplier;

        PhpMemberOverridenTooltipGenerator(PhpClassMember member, java.util.function.Function<PhpClassMember, Collection<? extends PhpNamedElement>> elementsSupplier) {
            super((PsiElement)member, member.getProject());
            this.myMember = SmartPointerManager.getInstance((Project)member.getProject()).createSmartPsiElementPointer((PsiElement)member);
            this.myElementsSupplier = elementsSupplier;
        }

        @Override
        protected Collection<? extends PhpNamedElement> getElements() {
            PhpClassMember element = (PhpClassMember)this.myMember.getElement();
            return element != null ? this.myElementsSupplier.apply(element) : Collections.emptyList();
        }
    }

    public static class PhpMemberGutterIconNavigationHandler
    extends PhpGutterIconNavigationHandler {
        private final SmartPsiElementPointer<PhpClassMember> myMember;
        private final java.util.function.Function<PhpClassMember, Collection<? extends PhpNamedElement>> myElementsSupplier;

        public PhpMemberGutterIconNavigationHandler(PhpClassMember member, java.util.function.Function<PhpClassMember, Collection<? extends PhpNamedElement>> elementsSupplier) {
            super(PhpLineMarkerProvider.getChildTitle((PhpNamedElement)member), PhpLineMarkerProvider.getPinTitle((PhpNamedElement)member));
            this.myMember = SmartPointerManager.getInstance((Project)member.getProject()).createSmartPsiElementPointer((PsiElement)member);
            this.myElementsSupplier = elementsSupplier;
        }

        @Override
        protected Collection<? extends PhpNamedElement> getElements() {
            PhpClassMember element = (PhpClassMember)this.myMember.getElement();
            return element != null ? this.myElementsSupplier.apply(element) : Collections.emptyList();
        }
    }

    private static final class OverridesTooltipGenerator
    implements com.intellij.util.Function<PsiElement, String> {
        private final Collection<? extends SmartPsiElementPointer<? extends PhpNamedElement>> myElements;

        private OverridesTooltipGenerator(Collection<? extends PhpNamedElement> elements, Project project) {
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            this.myElements = ContainerUtil.map(elements, arg_0 -> ((SmartPointerManager)manager).createSmartPsiElementPointer(arg_0));
        }

        public String fun(PsiElement identifier) {
            StringBuilder buffer = new StringBuilder();
            for (SmartPsiElementPointer<? extends PhpNamedElement> smartPsiElementPointer : this.myElements) {
                PhpNamedElement element = (PhpNamedElement)smartPsiElementPointer.getElement();
                if (element == null) continue;
                buffer.append(((PhpElementWithModifier)element).getModifier().isAbstract() ? "Implements" : "Overrides");
                PsiElement parent = identifier.getParent();
                if (parent instanceof Method) {
                    buffer.append(PhpLineMarkerProvider.SPACE).append("method").append(PhpLineMarkerProvider.SPACE).append("in").append(PhpLineMarkerProvider.SPACE);
                } else {
                    buffer.append(PhpLineMarkerProvider.SPACE).append("field").append(PhpLineMarkerProvider.SPACE).append("in").append(PhpLineMarkerProvider.SPACE);
                }
                PhpClass container = PhpPsiUtil.getParentOfClass((PsiElement)element, false, PhpClass.class);
                buffer.append(container != null && container.isInterface() ? "interface" : "class").append(PhpLineMarkerProvider.SPACE);
                if (container != null) {
                    buffer.append("'").append(container.getName()).append("'");
                } else {
                    buffer.append("unknown place");
                }
                buffer.append(PhpLineMarkerProvider.BREAK);
            }
            return buffer.toString();
        }
    }

    private static class PhpParentGutterIconNavigationHandler
    extends PhpGutterIconNavigationHandler {
        private final List<? extends SmartPsiElementPointer<? extends PhpNamedElement>> myList;

        private PhpParentGutterIconNavigationHandler(Collection<? extends PhpNamedElement> list, @Nls String title, @Nls String pinTitle, Project project) {
            super(title, pinTitle);
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            this.myList = ContainerUtil.map(list, arg_0 -> ((SmartPointerManager)manager).createSmartPsiElementPointer(arg_0));
        }

        @Override
        protected Collection<? extends PhpNamedElement> getElements() {
            return (Collection)StreamEx.of(this.myList).map(SmartPsiElementPointer::getElement).nonNull().collect(Collectors.toList());
        }
    }

    public static abstract class PhpGutterIconNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        @Nls
        private final String myTitle;
        @Nls
        private final String myPinTitle;

        PhpGutterIconNavigationHandler(@Nls String title, @Nls String pinTitle) {
            this.myTitle = title;
            this.myPinTitle = pinTitle;
        }

        public void navigate(MouseEvent e, PsiElement __) {
            NavigatablePsiElement[] na = this.getElements().toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY);
            PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer renderer = new PhpGotoTargetRendererProvider.PhpNamedElementPsiElementListCellRenderer(false);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])na, (String)this.myTitle, (String)this.myPinTitle, (ListCellRenderer)((Object)renderer));
        }

        protected abstract Collection<? extends PhpNamedElement> getElements();
    }

    static abstract class OverridenTooltipGenerator
    implements com.intellij.util.Function<PsiElement, String> {
        private final SmartPsiElementPointer<PsiElement> myElement;

        OverridenTooltipGenerator(PsiElement element, Project project) {
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            this.myElement = manager.createSmartPsiElementPointer(element);
        }

        public String fun(PsiElement __) {
            StringBuilder buffer = new StringBuilder();
            PsiElement element = this.myElement.getElement();
            Collection<? extends PhpNamedElement> myElements = this.getElements();
            if (myElements.size() < 6) {
                PhpClass superclass;
                buffer.append("Is").append(PhpLineMarkerProvider.SPACE);
                TreeSet<PhpNamedElement> elements = new TreeSet<PhpNamedElement>(PHP_NAMED_ELEMENT_COMPARATOR);
                elements.addAll(myElements);
                if (element instanceof PhpClass) {
                    PhpClass superclass2 = (PhpClass)element;
                    for (PhpNamedElement subclass : elements) {
                        buffer.append(PhpLineMarkerProvider.BREAK).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE);
                        if (superclass2.isAbstract() && !((PhpClass)subclass).isAbstract()) {
                            buffer.append("implemented").append(PhpLineMarkerProvider.SPACE).append("by");
                        } else if (!superclass2.isTrait()) {
                            buffer.append("extended").append(PhpLineMarkerProvider.SPACE).append("by");
                        } else {
                            buffer.append("used").append(PhpLineMarkerProvider.SPACE).append("by");
                        }
                        buffer.append(PhpLineMarkerProvider.SPACE).append("'").append(subclass.getName()).append("'");
                    }
                } else if (element instanceof PhpClassMember && (superclass = ((PhpClassMember)element).getContainingClass()) != null) {
                    for (PhpNamedElement namedElement : elements) {
                        PhpClass subclass = ((PhpClassMember)namedElement).getContainingClass();
                        if (subclass == null) continue;
                        buffer.append(PhpLineMarkerProvider.BREAK).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE).append(PhpLineMarkerProvider.SPACE);
                        if (superclass.isAbstract()) {
                            buffer.append("implemented").append(PhpLineMarkerProvider.SPACE).append("in").append(PhpLineMarkerProvider.SPACE).append("class");
                        } else {
                            buffer.append("overridden").append(PhpLineMarkerProvider.SPACE).append("in").append(PhpLineMarkerProvider.SPACE).append(subclass.isAbstract() ? "interface" : "class");
                        }
                        buffer.append(PhpLineMarkerProvider.SPACE).append("'").append(subclass.getName()).append("'");
                    }
                }
            } else if (element instanceof PhpClass) {
                buffer.append("Has").append(PhpLineMarkerProvider.SPACE);
                if (((PhpClass)element).isInterface()) {
                    buffer.append("implementations");
                } else {
                    buffer.append("subclasses");
                }
            } else if (element instanceof Method || element instanceof Field) {
                buffer.append("Has").append(PhpLineMarkerProvider.SPACE);
                if (element instanceof Method && ((Method)element).isAbstract()) {
                    buffer.append("implementations");
                } else {
                    buffer.append("overrides");
                }
            }
            return buffer.toString();
        }

        protected abstract Collection<? extends PhpNamedElement> getElements();
    }
}

