/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpGlobalVariableTP;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpUnitDataProviderAttributeReferenceContributor
extends PsiReferenceContributor {
    public static final String PHPUNIT_ATTRIBUTES = "\\PHPUnit\\Framework\\Attributes\\";
    private static final PatternCondition<PhpAttribute> DATA_PROVIDER_EXTERNAL_ATTRIBUTE = new PatternCondition<PhpAttribute>("phpUnitDataProviderExternal"){

        public boolean accepts(@NotNull PhpAttribute attribute, ProcessingContext context) {
            String fqn;
            if (attribute == null) {
                1.$$$reportNull$$$0(0);
            }
            return (fqn = attribute.getFQN()) != null && fqn.startsWith(PhpUnitDataProviderAttributeReferenceContributor.PHPUNIT_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/jetbrains/php/lang/PhpUnitDataProviderAttributeReferenceContributor$1", "accepts"));
        }
    };
    private static final String EXCLUDE_GLOBAL_VARIABLE_FROM_BACKUP_FQN = "\\PHPUnit\\Framework\\Attributes\\ExcludeGlobalVariableFromBackup";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            PhpUnitDataProviderAttributeReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(StringLiteralExpression.class).withSuperParent(2, (ElementPattern)PlatformPatterns.psiElement(PhpAttribute.class).with(DATA_PROVIDER_EXTERNAL_ATTRIBUTE)), (PsiReferenceProvider)new PhpDataProviderReferenceProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/php/lang/PhpUnitDataProviderAttributeReferenceContributor", "registerReferenceProviders"));
    }

    public static class PhpDataProviderReferenceProvider
    extends PsiReferenceProvider {
        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiElement psiElement;
            if (element == null) {
                PhpDataProviderReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDataProviderReferenceProvider.$$$reportNull$$$0(1);
            }
            if ((psiElement = element.getParent()) instanceof ParameterList) {
                PhpAttribute attribute;
                ParameterList parameterList = (ParameterList)psiElement;
                PsiElement psiElement2 = parameterList.getParent();
                if (psiElement2 instanceof PhpAttribute && PhpLangUtil.equalsClassNames((attribute = (PhpAttribute)psiElement2).getFQN(), PhpUnitDataProviderAttributeReferenceContributor.EXCLUDE_GLOBAL_VARIABLE_FROM_BACKUP_FQN)) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new PhpGlobalVariableCallbackReference(element)};
                    if (psiReferenceArray == null) {
                        PhpDataProviderReferenceProvider.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
                Collection<Parameter> parameters = PhpWorkaroundUtil.multiResolveMappedParameters(element);
                if (PhpDataProviderReferenceProvider.isParameterWithNameExists(parameters, "functionName")) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{PhpCallbackReferenceBase.createFunctionReference(element)};
                    if (psiReferenceArray == null) {
                        PhpDataProviderReferenceProvider.$$$reportNull$$$0(3);
                    }
                    return psiReferenceArray;
                }
                if (PhpDataProviderReferenceProvider.isParameterWithNameExists(parameters, "className")) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{PhpCallbackReferenceBase.createClassReference(element, false)};
                    if (psiReferenceArray == null) {
                        PhpDataProviderReferenceProvider.$$$reportNull$$$0(4);
                    }
                    return psiReferenceArray;
                }
                boolean isMethod = PhpDataProviderReferenceProvider.isParameterWithNameExists(parameters, "methodName");
                if (isMethod || PhpDataProviderReferenceProvider.isParameterWithNameExists(parameters, "propertyName")) {
                    PsiElement classRefArgument = (PsiElement)ContainerUtil.find((Object[])parameterList.getParameters(), arg -> PhpDataProviderReferenceProvider.isParameterWithNameExists(PhpWorkaroundUtil.multiResolveMappedParameters(arg), "className"));
                    if (classRefArgument != null) {
                        PsiReference[] psiReferenceArray = new PsiReference[]{PhpCallbackReferenceBase.createMemberReference(classRefArgument, element, isMethod)};
                        if (psiReferenceArray == null) {
                            PhpDataProviderReferenceProvider.$$$reportNull$$$0(5);
                        }
                        return psiReferenceArray;
                    }
                    PhpClass aClass = PhpClassImpl.getContainingClass(element);
                    if (aClass != null) {
                        PsiReference[] psiReferenceArray = new PsiReference[]{new PhpUnitAttributeClassReference(element, aClass)};
                        if (psiReferenceArray == null) {
                            PhpDataProviderReferenceProvider.$$$reportNull$$$0(6);
                        }
                        return psiReferenceArray;
                    }
                }
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                PhpDataProviderReferenceProvider.$$$reportNull$$$0(7);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static boolean isParameterWithNameExists(Collection<Parameter> parameters, String name) {
            return ContainerUtil.exists(parameters, p -> PhpLangUtil.equalsParameterNames(p.getName(), name));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpUnitDataProviderAttributeReferenceContributor$PhpDataProviderReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpUnitDataProviderAttributeReferenceContributor$PhpDataProviderReferenceProvider";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }

        public static class PhpGlobalVariableCallbackReference
        extends PhpCallbackReferenceBase.PhpVariableCallbackReference {
            private PhpGlobalVariableCallbackReference(@NotNull PsiElement element) {
                if (element == null) {
                    PhpGlobalVariableCallbackReference.$$$reportNull$$$0(0);
                }
                super(element);
            }

            @Override
            protected Collection<? extends PhpNamedElement> collectVariables(String name) {
                return PhpGlobalVariableTP.resolveGlobalVariables(this.myElement.getProject(), name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/PhpUnitDataProviderAttributeReferenceContributor$PhpDataProviderReferenceProvider$PhpGlobalVariableCallbackReference", "<init>"));
            }
        }

        public static class PhpUnitAttributeClassReference
        extends PhpCallbackReferenceBase.PhpClassMemberCallbackReferenceBase {
            private final PhpClass myClass;

            public PhpUnitAttributeClassReference(@NotNull PsiElement element, PhpClass aClass) {
                if (element == null) {
                    PhpUnitAttributeClassReference.$$$reportNull$$$0(0);
                }
                super(element, true);
                this.myClass = aClass;
            }

            @Override
            @NotNull
            public Collection<PhpClass> resolveClassReference() {
                Set<PhpClass> set = Collections.singleton(this.myClass);
                if (set == null) {
                    PhpUnitAttributeClassReference.$$$reportNull$$$0(1);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/PhpUnitDataProviderAttributeReferenceContributor$PhpDataProviderReferenceProvider$PhpUnitAttributeClassReference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/PhpUnitDataProviderAttributeReferenceContributor$PhpDataProviderReferenceProvider$PhpUnitAttributeClassReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "resolveClassReference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }
}

