/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.codeInspection.actions.InspectionElement;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpDocRefReferenceContributor;
import com.jetbrains.php.lang.documentation.PhpClassAliasDocSource;
import com.jetbrains.php.lang.documentation.PhpClassDocSource;
import com.jetbrains.php.lang.documentation.PhpClassMemberDocSource;
import com.jetbrains.php.lang.documentation.PhpClassRefDocSource;
import com.jetbrains.php.lang.documentation.PhpDefaultDocSource;
import com.jetbrains.php.lang.documentation.PhpDocLinkResolver;
import com.jetbrains.php.lang.documentation.PhpDocMethodSource;
import com.jetbrains.php.lang.documentation.PhpDocSection;
import com.jetbrains.php.lang.documentation.PhpDocSource;
import com.jetbrains.php.lang.documentation.PhpFileDocSource;
import com.jetbrains.php.lang.documentation.PhpFunctionDocSource;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.PhpNamespaceDocSource;
import com.jetbrains.php.lang.documentation.PhpParameterDocSource;
import com.jetbrains.php.lang.documentation.PhpPropertyDocSource;
import com.jetbrains.php.lang.documentation.PhpVarDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLinkTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocumentationProvider
implements DocumentationProvider {
    public static final List<String> TEMPLATE_TAGS = List.of(PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplateNames());
    public static final List<String> PROPERTY_TAGS = List.of(PhpGenericsTemplatesCustomDocTagValueStubProvider.getTagNamesWithSuffixes("property", "property-read", "property-write"));
    public static final List<String> THROWS_TAGS = List.of(PhpGenericsTemplatesCustomDocTagValueStubProvider.getTagNamesWithSuffixes("throws"));
    public static final List<String> RETURN_TAGS = List.of(PhpGenericsTemplatesCustomDocTagValueStubProvider.getTagNamesWithSuffixes("return"));
    public static final List<String> PARAM_TAGS = List.of(PhpGenericsTemplatesCustomDocTagValueStubProvider.getTagNamesWithSuffixes("param", "var", "global"));
    public static final List<String> KNOWN_TAGS = List.of("@deprecated", "@internal", "@since", "@see", "@link", "@author", "@version", "@package", "@since", "@uses", "@inheritdoc", "@inheritDoc", "@code", "@xglobal", "@dataProvider", "@covers", "@coversDefaultClass", "@depends", "method", "phpstan-method", "psalm-method", "@final");
    private static final Logger LOG = Logger.getInstance(PhpDocumentationProvider.class);

    @Nullable
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        PhpDocSource source = PhpDocumentationProvider.getDocSourceFor(element, originalElement);
        if (source == null) {
            return null;
        }
        HtmlBuilder infoBuf = new HtmlBuilder();
        infoBuf.appendRaw(PhpDocumentationProvider.preparePlainText(source.getTitle()));
        String returnType = source.getReturnType();
        if (StringUtil.isNotEmpty((String)returnType)) {
            infoBuf.append(" : ").appendRaw(returnType);
        }
        return infoBuf.toString();
    }

    @NlsSafe
    private static String preparePlainText(@NlsSafe String text) {
        String result = text.replace("<code>", "").replace("</code>", "").replaceAll("<br>", "");
        return result;
    }

    @Nls
    @Nullable
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        if (comment == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(0);
        }
        PhpPsiElement directCommentOwner = (PhpPsiElement)ObjectUtils.tryCast((Object)comment.getOwner(), PhpPsiElement.class);
        PsiElement validOwner = PhpDocumentationProvider.getValidOwnerForDocRendering(comment);
        if (directCommentOwner == null && validOwner == null) {
            return null;
        }
        if (validOwner != null) {
            return PhpDocumentationProvider.getText(validOwner, validOwner, true);
        }
        PhpDefaultDocSource source = new PhpDefaultDocSource(directCommentOwner, true, (PhpDocComment)comment);
        return PhpDocumentationProvider.getText(source, (PsiElement)directCommentOwner, (PsiElement)directCommentOwner, true);
    }

    public void collectDocComments(@NotNull PsiFile file, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (file == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PhpFile)) {
            return;
        }
        ContainerUtil.filter((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)file, PhpDocComment.class), PhpDocumentationProvider::isValidComment).forEach(sink);
    }

    private static boolean isValidComment(PhpDocComment comment) {
        return comment.getOwner() != null || PhpDocumentationProvider.getValidOwnerForDocRendering((PsiDocCommentBase)comment) != null;
    }

    @Nullable
    private static PsiElement getValidOwnerForDocRendering(PsiDocCommentBase comment) {
        if (!(comment instanceof PhpDocComment)) {
            return null;
        }
        PsiElement owner = comment.getOwner();
        if (owner == null) {
            return null;
        }
        PhpDocSource source = PhpDocumentationProvider.getDocSourceFor(owner, owner);
        if (source != null && source.getDocComment() != null) {
            return owner;
        }
        PhpNamedElement element = (PhpNamedElement)PsiTreeUtil.findChildOfType((PsiElement)owner, PhpNamedElement.class);
        if (element == null || !comment.equals((Object)element.getDocComment())) {
            return null;
        }
        return element;
    }

    @NlsSafe
    private static String getText(@NotNull PsiElement element, @NotNull PsiElement originalElement, boolean isGenerationForRenderedDoc) {
        PhpDocSource source;
        if (element == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (originalElement == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(4);
        }
        PhpDocSource phpDocSource = source = isGenerationForRenderedDoc ? PhpDocumentationProvider.getDocSource(element, originalElement, true) : PhpDocumentationProvider.getDocSourceFor(element, originalElement);
        if (source == null) {
            return null;
        }
        return PhpDocumentationProvider.getText(source, element, originalElement, isGenerationForRenderedDoc);
    }

    private static boolean doNotGenerateQuickDoc(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (originalElement == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (element instanceof PhpNamedElement || originalElement instanceof PhpNamedElement) {
            return false;
        }
        PhpReference ref = (PhpReference)PhpPsiUtil.getParentByCondition(originalElement, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (ref instanceof Variable) {
            return false;
        }
        if (ref != null && PhpType.isPrimitiveType((String)ref.getName())) {
            return true;
        }
        return element instanceof ArrayCreationExpression || element instanceof MultiassignmentExpression || element instanceof ArrayIndex;
    }

    @Nullable
    @NlsSafe
    private static String getText(PhpDocSource source, @NotNull PsiElement element, @NotNull PsiElement originalElement, boolean isGenerationForRenderedDoc) {
        if (element == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (originalElement == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (PhpDocumentationProvider.doNotGenerateQuickDoc(element, originalElement) && !isGenerationForRenderedDoc) {
            return null;
        }
        if (DumbService.isDumb((Project)element.getProject())) {
            throw IndexNotReadyException.create();
        }
        StringBuilder buffer = new StringBuilder();
        PhpReference ref = (PhpReference)PhpPsiUtil.getParentByCondition(originalElement, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        try {
            String sourceLoc;
            String packageName;
            Object content;
            String var;
            String description;
            if (!isGenerationForRenderedDoc) {
                String globalReturnType;
                HtmlChunk.Element containerInfo = source.getContainerInfo();
                if (containerInfo != null) {
                    buffer.append(containerInfo);
                }
                buffer.append("<div class='definition'><pre>").append(source.getTitle());
                String returnType = source.getReturnType();
                if (StringUtil.isNotEmpty((String)returnType)) {
                    buffer.append(": ").append(returnType);
                } else if (ref != null && StringUtil.isNotEmpty((String)(globalReturnType = ref.getGlobalType().toString()))) {
                    buffer.append(": <i>").append(globalReturnType).append("</i>");
                }
                buffer.append("</pre></div>");
            }
            if (StringUtil.isNotEmpty((String)(description = source.getDescription()))) {
                buffer.append("<div class='content'>").append(description).append("</div>");
            }
            if (isGenerationForRenderedDoc && (var = source.getVar()) != null) {
                buffer.append(var);
            }
            buffer.append("<table class='sections'>");
            if (ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode() && !isGenerationForRenderedDoc) {
                PhpDocumentationProvider.addSection(buffer, "Signature:", PhpDocumentationProvider.getSignature(ref, element));
            }
            if (source.isDeprecated()) {
                content = source.getDeprecationInfo();
                if (StringUtil.isEmpty((String)content)) {
                    PhpDocumentationProvider.addSection(buffer, "<u><b>Deprecated</b></u>");
                } else {
                    PhpDocumentationProvider.addSection(buffer, "<u><b>Deprecated</b></u>:", (String)content);
                }
            }
            if (source.isInternal()) {
                content = source.getInternalInfo();
                if (StringUtil.isEmpty((String)content)) {
                    PhpDocumentationProvider.addSection(buffer, "<u><b>Internal</b></u>");
                } else {
                    PhpDocumentationProvider.addSection(buffer, "<u><b>Internal</b></u>:", (String)content);
                }
            }
            if (!isGenerationForRenderedDoc) {
                for (PhpDocSection section : source.getCustomSections()) {
                    PhpDocumentationProvider.addSection(buffer, section.getName() + ":", section.getContent());
                }
            }
            PhpDocumentationProvider.addSection(buffer, "Templates:", source.getGenerics());
            PhpDocumentationProvider.addSection(buffer, "Parameters:", source.getParameters());
            PhpDocumentationProvider.addSection(buffer, "Returns:", source.getReturn());
            PhpDocumentationProvider.addSection(buffer, "Throws:", source.getThrows());
            if (isGenerationForRenderedDoc) {
                PhpDocumentationProvider.addSection(buffer, "Properties:", source.getProperties());
                PhpDocumentationProvider.addSection(buffer, "Methods:", source.getMethods());
                PhpDocumentationProvider.addSection(buffer, "Data providers:", source.getDataProvider());
                PhpDocumentationProvider.addSection(buffer, "Covers:", source.getCovers());
                PhpDocumentationProvider.addSection(buffer, "Covers default class:", source.getCoversDefaultClass());
                PhpDocumentationProvider.addSection(buffer, "Depends:", source.getDepends());
            }
            if ((packageName = source.getPackage()) != null) {
                String subpackage = source.getSubpackage();
                PhpDocumentationProvider.addSection(buffer, "Package:", source.getPackage() + (String)(subpackage == null ? "" : "/" + subpackage));
            }
            PhpDocumentationProvider.addSection(buffer, "Version:", source.getVersion());
            PhpDocumentationProvider.addSection(buffer, "Uses:", source.getUses());
            PhpDocumentationProvider.addSection(buffer, "Since:", source.getSince());
            PhpDocumentationProvider.addSection(buffer, "Links:", source.getLinks());
            PhpDocumentationProvider.addSection(buffer, "See also:", source.getSeeItems());
            if (isGenerationForRenderedDoc) {
                PhpDocumentationProvider.addSection(buffer, "Author:", source.getAuthor());
                PhpDocumentationProvider.addUnknownTagSection(buffer, source.getDocComment());
            }
            PhpDocumentationProvider.appendFinalTagInfo(buffer, source.getDocComment());
            if (element instanceof NavigationItem && !isGenerationForRenderedDoc && (sourceLoc = PhpDocumentationProvider.getSource(element)) != null && !".../".equals(sourceLoc)) {
                PhpDocumentationProvider.addSection(buffer, "Source:", "<span path=\"\">" + sourceLoc + "</span>");
            }
            buffer.append("</table>");
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(element.getText(), e);
        }
        return buffer.isEmpty() ? null : buffer.toString();
    }

    @Nullable
    @Nls
    public String generateDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (!(element instanceof PhpPsiElement) || !element.isValid()) {
            return null;
        }
        return PhpDocumentationProvider.getText(element, originalElement == null ? element : originalElement, false);
    }

    public static String getSignature(PhpReference ref, PsiElement element) {
        @NlsSafe String signature = ref != null ? ref.getSignature() : (element instanceof PhpTypedElement ? ((PhpTypedElement)element).getType().toString() : "?");
        return QuickDocHighlightingHelper.wrapWithInlineCodeTag((String)signature);
    }

    public List<String> getUrlFor(PsiElement element, @Nullable PsiElement originalElement) {
        ArrayList<String> urls = new ArrayList<String>();
        PhpDocumentationProvider.addDocUrls(element, urls);
        if (urls.isEmpty()) {
            String name;
            String string = element instanceof PhpNamedElement ? ((PhpNamedElement)element).getName() : (name = element instanceof PhpReference ? ((PhpReference)element).getName() : null);
            if (name != null && PhpDocumentationProvider.isStdLibElement(element)) {
                urls.add("https://www.php.net/manual-lookup.php?pattern=" + name + "&amp;lang=en");
            }
        }
        return urls;
    }

    private static boolean isStdLibElement(PsiElement element) {
        if (element instanceof PhpReference) {
            PhpReference reference = (PhpReference)element;
            for (PhpNamedElement namedElement : reference.multiResolveStrict(PhpNamedElement.class)) {
                if (!PhpDocumentationProvider.isStdLibElement(namedElement)) continue;
                return true;
            }
            return false;
        }
        return PhpDocumentationProvider.isStdLibElement((PhpNamedElement)ObjectUtils.tryCast((Object)element, PhpNamedElement.class));
    }

    private static boolean isStdLibElement(PhpNamedElement element) {
        if (element == null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return PhpRuntimeLibraryRootsProvider.isInStubRoots(element.getProject(), virtualFile);
    }

    public static void addDocUrls(PsiElement element, ArrayList<? super String> urls) {
        PhpDocLinkTag[] tags;
        PhpDocComment comment = (PhpDocComment)ObjectUtils.doIfCast((Object)element, PhpNamedElement.class, PhpNamedElement::getDocComment);
        if (comment != null && (tags = comment.getLinkTags()) != null) {
            for (PhpDocLinkTag linkTag : tags) {
                String url = linkTag.getURL();
                if (url == null) continue;
                urls.add(url);
            }
        }
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        PsiFile psiFile;
        InspectionElement element = PhpDocUtil.tryResolveSuppressedInspection(link, context);
        if (element != null) {
            return element;
        }
        VirtualFile virtualFile = VfsUtilCore.findRelativeFile((String)link, (VirtualFile)context.getContainingFile().getVirtualFile());
        if (virtualFile != null && (psiFile = psiManager.findFile(virtualFile)) != null) {
            return psiFile;
        }
        Collection<PhpDocLinkResolver.Result> result = PhpDocLinkResolver.resolve(link, context);
        PhpNamespace namespace = ((StreamEx)StreamEx.of(result).map(PhpDocLinkResolver.Result::getElement).select(PhpNamespace.class).filter(e -> e.getContainingFile() == context.getContainingFile())).findFirst().orElse(null);
        return namespace != null ? namespace : (PsiElement)StreamEx.of(result).map(PhpDocLinkResolver.Result::getElement).findFirst().orElse(null);
    }

    @Nullable
    public static String getSource(PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!PhpDocumentationProvider.isStdLibElement(element)) {
            return PhpPresentationUtil.getPresentablePathForFile(virtualFile, element.getProject());
        }
        String path = virtualFile.getCanonicalPath();
        VirtualFile extension = virtualFile.getParent();
        if (extension == null) {
            return null;
        }
        VirtualFile root = extension.getParent();
        if (root == null) {
            return null;
        }
        String rootPath = root.getCanonicalPath();
        if (rootPath == null || path == null) {
            return null;
        }
        return StringUtil.replace((String)path, (String)rootPath, (String)QuickDocHighlightingHelper.wrapWithInlineCodeTag((String)"<b>&lt;stubs&gt;</b>"));
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (file == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (contextElement == null) {
            return null;
        }
        PhpReference ref = (PhpReference)PhpPsiUtil.getParentByCondition(contextElement, false, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpReference), (Condition<? super PsiElement>)Statement.INSTANCEOF);
        if (ref != null) {
            PsiElement parameter;
            PsiElement resolve2 = ref.resolve();
            if (ref instanceof Variable && resolve2 == null) {
                return ref;
            }
            if (ref instanceof FunctionReference && ref.getParent() instanceof PhpDefine && (parameter = ((FunctionReference)ref).getParameter(0)) != null && parameter.getTextRange().contains(targetOffset)) {
                return null;
            }
            if (resolve2 != null) {
                return resolve2;
            }
        }
        return PhpDocUtil.tryResolveSuppressedInspection(contextElement.getText(), contextElement);
    }

    @Nullable
    public static PhpDocSource getDocSourceFor(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(12);
        }
        if (originalElement == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(13);
        }
        return PhpDocumentationProvider.getDocSource(element, originalElement, false);
    }

    @Nullable
    private static PhpDocSource getDocSource(@NotNull PsiElement element, @NotNull PsiElement originalElement, boolean isGenerationForRenderedDoc) {
        if (element == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (originalElement == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (element instanceof PhpFile) {
            return new PhpFileDocSource((PhpFile)element, isGenerationForRenderedDoc);
        }
        if (element instanceof PhpUseList || element instanceof Declare) {
            return new PhpFileDocSource((PhpFile)element.getContainingFile(), isGenerationForRenderedDoc);
        }
        if (element instanceof PhpNamespace) {
            return new PhpNamespaceDocSource((PhpNamespace)element, isGenerationForRenderedDoc);
        }
        if (element instanceof Parameter) {
            return new PhpParameterDocSource((Parameter)element, isGenerationForRenderedDoc);
        }
        if (element instanceof PhpDocProperty) {
            return new PhpPropertyDocSource((PhpDocProperty)element, isGenerationForRenderedDoc);
        }
        if (element instanceof PhpDocMethod) {
            return new PhpDocMethodSource((PhpDocMethod)element, isGenerationForRenderedDoc);
        }
        if (element instanceof PhpClassMember) {
            return new PhpClassMemberDocSource((PhpClassMember)element, isGenerationForRenderedDoc);
        }
        if (element instanceof Function) {
            return new PhpFunctionDocSource((Function)element, isGenerationForRenderedDoc);
        }
        if (element instanceof PhpClassAlias) {
            return new PhpClassAliasDocSource((PhpClassAlias)element, isGenerationForRenderedDoc);
        }
        if (element instanceof PhpClass) {
            return new PhpClassDocSource((PhpClass)element, isGenerationForRenderedDoc);
        }
        if (element instanceof ClassReference) {
            return new PhpClassRefDocSource((ClassReference)element, isGenerationForRenderedDoc);
        }
        if (element instanceof PhpNamedElement) {
            Variable var = PhpVarDocSource.getVariable(originalElement);
            if (var != null) {
                return new PhpVarDocSource((PhpNamedElement)element, var, isGenerationForRenderedDoc);
            }
            return new PhpNamedElementDocSource((PhpNamedElement)element, isGenerationForRenderedDoc);
        }
        if (element instanceof PhpPsiElement) {
            return new PhpDefaultDocSource((PhpPsiElement)element, isGenerationForRenderedDoc);
        }
        return null;
    }

    private static void addSection(@NotNull StringBuilder buffer, @NotNull String name, @Nullable String content) {
        if (buffer == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (name == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(17);
        }
        if (StringUtil.isNotEmpty((String)content)) {
            buffer.append("<tr><td valign='top' class='section'><p>");
            buffer.append(name);
            buffer.append("</td><td valign='top'>");
            buffer.append(content);
            buffer.append("</td>");
        }
    }

    private static void addSection(@NotNull StringBuilder buffer, @NotNull String name) {
        if (buffer == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (name == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(19);
        }
        buffer.append("<tr><td valign='top' class='section'><p>");
        buffer.append(name);
        buffer.append("</td><td valign='top'>");
        buffer.append("</td>");
    }

    private static void appendTagInfo(StringBuilder buffer, @NotNull PhpDocTag tag) {
        if (tag == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(20);
        }
        StringBuilder builder2 = new StringBuilder();
        PsiElement element = tag.getFirstChild().getNextSibling();
        while (!tag.getLastChild().equals((Object)element)) {
            if (element instanceof PhpDocType) {
                PhpNamedElementDocSource.appendTypeFromDocTag(builder2, tag, true);
            } else if (element instanceof PhpDocVariable) {
                PhpDocVariable var = (PhpDocVariable)element;
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)builder2, (String)("$" + var.getName()), (TextAttributesKey)PhpHighlightingData.DOC_VAR);
            } else if (element instanceof PhpDocRef) {
                PhpDocRef ref = (PhpDocRef)element;
                if (tag.getName().equals("@noinspection")) {
                    PhpNamedElementDocSource.tryToAppendLink(builder2, ref.getText(), true, (PsiElement)tag, true);
                } else {
                    String link = PhpDocRefReferenceContributor.getLinks(ref).stream().dropWhile(l -> PhpDocUtil.unresolvedLink(l, (PsiElement)tag)).findFirst().orElse(null);
                    PhpNamedElementDocSource.tryToAppendLink(builder2, link, ref.getText(), true, (PsiElement)tag, true);
                }
            } else if (PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_IDENTIFIER)) {
                QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)builder2, (String)element.getText(), (TextAttributesKey)PhpHighlightingData.DOC_IDENTIFIER);
            } else {
                builder2.append(element.getText());
            }
            element = element.getNextSibling();
        }
        QuickDocHighlightingHelper.wrapWithInlineCodeTag((StringBuilder)builder2);
        builder2.append(PhpDocUtil.getTagValue(tag));
        String tagName = tag.getName().substring(1, 2).toUpperCase(Locale.ROOT) + tag.getName().substring(2);
        if (builder2.isEmpty()) {
            PhpDocumentationProvider.addSection(buffer, tagName);
        }
        PhpDocumentationProvider.addSection(buffer, tagName + ":", builder2.toString());
    }

    private static void addUnknownTagSection(StringBuilder buffer, PhpDocComment comment) {
        List<PhpDocTag> tags = PhpPsiUtil.getChildren((PsiElement)comment, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF);
        for (PhpDocTag tag : tags) {
            if (PhpDocumentationProvider.isKnownTag(tag)) continue;
            PhpDocumentationProvider.appendTagInfo(buffer, tag);
        }
    }

    private static boolean isKnownTag(@NotNull PhpDocTag tag) {
        String name;
        if (tag == null) {
            PhpDocumentationProvider.$$$reportNull$$$0(21);
        }
        return TEMPLATE_TAGS.contains(name = tag.getName()) || PROPERTY_TAGS.contains(name) || THROWS_TAGS.contains(name) || RETURN_TAGS.contains(name) || PARAM_TAGS.contains(name) || KNOWN_TAGS.contains(name) || PhpDocumentationProvider.isTodoTag(name);
    }

    private static boolean isTodoTag(String name) {
        return (name = name.toLowerCase(Locale.ROOT)).equals("@todo") || name.equals("@fixme");
    }

    private static void appendFinalTagInfo(StringBuilder buffer, PhpDocComment comment) {
        if (comment == null) {
            return;
        }
        PhpDocTag tag = (PhpDocTag)ArrayUtil.getFirstElement((Object[])comment.getTagElementsByName("@final"));
        if (tag == null) {
            return;
        }
        String content = tag.getTagValue();
        if (StringUtil.isEmpty((String)content)) {
            PhpDocumentationProvider.addSection(buffer, "<u><b>Final</b></u>");
        } else {
            PhpDocumentationProvider.addSection(buffer, "<u><b>Final</b></u>:", content);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateRenderedDoc";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDocComments";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doNotGenerateQuickDoc";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "generateDoc";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomDocumentationElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocSourceFor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocSource";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addSection";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "appendTagInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isKnownTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

