/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpDeprecationQuickFixesProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpCallableMethod;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDeprecationInfoBasedQuickFixProvider
implements PhpDeprecationQuickFixesProvider {
    private static final PhpDeprecationTemplateVariable PARAMETER_LIST_TEMPLATE_VARIABLE = new PhpDeprecationTemplateVariable("%parametersList%", r -> {
        if (r instanceof FunctionReference) {
            ParameterList list = ((FunctionReference)r).getParameterList();
            return list != null ? list.getText() : null;
        }
        if (r instanceof PhpCallableFunction) {
            return "";
        }
        return null;
    });
    private static final PhpDeprecationTemplateVariable NAME_DEPRECATION_TEMPLATE = new PhpDeprecationTemplateVariable("%name%", reference -> {
        if (reference instanceof MethodReference) {
            return reference.getName();
        }
        PsiElement lParen = PhpPsiUtil.getChildOfType(reference.getElement(), PhpTokenTypes.chLPAREN);
        TextRange range = lParen != null ? TextRange.create((int)0, (int)lParen.getStartOffsetInParent()) : TextRange.create((int)0, (int)reference.getTextRange().getLength());
        return range.substring(reference.getText());
    });
    private static final PhpDeprecationTemplateVariable CLASS_REFERENCE_DEPRECATION_TEMPLATE = new PhpDeprecationTemplateVariable("%class%", reference -> {
        if (reference instanceof MethodReference) {
            PhpExpression classReference = ((MethodReference)reference).getClassReference();
            return classReference != null ? classReference.getText() : null;
        }
        if (reference instanceof PhpCallableMethod) {
            PhpExpression classReference = ((PhpCallableMethod)reference).getClassReference();
            return classReference != null ? classReference.getText() : null;
        }
        return null;
    });
    private static final String SIMPLE_FUNCTION_CALL_REGEX = "[a-zA-Z_\\x80-\\xff][a-zA-Z0-9_\\x80-\\xff]*\\((" + PARAMETER_LIST_TEMPLATE_VARIABLE.getTemplate() + ")?\\)$";

    @Override
    @NotNull
    public Collection<? extends LocalQuickFix> createFixes(@NotNull PsiElement deprecatedReference, @NotNull PhpNamedElement deprecatedElement) {
        if (deprecatedReference == null) {
            PhpDeprecationInfoBasedQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (deprecatedElement == null) {
            PhpDeprecationInfoBasedQuickFixProvider.$$$reportNull$$$0(1);
        }
        if (deprecatedElement instanceof PhpDeprecationAttributeOwner && (deprecatedReference instanceof FunctionReference || deprecatedReference instanceof PhpCallableFunction)) {
            String replaceWith;
            PhpDeprecationAttributeOwner.PhpDeprecationInfo info = ((PhpDeprecationAttributeOwner)deprecatedElement).getDeprecationInfo();
            String string = replaceWith = info != null ? info.getReplaceWith() : null;
            if (PhpDeprecationInfoBasedQuickFixProvider.isReplacementSupported(deprecatedReference, replaceWith)) {
                List<PhpReplaceWithDeprecationInfoBasedQuickFix> list = Collections.singletonList(new PhpReplaceWithDeprecationInfoBasedQuickFix(deprecatedReference, deprecatedElement, replaceWith));
                if (list == null) {
                    PhpDeprecationInfoBasedQuickFixProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            PhpDeprecationInfoBasedQuickFixProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static boolean isReplacementSupported(@NotNull PsiElement reference, @Nullable String replaceWith) {
        if (reference == null) {
            PhpDeprecationInfoBasedQuickFixProvider.$$$reportNull$$$0(4);
        }
        if (replaceWith == null) {
            return false;
        }
        if (reference instanceof FunctionReference) {
            return true;
        }
        if (reference instanceof PhpCallableMethod) {
            return replaceWith.matches(CLASS_REFERENCE_DEPRECATION_TEMPLATE.getTemplate() + "->" + SIMPLE_FUNCTION_CALL_REGEX);
        }
        if (reference instanceof PhpCallableFunction) {
            return replaceWith.matches(SIMPLE_FUNCTION_CALL_REGEX);
        }
        return false;
    }

    public static Collection<PhpDeprecationTemplateVariable> getDeprecationTemplateVariables(@Nullable PhpNamedElement element) {
        if (element == null) {
            return Collections.emptyList();
        }
        ArrayList<PhpDeprecationTemplateVariable> res = new ArrayList<PhpDeprecationTemplateVariable>();
        if (element instanceof Function) {
            Parameter[] parameters = ((Function)element).getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                res.add(PhpDeprecationInfoBasedQuickFixProvider.createParameterDeprecationTemplate(i));
            }
            res.add(PARAMETER_LIST_TEMPLATE_VARIABLE);
            res.add(NAME_DEPRECATION_TEMPLATE);
            if (element instanceof Method) {
                res.add(CLASS_REFERENCE_DEPRECATION_TEMPLATE);
            }
        }
        return res;
    }

    @NotNull
    private static PhpDeprecationTemplateVariable createParameterDeprecationTemplate(int i) {
        return new PhpDeprecationTemplateVariable(String.format("%%parameter%d%%", i), reference -> {
            ParameterListOwner owner = (ParameterListOwner)ObjectUtils.tryCast((Object)reference, ParameterListOwner.class);
            PsiElement argument = owner != null ? owner.getParameter(i) : null;
            return argument != null ? argument.getText() : null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReplacementSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class PhpReplaceWithDeprecationInfoBasedQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myText;

        private PhpReplaceWithDeprecationInfoBasedQuickFix(@NotNull PsiElement reference, @NotNull PhpNamedElement deprecatedElement, String replaceWith) {
            if (reference == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(0);
            }
            if (deprecatedElement == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(1);
            }
            this.myText = PhpReplaceWithDeprecationInfoBasedQuickFix.composeText(reference, deprecatedElement, replaceWith);
        }

        private static String composeText(PsiElement reference, @NotNull PhpNamedElement deprecatedElement, String replaceWith) {
            if (deprecatedElement == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(2);
            }
            if (reference instanceof FunctionReference || reference instanceof PhpCallableFunction) {
                int lparenIndex;
                if (reference instanceof PhpCallableFunction && (lparenIndex = ((String)replaceWith).indexOf("(")) > 0) {
                    replaceWith = ((String)replaceWith).substring(0, lparenIndex) + "(...)";
                }
                Collection<PhpDeprecationTemplateVariable> deprecationTemplateVariables = PhpDeprecationInfoBasedQuickFixProvider.getDeprecationTemplateVariables(deprecatedElement);
                for (PhpDeprecationTemplateVariable variable : deprecationTemplateVariables) {
                    String replacement = variable.myReplaceFunction.apply((PhpReference)((PhpReference)reference));
                    if (replacement == null) continue;
                    replaceWith = ((String)replaceWith).replace(variable.getTemplate(), replacement);
                }
            }
            return replaceWith;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myText);
            if (string == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(4);
            }
            if (element == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(6);
            }
            PhpExpression newElement = PhpPsiElementFactory.createFirstFromText(project, PhpExpression.class, this.myText);
            assert (newElement != null);
            element.replace((PsiElement)newElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deprecatedElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider$PhpReplaceWithDeprecationInfoBasedQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider$PhpReplaceWithDeprecationInfoBasedQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "composeText";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpDeprecationTemplateVariable {
        @NotNull
        private final String myTemplate;
        private final java.util.function.Function<? super @NotNull PhpReference, @Nullable String> myReplaceFunction;

        public PhpDeprecationTemplateVariable(@NotNull String template, java.util.function.Function<? super @NotNull PhpReference, @Nullable String> replaceFunction) {
            if (template == null) {
                PhpDeprecationTemplateVariable.$$$reportNull$$$0(0);
            }
            this.myTemplate = template;
            this.myReplaceFunction = replaceFunction;
        }

        @NotNull
        public String getTemplate() {
            String string = this.myTemplate;
            if (string == null) {
                PhpDeprecationTemplateVariable.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider$PhpDeprecationTemplateVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider$PhpDeprecationTemplateVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

