/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.annotator.PhpReplaceWithElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRedundantAssignmentToPromotedFieldInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddThrowBeforeExceptionQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class PhpExpressionResultUnusedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpElement(PhpPsiElement element) {
                if (element instanceof PhpExpression) {
                    UnaryExpression unaryExpression;
                    if (element instanceof AssignmentExpression || element instanceof PhpGoto || element instanceof UnaryExpression && PhpPsiUtil.isOfType((unaryExpression = (UnaryExpression)element).getOperation(), PhpTokenTypes.opVOID_CAST)) {
                        return;
                    }
                    if (!(element.getParent() instanceof PhpUse)) {
                        PhpExpressionResultUnusedInspection.analyzeExpression((PhpExpression)element, holder);
                    }
                }
            }

            public void visitPhpMethodReference(MethodReference reference) {
                if (PhpLangUtil.equalsMethodNames(reference.getName(), "__construct") && !(reference.getClassReference() instanceof Variable)) {
                    return;
                }
                this.visitPhpElement((PhpPsiElement)reference);
            }
        };
    }

    public static boolean hasNoDiscardAttribute(@NotNull PhpExpression psiElement) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(1);
        }
        if (!PhpLanguageFeature.NO_DISCARD_ATTRIBUTE.isSupported(psiElement.getProject())) {
            return false;
        }
        if (!(psiElement instanceof FunctionReference)) {
            return false;
        }
        FunctionReference call = (FunctionReference)psiElement;
        return ContainerUtil.exists((Iterable)call.multiResolveStrict(Function.class), it -> !it.getAttributes("\\NoDiscard").isEmpty());
    }

    private static void analyzeExpression(@NotNull PhpExpression psiElement, @NotNull ProblemsHolder holder) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(3);
        }
        if (!PhpExpressionResultUnusedInspection.isResultUnused(psiElement)) {
            return;
        }
        boolean isInsideSingleStatement = PhpExpressionResultUnusedInspection.isInsideSingleStatement((PsiElement)psiElement);
        if (PhpExpressionResultUnusedInspection.hasNoDiscardAttribute(psiElement)) {
            PhpExpressionResultUnusedInspection.registerNoDiscardAttribute(psiElement, holder, isInsideSingleStatement);
        } else if (!PhpSideEffectDetector.canContainSideEffect((PsiElement)psiElement)) {
            if (PhpExpressionResultUnusedInspection.hasOnlyThrowableTypes(psiElement)) {
                PhpExpressionResultUnusedInspection.registerUnusedThrowable(psiElement, holder, isInsideSingleStatement);
            } else {
                PhpExpressionResultUnusedInspection.registerUnusedExpression(psiElement, holder, isInsideSingleStatement);
            }
        }
    }

    private static boolean isResultUnused(@NotNull PhpExpression psiElement) {
        PsiElement parent;
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(4);
        }
        if ((parent = psiElement.getParent()) instanceof BinaryExpression && ((BinaryExpression)parent).getRightOperand() == psiElement && PhpLangUtil.isShortCircuitOperator(((BinaryExpression)parent).getOperationType()) && !PhpCodeInsightUtil.isResultUsed(parent) && PhpSideEffectDetector.canContainSideEffect(((BinaryExpression)parent).getLeftOperand())) {
            return true;
        }
        return !PhpCodeInsightUtil.isResultUsed((PsiElement)psiElement);
    }

    public static boolean isInsideSingleStatement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(5);
        }
        PsiElement parent = psiElement.getParent();
        return PhpRedundantAssignmentToPromotedFieldInspection.isSingleStatement(parent);
    }

    private static void registerUnusedExpression(@NotNull PhpExpression psiElement, @NotNull ProblemsHolder holder, boolean isInsideSingleStatement) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(7);
        }
        PsiElement parent = psiElement.getParent();
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (isInsideSingleStatement) {
            fixes.add(LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(parent)));
        }
        if (parent instanceof BinaryExpression && ((BinaryExpression)parent).getLeftOperand() != null) {
            fixes.add(LocalQuickFix.from((ModCommandAction)new PhpReplaceWithElementQuickFix(parent, ((BinaryExpression)parent).getLeftOperand())));
        }
        if (PhpLanguageFeature.CAST_TO_VOID.isSupported(psiElement.getProject()) && psiElement instanceof FunctionReference) {
            fixes.add(PhpExpressionResultUnusedInspection.getCastToVoidQuickFix(psiElement));
        }
        holder.registerProblem(PhpExpressionResultUnusedInspection.getElementToHighlight(psiElement), PhpBundle.message("inspection.expression.result.unused.problem", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static LocalQuickFix getCastToVoidQuickFix(PhpExpression psiElement) {
        String text = psiElement.getText();
        Statement replaceWith = PhpPsiElementFactory.createFromText(psiElement.getProject(), Statement.class, "(void) %s;".formatted(text));
        return LocalQuickFix.from((ModCommandAction)new PhpReplaceWithElementQuickFix(psiElement.getParent(), (PsiElement)replaceWith));
    }

    private static void registerUnusedThrowable(@NotNull PhpExpression expression, @NotNull ProblemsHolder holder, boolean insideSingleStatement) {
        LocalQuickFix[] localQuickFixArray;
        if (expression == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(9);
        }
        if (insideSingleStatement) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = PhpAddThrowBeforeExceptionQuickFix.INSTANCE;
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] fixes = localQuickFixArray;
        holder.registerProblem(PhpExpressionResultUnusedInspection.getElementToHighlight(expression), PhpBundle.message("inspection.php.throwable.not.thrown.inspection.display.name", new Object[0]), fixes);
    }

    private static void registerNoDiscardAttribute(@NotNull PhpExpression psiElement, @NotNull ProblemsHolder holder, boolean insideSingleStatement) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(11);
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        fixes.add(PhpExpressionResultUnusedInspection.getCastToVoidQuickFix(psiElement));
        if (insideSingleStatement) {
            fixes.add(LocalQuickFix.from((ModCommandAction)new PhpDeleteElementQuickFix(psiElement.getParent())));
        }
        holder.registerProblem(PhpExpressionResultUnusedInspection.getElementToHighlight(psiElement), PhpBundle.message("inspection.expression.result.unused.no.discard.attribute.problem", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PhpExpression psiElement) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(12);
        }
        Object object = psiElement instanceof PhpMatchExpression ? psiElement.getFirstChild() : psiElement;
        if (object == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(13);
        }
        return object;
    }

    private static boolean hasOnlyThrowableTypes(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(14);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)expression.getProject());
        PhpType type = expression.getGlobalType();
        return !type.isEmpty() && ContainerUtil.all((Collection)type.getTypes(), t -> PhpType.findSuper((String)"\\Throwable", (String)t, (PhpIndex)phpIndex));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpExpressionResultUnusedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpExpressionResultUnusedInspection";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasNoDiscardAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isResultUnused";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSingleStatement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerUnusedExpression";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerUnusedThrowable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerNoDiscardAttribute";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyThrowableTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

