/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpHookedPropertyCantBeAccessedByRefInspectionKt;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpPropertyWithoutSetHookInspection;
import com.jetbrains.php.lang.inspections.PhpPropertyWithoutSetHookInspectionKt;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpPropertyWithoutSetHookInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "PhpPromotePropertyWithPrivateSetQuickFix", "PhpReplacePropertyWithPrivateSetQuickFix", "intellij.php.impl"})
public final class PhpPropertyWithoutSetHookInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpMethod(Method method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                if (method.getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
                    return;
                }
                Parameter[] parameterArray = method.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
                for (Parameter parameter : parameterArray) {
                    Intrinsics.checkNotNull((Object)parameter);
                    this.checkConstructorParameter(method, parameter);
                }
            }

            private final void checkConstructorParameter(Method constructor, Parameter parameter) {
                if (parameter.getDeclaredType().isEmpty()) {
                    return;
                }
                PhpClass phpClass = constructor.getContainingClass();
                if (phpClass == null) {
                    return;
                }
                PhpClass clazz = phpClass;
                if (parameter.isPromotedField()) {
                    if (!parameter.getPromotedFieldAccess().isPrivate()) {
                        return;
                    }
                    Intrinsics.checkNotNull((Object)parameter, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Field");
                    Field field = this.findVirtualPropertyExposingFieldWithGetHook(clazz, (Field)parameter);
                    if (field == null) {
                        return;
                    }
                    Field exposingProperty = field;
                    String string = PhpBundle.message("inspection.php.property.can.be.replaced.with.private.set.modifier", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String message = string;
                    PhpReplacePropertyWithPrivateSetQuickFix quickFix = new PhpReplacePropertyWithPrivateSetQuickFix((SmartPsiElementPointer<Parameter>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)parameter)), (SmartPsiElementPointer<Field>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)exposingProperty)));
                    buildVisitor.1.registerProblems$default(this, message, quickFix, exposingProperty, null, 8, null);
                } else {
                    AssignmentExpression assignmentExpression = this.findAssignment(constructor, parameter);
                    if (assignmentExpression == null) {
                        return;
                    }
                    AssignmentExpression assignment = assignmentExpression;
                    Object object = assignment.getVariable();
                    if (object == null || (object = object.getName()) == null) {
                        return;
                    }
                    Object assignedFieldName = object;
                    Field field = this.findAssignedField(clazz, parameter, (CharSequence)assignedFieldName);
                    if (field == null) {
                        return;
                    }
                    Field assignedField = field;
                    Field field2 = this.findVirtualPropertyExposingFieldWithGetHook(clazz, assignedField);
                    if (field2 == null) {
                        return;
                    }
                    Field exposingProperty = field2;
                    if (!PhpLangUtil.equalsFieldNames(parameter.getName(), exposingProperty.getName())) {
                        return;
                    }
                    String string = PhpBundle.message("inspection.php.property.can.be.promoted.with.private.set.modifier", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String message = string;
                    PhpPromotePropertyWithPrivateSetQuickFix quickFix = new PhpPromotePropertyWithPrivateSetQuickFix((SmartPsiElementPointer<Parameter>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)parameter)), (SmartPsiElementPointer<AssignmentExpression>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)assignment)), (SmartPsiElementPointer<Field>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)assignedField)), (SmartPsiElementPointer<Field>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)exposingProperty)));
                    this.registerProblems(message, quickFix, exposingProperty, assignedField);
                }
            }

            private final AssignmentExpression findAssignment(Method constructor, Parameter parameter) {
                List assignments = new ArrayList<E>();
                Ref parameterNonReadAccessBeforeAssignment = new Ref((Object)false);
                PhpControlFlowUtil.processFlow(constructor.getControlFlow(), new PhpInstructionProcessor(assignments, (Ref<Boolean>)parameterNonReadAccessBeforeAssignment, parameter){
                    final /* synthetic */ List<AssignmentExpression> $assignments;
                    final /* synthetic */ Ref<Boolean> $parameterNonReadAccessBeforeAssignment;
                    final /* synthetic */ Parameter $parameter;
                    {
                        this.$assignments = $assignments;
                        this.$parameterNonReadAccessBeforeAssignment = $parameterNonReadAccessBeforeAssignment;
                        this.$parameter = $parameter;
                    }

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                        if ((instruction.getAccess().isWrite() || !instruction.getAccess().isRead()) && this.$assignments.isEmpty()) {
                            this.$parameterNonReadAccessBeforeAssignment.set((Object)true);
                            return false;
                        }
                        return true;
                    }

                    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                        if (instruction.getAccess().isWrite() && PhpLangUtil.isThisReference(instruction.getVariableName())) {
                            AssignmentExpression assignmentExpression = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), AssignmentExpression.class);
                            if (assignmentExpression == null) {
                                return true;
                            }
                            AssignmentExpression assignmentExpression2 = assignmentExpression;
                            PhpPsiElement phpPsiElement = assignmentExpression2.getValue();
                            Variable variable = phpPsiElement instanceof Variable ? (Variable)phpPsiElement : null;
                            if (variable == null) {
                                return true;
                            }
                            Variable assignedVariable = variable;
                            if (PhpLangUtil.equalsFieldNames(assignedVariable.getName(), this.$parameter.getName())) {
                                this.$assignments.add(assignmentExpression2);
                                return true;
                            }
                        }
                        return true;
                    }
                });
                if (((Boolean)parameterNonReadAccessBeforeAssignment.get()).booleanValue()) {
                    return null;
                }
                if (assignments.size() > 1) {
                    return null;
                }
                return (AssignmentExpression)CollectionsKt.firstOrNull((List)assignments);
            }

            private final Field findAssignedField(PhpClass clazz, Parameter parameter, CharSequence assignedFieldName) {
                Field field = clazz.findOwnFieldByName(assignedFieldName, false);
                if (field == null) {
                    return null;
                }
                Field assignedField = field;
                if (!(assignedField instanceof FieldImpl) || ((FieldImpl)assignedField).isReadonly() || ((FieldImpl)assignedField).getModifier().isStatic() || !((FieldImpl)assignedField).getModifier().isPrivate() || ((FieldImpl)assignedField).isVirtualProperty()) {
                    return null;
                }
                if (!Intrinsics.areEqual((Object)((FieldImpl)assignedField).getDeclaredType(), (Object)parameter.getDeclaredType())) {
                    return null;
                }
                if (!PhpTypeAnalyserVisitor.fieldAssignmentAlwaysReachable(assignedField, true)) {
                    return null;
                }
                return assignedField;
            }

            private final Field findVirtualPropertyExposingFieldWithGetHook(PhpClass clazz, Field exposedField) {
                Object v2;
                block1: {
                    Field[] fieldArray = clazz.getOwnFields();
                    Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getOwnFields(...)");
                    Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])fieldArray), buildVisitor.1::findVirtualPropertyExposingFieldWithGetHook$lambda$0), arg_0 -> buildVisitor.1.findVirtualPropertyExposingFieldWithGetHook$lambda$1(exposedField, arg_0)), buildVisitor.1::findVirtualPropertyExposingFieldWithGetHook$lambda$2), buildVisitor.1::findVirtualPropertyExposingFieldWithGetHook$lambda$3), buildVisitor.1::findVirtualPropertyExposingFieldWithGetHook$lambda$4);
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        Field it = (Field)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        PhpPropertyHook phpPropertyHook = PhpHookedPropertyCantBeAccessedByRefInspectionKt.getGetHook(it);
                        Intrinsics.checkNotNull((Object)phpPropertyHook);
                        if (!this.getHookReturnsField(phpPropertyHook, exposedField)) continue;
                        v2 = element$iv;
                        break block1;
                    }
                    v2 = null;
                }
                return v2;
            }

            private final boolean getHookReturnsField(PhpPropertyHook hook, Field field) {
                FieldReference fieldReference = null;
                if (hook.isShort()) {
                    FieldReference fieldReference2 = (FieldReference)PhpPsiUtil.getChildByCondition((PsiElement)hook, (Condition<? super PsiElement>)FieldReference.INSTANCEOF);
                    if (fieldReference2 == null) {
                        return false;
                    }
                    fieldReference = fieldReference2;
                } else {
                    GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)hook, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                    if (groupStatement == null) {
                        return false;
                    }
                    GroupStatement body = groupStatement;
                    PsiElement psiElement = body.getOnlyStatement();
                    PhpReturn phpReturn = psiElement instanceof PhpReturn ? (PhpReturn)psiElement : null;
                    if (phpReturn == null) {
                        return false;
                    }
                    PhpReturn returnStatement = phpReturn;
                    psiElement = returnStatement.getArgument();
                    FieldReference fieldReference3 = psiElement instanceof FieldReference ? (FieldReference)psiElement : null;
                    if (fieldReference3 == null) {
                        return false;
                    }
                    fieldReference = fieldReference3;
                }
                PhpExpression phpExpression = fieldReference.getClassReference();
                Variable variable = phpExpression instanceof Variable ? (Variable)phpExpression : null;
                if (variable == null) {
                    return false;
                }
                Variable classRef = variable;
                if (!Intrinsics.areEqual((Object)classRef.getName(), (Object)"this")) {
                    return false;
                }
                return PhpLangUtil.equalsFieldNames(fieldReference.getName(), field.getName());
            }

            private final void registerProblems(@Nls String message, PsiUpdateModCommandQuickFix quickFix, Field exposingProperty, Field assignedField) {
                this.$holder.problem((PsiElement)exposingProperty, message).fix((LocalQuickFix)quickFix).register();
                if (assignedField != null) {
                    this.$holder.problem((PsiElement)assignedField, message).fix((LocalQuickFix)quickFix).register();
                }
            }

            static /* synthetic */ void registerProblems$default(buildVisitor.1 var0, String string, PsiUpdateModCommandQuickFix psiUpdateModCommandQuickFix, Field field, Field field2, int n, Object object) {
                if ((n & 8) != 0) {
                    field2 = null;
                }
                var0.registerProblems(string, psiUpdateModCommandQuickFix, field, field2);
            }

            private static final boolean findVirtualPropertyExposingFieldWithGetHook$lambda$0(Field it) {
                return it instanceof FieldImpl;
            }

            private static final boolean findVirtualPropertyExposingFieldWithGetHook$lambda$1(Field $exposedField, Field it) {
                return Intrinsics.areEqual((Object)it.getDeclaredType(), (Object)$exposedField.getDeclaredType());
            }

            private static final boolean findVirtualPropertyExposingFieldWithGetHook$lambda$2(Field it) {
                return it.getModifier().isStatic() || it.getModifier().isPrivate() || it.isReadonly();
            }

            private static final boolean findVirtualPropertyExposingFieldWithGetHook$lambda$3(Field it) {
                return it.isVirtualProperty();
            }

            private static final boolean findVirtualPropertyExposingFieldWithGetHook$lambda$4(Field it) {
                Intrinsics.checkNotNull((Object)it);
                return PhpHookedPropertyCantBeAccessedByRefInspectionKt.getGetHook(it) != null && PhpHookedPropertyCantBeAccessedByRefInspectionKt.getSetHook(it) == null;
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J \u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpPropertyWithoutSetHookInspection$PhpPromotePropertyWithPrivateSetQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "parameterPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/jetbrains/php/lang/psi/elements/Parameter;", "assignmentPointer", "Lcom/jetbrains/php/lang/psi/elements/AssignmentExpression;", "privateFieldPointer", "Lcom/jetbrains/php/lang/psi/elements/Field;", "exposingPropertyPointer", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "insertVisibilityModifiers", "parameter", "exposingProperty", "intellij.php.impl"})
    @SourceDebugExtension(value={"SMAP\nPhpPropertyWithoutSetHookInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpPropertyWithoutSetHookInspection.kt\ncom/jetbrains/php/lang/inspections/PhpPropertyWithoutSetHookInspection$PhpPromotePropertyWithPrivateSetQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n1669#2,8:251\n*S KotlinDebug\n*F\n+ 1 PhpPropertyWithoutSetHookInspection.kt\ncom/jetbrains/php/lang/inspections/PhpPropertyWithoutSetHookInspection$PhpPromotePropertyWithPrivateSetQuickFix\n*L\n171#1:251,8\n*E\n"})
    private static final class PhpPromotePropertyWithPrivateSetQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final SmartPsiElementPointer<Parameter> parameterPointer;
        @NotNull
        private final SmartPsiElementPointer<AssignmentExpression> assignmentPointer;
        @NotNull
        private final SmartPsiElementPointer<Field> privateFieldPointer;
        @NotNull
        private final SmartPsiElementPointer<Field> exposingPropertyPointer;

        public PhpPromotePropertyWithPrivateSetQuickFix(@NotNull SmartPsiElementPointer<Parameter> parameterPointer, @NotNull SmartPsiElementPointer<AssignmentExpression> assignmentPointer, @NotNull SmartPsiElementPointer<Field> privateFieldPointer, @NotNull SmartPsiElementPointer<Field> exposingPropertyPointer) {
            Intrinsics.checkNotNullParameter(parameterPointer, (String)"parameterPointer");
            Intrinsics.checkNotNullParameter(assignmentPointer, (String)"assignmentPointer");
            Intrinsics.checkNotNullParameter(privateFieldPointer, (String)"privateFieldPointer");
            Intrinsics.checkNotNullParameter(exposingPropertyPointer, (String)"exposingPropertyPointer");
            this.parameterPointer = parameterPointer;
            this.assignmentPointer = assignmentPointer;
            this.privateFieldPointer = privateFieldPointer;
            this.exposingPropertyPointer = exposingPropertyPointer;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quick.fix.promote.property.with.private.set.visibility.modifier", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            Parameter parameter = (Parameter)updater.getWritable(this.parameterPointer.getElement());
            if (parameter == null) {
                return;
            }
            Parameter parameter2 = parameter;
            AssignmentExpression assignmentExpression = (AssignmentExpression)updater.getWritable(this.assignmentPointer.getElement());
            if (assignmentExpression == null) {
                return;
            }
            AssignmentExpression assignment = assignmentExpression;
            Field field = (Field)updater.getWritable(this.privateFieldPointer.getElement());
            if (field == null) {
                return;
            }
            Field privateField = field;
            Field field2 = (Field)updater.getWritable(this.exposingPropertyPointer.getElement());
            if (field2 == null) {
                return;
            }
            Field exposingProperty = field2;
            Collection collection = privateField.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAttributes(...)");
            Collection collection2 = exposingProperty.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getAttributes(...)");
            Iterable $this$distinctBy$iv = CollectionsKt.plus((Collection)collection, (Iterable)collection2);
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                PhpAttribute attr = (PhpAttribute)e$iv;
                boolean bl = false;
                String key$iv = attr.getName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List attributesToAdd = list$iv;
            PhpPropertyWithoutSetHookInspectionKt.access$addNotPresentAttributes(project, parameter2, attributesToAdd);
            this.insertVisibilityModifiers(project, parameter2, exposingProperty);
            assignment.getParent().delete();
            PhpMoveClassMemberBase.removeFieldWithPhpDoc(exposingProperty);
            String string = parameter2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            PhpPropertyWithoutSetHookInspectionKt.access$replaceFieldUsages(project, privateField, string);
            PhpMoveClassMemberBase.removeFieldWithPhpDoc(privateField);
            updater.moveCaretTo((PsiElement)parameter2);
        }

        private final void insertVisibilityModifiers(Project project, Parameter parameter, Field exposingProperty) {
            if (exposingProperty.getModifier().isProtected()) {
                PhpModifierList phpModifierList = PhpPsiElementFactory.createModifierList(project, exposingProperty.getModifier());
                Intrinsics.checkNotNullExpressionValue((Object)phpModifierList, (String)"createModifierList(...)");
                PhpModifierList protectedModifier = phpModifierList;
                PsiElement psiElement = (PsiElement)protectedModifier;
                PhpTypeDeclaration phpTypeDeclaration = parameter.getTypeDeclaration();
                Intrinsics.checkNotNull((Object)phpTypeDeclaration);
                parameter.addBefore(psiElement, (PsiElement)phpTypeDeclaration);
            }
            PhpModifierList phpModifierList = PhpPsiElementFactory.createModifierList(parameter.getProject(), PhpModifier.Access.PRIVATE);
            Intrinsics.checkNotNullExpressionValue((Object)phpModifierList, (String)"createModifierList(...)");
            PhpModifierList privateSetModifier = phpModifierList;
            PsiElement psiElement = (PsiElement)privateSetModifier;
            PhpTypeDeclaration phpTypeDeclaration = parameter.getTypeDeclaration();
            Intrinsics.checkNotNull((Object)phpTypeDeclaration);
            parameter.addBefore(psiElement, (PsiElement)phpTypeDeclaration);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0006H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpPropertyWithoutSetHookInspection$PhpReplacePropertyWithPrivateSetQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "parameterPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/jetbrains/php/lang/psi/elements/Parameter;", "exposingPropertyPointer", "Lcom/jetbrains/php/lang/psi/elements/Field;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "changeVisibilityModifiers", "parameter", "exposingProperty", "intellij.php.impl"})
    private static final class PhpReplacePropertyWithPrivateSetQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final SmartPsiElementPointer<Parameter> parameterPointer;
        @NotNull
        private final SmartPsiElementPointer<Field> exposingPropertyPointer;

        public PhpReplacePropertyWithPrivateSetQuickFix(@NotNull SmartPsiElementPointer<Parameter> parameterPointer, @NotNull SmartPsiElementPointer<Field> exposingPropertyPointer) {
            Intrinsics.checkNotNullParameter(parameterPointer, (String)"parameterPointer");
            Intrinsics.checkNotNullParameter(exposingPropertyPointer, (String)"exposingPropertyPointer");
            this.parameterPointer = parameterPointer;
            this.exposingPropertyPointer = exposingPropertyPointer;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quick.fix.replace.property.with.private.set.visibility.modifier", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            Parameter parameter = (Parameter)updater.getWritable(this.parameterPointer.getElement());
            if (parameter == null) {
                return;
            }
            Parameter parameter2 = parameter;
            Field field = (Field)updater.getWritable(this.exposingPropertyPointer.getElement());
            if (field == null) {
                return;
            }
            Field exposingProperty = field;
            Collection collection = exposingProperty.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAttributes(...)");
            PhpPropertyWithoutSetHookInspectionKt.access$addNotPresentAttributes(project, parameter2, collection);
            this.changeVisibilityModifiers(project, parameter2, exposingProperty);
            Field field2 = (Field)parameter2;
            String string = exposingProperty.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            PhpPropertyWithoutSetHookInspectionKt.access$replaceFieldUsages(project, field2, string);
            parameter2.setName(exposingProperty.getName());
            PhpMoveClassMemberBase.removeFieldWithPhpDoc(exposingProperty);
            updater.moveCaretTo((PsiElement)parameter2);
        }

        private final void changeVisibilityModifiers(Project project, Parameter parameter, Field exposingProperty) {
            PsiElement psiElement = parameter.getNameIdentifier();
            Intrinsics.checkNotNull((Object)psiElement);
            Object t = PhpPsiUtil.getPrevSiblingByCondition(psiElement, (Condition<? super PsiElement>)((Condition)arg_0 -> PhpReplacePropertyWithPrivateSetQuickFix.changeVisibilityModifiers$lambda$1(PhpReplacePropertyWithPrivateSetQuickFix::changeVisibilityModifiers$lambda$0, arg_0)));
            Intrinsics.checkNotNull(t);
            Object visibilityModifier = t;
            if (exposingProperty.getModifier().isProtected()) {
                PhpModifierList phpModifierList = PhpPsiElementFactory.createModifierList(project, exposingProperty.getModifier());
                Intrinsics.checkNotNullExpressionValue((Object)phpModifierList, (String)"createModifierList(...)");
                PhpModifierList protectedModifier = phpModifierList;
                parameter.addBefore((PsiElement)protectedModifier, visibilityModifier);
            }
            PhpModifierList phpModifierList = PhpPsiElementFactory.createModifierList(parameter.getProject(), PhpModifier.Access.PRIVATE);
            Intrinsics.checkNotNullExpressionValue((Object)phpModifierList, (String)"createModifierList(...)");
            PhpModifierList privateSetModifier = phpModifierList;
            parameter.addBefore((PsiElement)privateSetModifier, visibilityModifier);
            visibilityModifier.delete();
        }

        private static final boolean changeVisibilityModifiers$lambda$0(PsiElement obj) {
            return PhpPsiUtil.isOfType(obj, PhpTokenTypes.kwPRIVATE);
        }

        private static final boolean changeVisibilityModifiers$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

