/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpImmutablePropertyIsWrittenInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpParameterByRefIsNotUsedAsReferenceInspection;
import com.jetbrains.php.lang.intentions.addConstructorParameters.PhpAddConstructorParametersIntention;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReadonlyPropertyWrittenOutsideDeclarationScopeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpReadonlyPropertyWrittenOutsideDeclarationScopeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFieldReference(FieldReference fieldReference) {
                PsiElement parent = fieldReference.getParent();
                boolean returnedFromReturnByRefFunction = PhpParameterByRefIsNotUsedAsReferenceInspection.isReturnedFromReturnByRefFunction((PsiElement)fieldReference);
                if (!(fieldReference.isWriteAccess() || parent instanceof AssignmentExpression && PhpWorkaroundUtil.isAssignByReference((AssignmentExpression)parent) || parent instanceof PhpUnset || returnedFromReturnByRefFunction)) {
                    return;
                }
                Collection fields = fieldReference.multiResolveStrict(Field.class);
                if (fields.isEmpty()) {
                    return;
                }
                if (ContainerUtil.exists((Iterable)fields, field -> !field.isReadonly())) {
                    return;
                }
                if (returnedFromReturnByRefFunction) {
                    holder.registerProblem((PsiElement)fieldReference, PhpBundle.message("inspection.message.write.access.to.readonly.property.outside.declaration.scope.ret.by.ref", new Object[0]), ProblemHighlightType.WARNING, LocalQuickFix.EMPTY_ARRAY);
                    return;
                }
                if (ContainerUtil.exists((Iterable)fields, field -> field.getModifier().isSetPublic() && !PhpReadonlyPropertyWrittenOutsideDeclarationScopeInspection.fieldIsInitializedInConstructor(field))) {
                    return;
                }
                if (ContainerUtil.all((Collection)fields, field -> PhpImmutablePropertyIsWrittenInspection.writeAccessIsNotAllowed(fieldReference, PhpImmutablePropertyIsWrittenInspection.PropertyWriteScope.PRIVATE, field))) {
                    holder.registerProblem((PsiElement)fieldReference, PhpBundle.message("inspection.message.write.access.to.readonly.property.outside.declaration.scope", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean fieldIsInitializedInConstructor(@NotNull Field field) {
        PhpClass clazz;
        if (field == null) {
            PhpReadonlyPropertyWrittenOutsideDeclarationScopeInspection.$$$reportNull$$$0(1);
        }
        if ((clazz = field.getContainingClass()) == null) {
            return false;
        }
        return !PhpAddConstructorParametersIntention.getUninitializedFieldsInConstructor(clazz).contains(field);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpReadonlyPropertyWrittenOutsideDeclarationScopeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fieldIsInitializedInConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

