/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpRedundantClosingTagInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "PhpRemoveClosingTagQuickFix", "intellij.php.impl"})
public final class PhpRedundantClosingTagInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpFile(PhpFile phpFile) {
                Intrinsics.checkNotNullParameter((Object)phpFile, (String)"phpFile");
                PsiFile psiFile = phpFile.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE);
                HtmlFileImpl htmlFileImpl = psiFile instanceof HtmlFileImpl ? (HtmlFileImpl)psiFile : null;
                if (htmlFileImpl == null) {
                    return;
                }
                HtmlFileImpl htmlFile = htmlFileImpl;
                PsiElement php = null;
                XmlDocument xmlDocument = htmlFile.getDocument();
                if (xmlDocument == null) {
                    return;
                }
                XmlDocument document = xmlDocument;
                PsiElement[] psiElementArray = document.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                for (PsiElement iElementTypeArray : psiElementArray) {
                    Intrinsics.checkNotNull((Object)iElementTypeArray);
                    PsiElement child = iElementTypeArray;
                    if (PhpPsiUtil.isOfType(child, PhpElementTypes.PHP_OUTER_TYPE)) {
                        if (php != null) {
                            return;
                        }
                        php = child;
                        continue;
                    }
                    if (child instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(child, XmlElementType.XML_PROLOG) || PhpAnnotatorVisitor.isShebang(child)) continue;
                    return;
                }
                if (php == null) {
                    PsiElement next = document.getNextSibling();
                    if (next == null || !PhpPsiUtil.isOfType(next, PhpElementTypes.PHP_OUTER_TYPE)) {
                        return;
                    }
                    php = next;
                }
                GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)phpFile, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                if (groupStatement == null) {
                    return;
                }
                GroupStatement statement = groupStatement;
                PhpNamespace namespace = (PhpNamespace)PhpPsiUtil.getChildByCondition((PsiElement)statement, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
                if (namespace != null && !namespace.isBraced()) {
                    T t = PhpPsiUtil.getChildByCondition((PsiElement)namespace, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                    Intrinsics.checkNotNull(t);
                    statement = (GroupStatement)t;
                }
                if (statement.getLastChild() == null) {
                    return;
                }
                for (PsiElement lastChild = v388528; lastChild != null; lastChild = lastChild.getPrevSibling()) {
                    PsiElement psiElement;
                    if (!PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.PHP_CLOSING_TAG) || !Intrinsics.areEqual((Object)"?>", (Object)lastChild.getText())) continue;
                    PsiElement openingTag = null;
                    if (namespace != null && !namespace.isBraced()) {
                        IElementType[] iElementTypeArray = new IElementType[]{PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG};
                        openingTag = PhpPsiUtil.findPrevSiblingOfAnyType((PsiElement)namespace, iElementTypeArray);
                    }
                    if (openingTag == null) {
                        IElementType[] iElementTypeArray = new IElementType[]{PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG};
                        openingTag = PhpPsiUtil.findPrevSiblingOfAnyType(lastChild, iElementTypeArray);
                    }
                    if (Intrinsics.areEqual(openingTag, (Object)(psiElement = phpFile.findElementAt(php.getTextOffset()))) && PhpPsiUtil.isOfType(openingTag, PhpTokenTypes.PHP_OPENING_TAG)) {
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{PhpRemoveClosingTagQuickFix.INSTANCE};
                        this.$holder.registerProblem(lastChild, PhpBundle.message("inspection.redundant.closing.tag.problem", new Object[0]), localQuickFixArray);
                    }
                    return;
                }
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/lang/inspections/PhpRedundantClosingTagInspection$PhpRemoveClosingTagQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.php.impl"})
    private static final class PhpRemoveClosingTagQuickFix
    implements LocalQuickFix {
        @NotNull
        public static final PhpRemoveClosingTagQuickFix INSTANCE = new PhpRemoveClosingTagQuickFix();

        private PhpRemoveClosingTagQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.redundant.closing.tag.fix.remove", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            descriptor.getPsiElement().delete();
        }
    }
}

