/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.attributes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.attributes.PhpAddOverrideAttributeInspectionKt;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/attributes/PhpOverriddenMethodExistsInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "PhpRemoveOverrideAttributeQuickFix", "intellij.php.impl"})
public final class PhpOverriddenMethodExistsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpMethod(Method method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                PhpClass phpClass = method.getContainingClass();
                if (phpClass == null) {
                    return;
                }
                PhpClass containingClass = phpClass;
                Collection collection = method.getAttributes("\\Override");
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAttributes(...)");
                PhpAttribute phpAttribute = (PhpAttribute)CollectionsKt.firstOrNull((Iterable)collection);
                if (phpAttribute == null) {
                    return;
                }
                PhpAttribute attribute = phpAttribute;
                if (containingClass.isTrait()) {
                    boolean bl;
                    block9: {
                        PhpIndex phpIndex = PhpIndex.getInstance((Project)method.getProject());
                        Intrinsics.checkNotNullExpressionValue((Object)phpIndex, (String)"getInstance(...)");
                        PhpIndex index = phpIndex;
                        Collection traitUsages = index.getTraitUsages(containingClass);
                        if (traitUsages.isEmpty()) {
                            return;
                        }
                        Intrinsics.checkNotNull((Object)traitUsages);
                        Iterable $this$all$iv = traitUsages;
                        boolean $i$f$all = false;
                        if (((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                PhpClass phpClass2 = (PhpClass)element$iv;
                                boolean bl2 = false;
                                if (phpClass2.findOwnMethodByName((CharSequence)method.getName()) != null) continue;
                                bl = false;
                                break block9;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        return;
                    }
                }
                if (!PhpAddOverrideAttributeInspectionKt.hasSuperMethodToOverride(method) && !PhpAddOverrideAttributeInspectionKt.hasSuperPropertyHook(method)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{PhpRemoveOverrideAttributeQuickFix.INSTANCE};
                    this.$holder.registerProblem(attribute.getParent(), PhpBundle.message("inspection.method.does.not.override.super", new Object[0]), localQuickFixArray);
                }
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP830;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/lang/inspections/attributes/PhpOverriddenMethodExistsInspection$PhpRemoveOverrideAttributeQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.php.impl"})
    private static final class PhpRemoveOverrideAttributeQuickFix
    implements LocalQuickFix {
        @NotNull
        public static final PhpRemoveOverrideAttributeQuickFix INSTANCE = new PhpRemoveOverrideAttributeQuickFix();

        private PhpRemoveOverrideAttributeQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.remove.override.attribute", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            descriptor.getPsiElement().delete();
        }
    }
}

