/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpMakeClassAbstractQuickFix
extends PsiUpdateModCommandQuickFix {
    private final String myClassName;

    public PhpMakeClassAbstractQuickFix(String className) {
        this.myClassName = className;
    }

    @NotNull
    public String getName() {
        String string = PhpBundle.message("intention.name.make.abstract", this.myClassName);
        if (string == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.make.class.abstract.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PhpClass phpClass;
        if (project == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpMakeClassAbstractQuickFix.$$$reportNull$$$0(4);
        }
        if ((phpClass = PhpPsiUtil.getParentOfClass(element, false, PhpClass.class)) == null) {
            return;
        }
        PsiElement text = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.kwABSTRACT, "<?php abstract class A{}");
        phpClass.addBefore(text, PhpPsiUtil.getChildOfType((PsiElement)phpClass, PhpTokenTypes.kwCLASS));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpMakeClassAbstractQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpMakeClassAbstractQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

