/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRedundantAssignmentToPromotedFieldInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpStrFunctionsInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArrayAppendUsingCountInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayAppendUsingCountInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpArrayAccessExpression(ArrayAccessExpression arrayAccessExpression) {
                AssignmentExpression assignment = (AssignmentExpression)ObjectUtils.tryCast((Object)arrayAccessExpression.getParent(), AssignmentExpression.class);
                if (assignment == null || assignment.getVariable() == null || assignment.getValue() == null) {
                    return;
                }
                if (!PhpRedundantAssignmentToPromotedFieldInspection.isSingleStatement(assignment.getParent())) {
                    return;
                }
                ArrayIndex index = arrayAccessExpression.getIndex();
                if (index == null) {
                    return;
                }
                PhpPsiElement array = arrayAccessExpression.getValue();
                if (!(array instanceof Variable) && !(array instanceof FieldReference)) {
                    return;
                }
                FunctionReference reference = (FunctionReference)ObjectUtils.tryCast((Object)index.getValue(), FunctionReference.class);
                if (reference == null || !PhpArrayAppendUsingCountInspection.isConvertibleCountCall(reference, (PsiElement)array)) {
                    return;
                }
                holder.problem((PsiElement)arrayAccessExpression, PhpBundle.message("inspection.message.count.used.as.array.index.to.append.element", new Object[0])).fix((ModCommandAction)new PhpReplaceWithEmptyIndexOperator(assignment, (PsiElement)array)).register();
            }
        };
    }

    private static boolean isConvertibleCountCall(FunctionReference reference, PsiElement array) {
        if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "count")) {
            return false;
        }
        PsiElement[] parameters = reference.getParameters();
        if (parameters.length == 1) {
            return PhpPsiUtil.areElementsEquivalent(parameters[0], array);
        }
        if (parameters.length == 2) {
            return PhpPsiUtil.areElementsEquivalent(parameters[0], array) && PhpArrayAppendUsingCountInspection.isCountNormalMode(parameters[1]);
        }
        return false;
    }

    private static boolean isCountNormalMode(PsiElement parameter) {
        return PhpStrFunctionsInspection.isNumber(parameter, "0") || parameter instanceof ConstantReference && "\\COUNT_NORMAL".equals(((ConstantReference)parameter).getFQN());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpArrayAppendUsingCountInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithEmptyIndexOperator
    extends PsiUpdateModCommandAction<AssignmentExpression> {
        private final String myAssignmentText;

        private PhpReplaceWithEmptyIndexOperator(AssignmentExpression assignment, PsiElement array) {
            super((PsiElement)assignment);
            this.myAssignmentText = assignment.getValue() == null ? "" : String.format("%s[] = %s", array.getText(), assignment.getValue().getText());
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull AssignmentExpression element) {
            if (context == null) {
                PhpReplaceWithEmptyIndexOperator.$$$reportNull$$$0(0);
            }
            if (element == null) {
                PhpReplaceWithEmptyIndexOperator.$$$reportNull$$$0(1);
            }
            return Presentation.of((String)PhpBundle.message("intention.family.name.replace.with", this.myAssignmentText));
        }

        protected void invoke(@NotNull ActionContext context, @NotNull AssignmentExpression assignment, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceWithEmptyIndexOperator.$$$reportNull$$$0(2);
            }
            if (assignment == null) {
                PhpReplaceWithEmptyIndexOperator.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithEmptyIndexOperator.$$$reportNull$$$0(4);
            }
            assert (StringUtil.isNotEmpty((String)this.myAssignmentText));
            assignment.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(context.project(), AssignmentExpression.class, this.myAssignmentText));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.array.assignment", new Object[0]);
            if (string == null) {
                PhpReplaceWithEmptyIndexOperator.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpArrayAppendUsingCountInspection$PhpReplaceWithEmptyIndexOperator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpArrayAppendUsingCountInspection$PhpReplaceWithEmptyIndexOperator";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

