/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExpressionWithSameOperandsInspection
extends PhpInspection {
    private static final BiPredicate<PsiReference, PsiReference> CONSIDER_FUNCTION_REFERENCES_DIFFERENT_COMPARATOR = (o1, o2) -> {
        FunctionReference f2;
        FunctionReference f1;
        return !(o1 instanceof FunctionReference && PhpSideEffectDetector.canContainSideEffect((PsiElement)(f1 = (FunctionReference)o1)) || o2 instanceof FunctionReference && PhpSideEffectDetector.canContainSideEffect((PsiElement)(f2 = (FunctionReference)o2)));
    };
    public static final TokenSet EXPRESSION_SUPPOSED_FOR_DIFFERENT_OPERANDS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsCOMPARE_OPS, PhpTokenTypes.tsLOGICAL_OPS, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opMINUS, PhpTokenTypes.opDIV, PhpTokenTypes.opCOALESCE})});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExpressionWithSameOperandsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                IElementType type = expression.getOperationType();
                if (EXPRESSION_SUPPOSED_FOR_DIFFERENT_OPERANDS.contains(type)) {
                    this.checkSameOperands((PsiElement)expression, expression.getLeftOperand(), expression.getRightOperand(), CONSIDER_FUNCTION_REFERENCES_DIFFERENT_COMPARATOR);
                }
            }

            private void checkSameOperands(PsiElement expression, PsiElement first, PsiElement second, @Nullable BiPredicate<PsiReference, PsiReference> referenceComparator) {
                first = PhpPsiUtil.unparenthesize(first);
                second = PhpPsiUtil.unparenthesize(second);
                if (first != null && second != null && (referenceComparator != null && PsiEquivalenceUtil.areEquivalent((PsiElement)first, (PsiElement)second, referenceComparator, null, null, (boolean)false) || referenceComparator == null && PsiEquivalenceUtil.areEquivalent((PsiElement)first, (PsiElement)second, null, (boolean)false))) {
                    holder.registerProblem(expression, PhpExpressionWithSameOperandsInspection.getMessage(), new LocalQuickFix[0]);
                }
            }

            public void visitPhpTernaryExpression(TernaryExpression expression) {
                this.checkSameOperands((PsiElement)expression, (PsiElement)expression.getTrueVariant(), (PsiElement)expression.getFalseVariant(), null);
            }
        };
    }

    @InspectionMessage
    private static String getMessage() {
        return PhpBundle.message("inspection.expression.have.same.operands", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpExpressionWithSameOperandsInspection", "buildVisitor"));
    }
}

