/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpFormatCallWithSingleArgumentInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFormatCallWithSingleArgumentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunctionCall(FunctionReference reference) {
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                PsiElement[] arguments = reference.getParameters();
                if (arguments.length != 1 || PhpCodeInsightUtil.isUnpackedArgument(arguments[0])) {
                    return;
                }
                if (PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "sprintf") || PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "vsprintf")) {
                    holder.registerProblem(nameNode.getPsi(), PhpBundle.message("inspection.message.with.single.string.argument", reference.getName()), new LocalQuickFix[]{PhpUnwrapFunctionCallQuickFix.INSTANCE});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpFormatCallWithSingleArgumentInspection", "buildVisitor"));
    }

    private static class PhpUnwrapFunctionCallQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpUnwrapFunctionCallQuickFix();

        private PhpUnwrapFunctionCallQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.unwrap.function.call", new Object[0]);
            if (string == null) {
                PhpUnwrapFunctionCallQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            FunctionReference functionCall;
            PsiElement parameter;
            if (project == null) {
                PhpUnwrapFunctionCallQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpUnwrapFunctionCallQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUnwrapFunctionCallQuickFix.$$$reportNull$$$0(3);
            }
            if ((parameter = (functionCall = (FunctionReference)element.getParent()).getParameter(0)) != null) {
                functionCall.replace(parameter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpFormatCallWithSingleArgumentInspection$PhpUnwrapFunctionCallQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpFormatCallWithSingleArgumentInspection$PhpUnwrapFunctionCallQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

