/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpLoopCanBeReplacedWithStdFunctionCallsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLoopCanBeReplacedWithStdFunctionCallsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpForeach(ForeachStatement foreach) {
                if (foreach.getArray() == null) {
                    return;
                }
                if (foreach.getKey() == null && foreach.getVariables().size() > 1) {
                    return;
                }
                If ifStatement = (If)ObjectUtils.tryCast((Object)PhpInvertIfIntention.getOnlyStatement((PsiElement)foreach.getStatement()), If.class);
                if (ifStatement == null || ifStatement.getElseBranch() != null || ifStatement.getElseIfBranches().length != 0) {
                    return;
                }
                BinaryExpression condition = (BinaryExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), BinaryExpression.class);
                if (condition == null || condition.getLeftOperand() == null || condition.getRightOperand() == null) {
                    return;
                }
                IElementType operationType = condition.getOperationType();
                if (operationType != PhpTokenTypes.opEQUAL && operationType != PhpTokenTypes.opIDENTICAL) {
                    return;
                }
                PhpReturn phpReturn = (PhpReturn)ObjectUtils.tryCast((Object)PhpInvertIfIntention.getOnlyStatement((PsiElement)ifStatement.getStatement()), PhpReturn.class);
                if (phpReturn == null) {
                    return;
                }
                Variable loopVariable = foreach.getKey() != null ? foreach.getKey() : foreach.getValue();
                boolean leftOpIsLoopVariable = PhpPsiUtil.areElementsEquivalent((PsiElement)loopVariable, condition.getLeftOperand());
                if (!leftOpIsLoopVariable && !PhpPsiUtil.areElementsEquivalent((PsiElement)loopVariable, condition.getRightOperand())) {
                    return;
                }
                if (PhpLoopCanBeReplacedWithStdFunctionCallsInspection.hasDependenciesOnForeachVariables(foreach, phpReturn)) {
                    return;
                }
                if (!PhpType.isArray((PhpType)PhpType.global((PsiElement[])new PsiElement[]{foreach.getArray()}))) {
                    return;
                }
                String functionName = foreach.getKey() != null ? "array_key_exists" : "in_array";
                PsiElement needle = leftOpIsLoopVariable ? condition.getRightOperand() : condition.getLeftOperand();
                holder.registerProblem(foreach.getFirstChild(), PhpBundle.message("inspection.message.loop.can.be.replaced.with.0", functionName), new LocalQuickFix[]{new PhpReplaceWithStdFunctionCallFix(functionName, needle, foreach.getArray(), phpReturn, foreach.getKey() == null && operationType == PhpTokenTypes.opIDENTICAL)});
            }
        };
    }

    private static boolean hasDependenciesOnForeachVariables(@NotNull ForeachStatement foreach, @NotNull PhpReturn phpReturn) {
        PhpInstruction instruction;
        if (foreach == null) {
            PhpLoopCanBeReplacedWithStdFunctionCallsInspection.$$$reportNull$$$0(1);
        }
        if (phpReturn == null) {
            PhpLoopCanBeReplacedWithStdFunctionCallsInspection.$$$reportNull$$$0(2);
        }
        if ((instruction = PhpUndefinedClassInspection.findNearestInstruction((PsiElement)phpReturn)) == null) {
            return false;
        }
        final Set foreachVariableNames = ContainerUtil.map2Set((Collection)foreach.getVariables(), PhpNamedElement::getName);
        final Ref hasAccess = new Ref((Object)false);
        PhpControlFlowUtil.processSuccessors(instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                CharSequence variableName = instruction.getVariableName();
                if (foreachVariableNames.contains(variableName)) {
                    hasAccess.set((Object)true);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)hasAccess.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreach";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpReturn";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpLoopCanBeReplacedWithStdFunctionCallsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasDependenciesOnForeachVariables";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpReplaceWithStdFunctionCallFix
    extends PsiUpdateModCommandQuickFix {
        private final String myFunctionName;
        private final String myNeedle;
        private final String myHaystack;
        private final String myReturn;
        private final boolean myStrict;

        private PhpReplaceWithStdFunctionCallFix(@NotNull String functionName, @NotNull PsiElement needle, @NotNull PsiElement haystack, @NotNull PhpReturn phpReturn, boolean strict) {
            if (functionName == null) {
                PhpReplaceWithStdFunctionCallFix.$$$reportNull$$$0(0);
            }
            if (needle == null) {
                PhpReplaceWithStdFunctionCallFix.$$$reportNull$$$0(1);
            }
            if (haystack == null) {
                PhpReplaceWithStdFunctionCallFix.$$$reportNull$$$0(2);
            }
            if (phpReturn == null) {
                PhpReplaceWithStdFunctionCallFix.$$$reportNull$$$0(3);
            }
            this.myFunctionName = functionName;
            this.myNeedle = needle.getText();
            this.myHaystack = haystack.getText();
            this.myReturn = phpReturn.getText();
            this.myStrict = strict;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myFunctionName + "()");
            if (string == null) {
                PhpReplaceWithStdFunctionCallFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithStdFunctionCallFix.$$$reportNull$$$0(5);
            }
            if (element == null) {
                PhpReplaceWithStdFunctionCallFix.$$$reportNull$$$0(6);
            }
            if (updater == null) {
                PhpReplaceWithStdFunctionCallFix.$$$reportNull$$$0(7);
            }
            String pattern = this.myStrict ? "if (%s(%s, %s, true)) { %s }" : "if (%s(%s, %s)) { %s }";
            String replacement = String.format(pattern, this.myFunctionName, this.myNeedle, this.myHaystack, this.myReturn);
            If ifStatement = PhpPsiElementFactory.createPhpPsiFromText(project, If.class, replacement);
            element.getParent().replace((PsiElement)ifStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "needle";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "haystack";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpReturn";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpLoopCanBeReplacedWithStdFunctionCallsInspection$PhpReplaceWithStdFunctionCallFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpLoopCanBeReplacedWithStdFunctionCallsInspection$PhpReplaceWithStdFunctionCallFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

