/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpPregMatchWithoutEffectiveRegexpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpPregSplitWithoutRegExpInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPregSplitWithoutRegExpInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunctionCall(FunctionReference reference) {
                if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "preg_split")) {
                    return;
                }
                PsiElement[] parameters = reference.getParameters();
                ParameterList parameterList = reference.getParameterList();
                if (parameterList == null || parameters.length > 3) {
                    return;
                }
                StringLiteralExpression pattern = (StringLiteralExpression)ObjectUtils.tryCast((Object)parameterList.getParameter("pattern", 0), StringLiteralExpression.class);
                PsiElement subject = parameterList.getParameter("subject", 1);
                if (pattern == null || subject == null) {
                    return;
                }
                Integer limit = PhpPregSplitWithoutRegExpInspection.getLimit(parameterList);
                if (limit == null) {
                    return;
                }
                RegExpBranch branch = PhpPregMatchWithoutEffectiveRegexpInspection.getBranch(pattern);
                if (branch == null) {
                    return;
                }
                String regExp = PhpPregSplitWithoutRegExpInspection.getSimpleText(branch.getAtoms(), pattern);
                if (regExp == null) {
                    return;
                }
                holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.php.preg.split.can.be.replaced.with.explode", new Object[0]), new LocalQuickFix[]{new PhpPregSplitReplaceWithExplodeQuickFix(regExp, subject.getText(), limit)});
            }
        };
    }

    @Nullable
    private static String getSimpleText(RegExpAtom[] atoms, StringLiteralExpression parameter) {
        if (atoms.length > 0 && ContainerUtil.and((Object[])atoms, PhpPregMatchWithoutEffectiveRegexpInspection::isSimpleCharacter)) {
            String quote = parameter.isSingleQuote() ? "'" : "\"";
            return quote + parameter.getContents().substring(1, parameter.getContents().length() - 1) + quote;
        }
        return null;
    }

    @Nullable
    private static Integer getLimit(@NotNull ParameterList parameterList) {
        PsiElement flags;
        if (parameterList == null) {
            PhpPregSplitWithoutRegExpInspection.$$$reportNull$$$0(1);
        }
        PsiElement limit = parameterList.getParameter("limit", 2);
        if (parameterList instanceof ParameterListImpl && (flags = ((ParameterListImpl)parameterList).getParameter("flags")) != null) {
            return null;
        }
        if (limit == null) {
            return Integer.MAX_VALUE;
        }
        if (!PhpType.global((PsiElement[])new PsiElement[]{limit}).equals((Object)PhpType.INT)) {
            return null;
        }
        try {
            int limitInt = Integer.parseInt(limit.getText());
            if (limitInt == 0 || limitInt == -1) {
                return Integer.MAX_VALUE;
            }
            return Math.max(limitInt, 0);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregSplitWithoutRegExpInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLimit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpPregSplitReplaceWithExplodeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myPatternText;
        private final String mySubjectText;
        private final int myLimit;

        private PhpPregSplitReplaceWithExplodeQuickFix(String patternText, String subjectText, int limit) {
            this.myPatternText = patternText;
            this.mySubjectText = subjectText;
            this.myLimit = limit;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.str.function.call", "explode");
            if (string == null) {
                PhpPregSplitReplaceWithExplodeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            FunctionReference reference;
            if (project == null) {
                PhpPregSplitReplaceWithExplodeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpPregSplitReplaceWithExplodeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpPregSplitReplaceWithExplodeQuickFix.$$$reportNull$$$0(3);
            }
            if ((reference = (FunctionReference)ObjectUtils.tryCast((Object)element, FunctionReference.class)) == null) {
                return;
            }
            String text = this.myLimit == Integer.MAX_VALUE ? String.format("explode(%s, %s)", this.myPatternText, this.mySubjectText) : String.format("explode(%s, %s, %s)", this.myPatternText, this.mySubjectText, this.myLimit);
            reference.replace((PsiElement)PhpPsiElementFactory.createFunctionReference(project, text));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregSplitWithoutRegExpInspection$PhpPregSplitReplaceWithExplodeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPregSplitWithoutRegExpInspection$PhpPregSplitReplaceWithExplodeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

