/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConstructorCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class PhpPrivateMethodsUsagesProcessInspectionBase<K, V>
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPrivateMethodsUsagesProcessInspectionBase.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                if (clazz.getTraitNames().length > 0 || clazz.isTrait()) {
                    return;
                }
                Collection candidateMethods = Arrays.stream(clazz.getOwnMethods()).filter(m -> !(m instanceof PhpDocMethod)).filter(m -> m.getAccess().isPrivate()).filter(m -> PhpPrivateMethodsUsagesProcessInspectionBase.this.isMethodSuitable((Method)m)).collect(Collectors.toSet());
                PhpPrivateMethodsUsagesProcessInspectionBase.this.processAllValuesFromMethodCalls(PhpPrivateMethodsUsagesProcessInspectionBase.this.getArgumentValues(clazz, candidateMethods), candidateMethods, holder);
            }
        };
    }

    protected boolean isMethodSuitable(Method method) {
        return true;
    }

    protected abstract void putValuesFromPrivateMethodCalls(MultiMap<K, V> var1, @NotNull PhpReference var2, Method var3, List<PsiElement> var4);

    protected abstract MultiMap<K, V> createInitialMap(PhpClass var1, Collection<Method> var2);

    protected abstract void processAllValuesFromMethodCalls(MultiMap<K, V> var1, Collection<Method> var2, @NotNull ProblemsHolder var3);

    @NotNull
    private MultiMap<K, V> getArgumentValues(PhpClass clazz, Collection<Method> candidateMethods) {
        MultiMap<K, V> argumentValues = this.createInitialMap(clazz, candidateMethods);
        for (Method method : clazz.getOwnMethods()) {
            if (method instanceof PhpDocMethod) continue;
            this.fillArgumentValues(method, argumentValues, candidateMethods);
        }
        MultiMap<K, V> multiMap = argumentValues;
        if (multiMap == null) {
            PhpPrivateMethodsUsagesProcessInspectionBase.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    private void fillArgumentValues(Method method, final MultiMap<K, V> values, final Collection<Method> candidateMethods) {
        PhpControlFlowUtil.processSuccessors((PhpInstruction)method.getControlFlow().getEntryPoint(), false, new PhpControlFlowUtil.PhpClosureVisitingInstructionProcessor(){

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                MethodReference methodReference = (MethodReference)ObjectUtils.tryCast((Object)instruction.getFunctionReference(), MethodReference.class);
                if (methodReference == null) {
                    return true;
                }
                if (!ContainerUtil.exists((Iterable)candidateMethods, m -> PhpLangUtil.equalsMethodNames(m.getName(), methodReference.getName()))) {
                    return true;
                }
                return this.doCheck((PhpReference)methodReference, Arrays.asList(methodReference.getParameters()));
            }

            public boolean processConstructorCallInstruction(PhpConstructorCallInstruction instruction) {
                NewExpression newExpression = instruction.getNewExpression();
                ClassReference classReference = newExpression.getClassReference();
                if (classReference == null) {
                    return true;
                }
                return this.doCheck((PhpReference)classReference, Arrays.asList(newExpression.getParameters()));
            }

            private boolean doCheck(@NotNull PhpReference methodReference, List<PsiElement> arguments) {
                Method resolvedMethod;
                if (methodReference == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((resolvedMethod = (Method)ObjectUtils.tryCast((Object)methodReference.resolve(), Method.class)) == null || !candidateMethods.contains(resolvedMethod)) {
                    return true;
                }
                PhpPrivateMethodsUsagesProcessInspectionBase.this.putValuesFromPrivateMethodCalls(values, methodReference, resolvedMethod, arguments);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReference", "com/jetbrains/php/lang/inspections/codeSmell/PhpPrivateMethodsUsagesProcessInspectionBase$2", "doCheck"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPrivateMethodsUsagesProcessInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpPrivateMethodsUsagesProcessInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

