/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpDeprecationInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunctionCall(FunctionReference reference) {
                int firstUnpackedArgumentIndex;
                List<PsiElement> arguments = Arrays.asList(reference.getParameters());
                ArrayCreationExpression firstUnpackedArgument = PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.getUnpackedLiteral(arguments, firstUnpackedArgumentIndex = ContainerUtil.indexOf(arguments, PhpPsiUtil::isArgumentUnpacking));
                if (firstUnpackedArgument != null) {
                    if (!ArrayCreationExpressionImpl.children(firstUnpackedArgument).anyMatch(ArrayHashElement.class::isInstance) && PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.spreadArgumentsFromArrayDontFollowPositional(firstUnpackedArgument, arguments, firstUnpackedArgumentIndex)) {
                        Collection functions = reference.multiResolveStrict(Function.class);
                        if (firstUnpackedArgumentIndex < arguments.size() - 1 || PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.argumentMayBeGroupedWithSpread(arguments, firstUnpackedArgumentIndex, functions)) {
                            if (isOnTheFly) {
                                holder.registerProblem(firstUnpackedArgument.getPrevSibling(), PhpBundle.message("inspection.message.spread.operator.can.be.unwrapped", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{PhpUnwrapSpreadOperatorQuickFix.INSTANCE});
                            }
                        } else {
                            holder.registerProblem(firstUnpackedArgument.getPrevSibling(), PhpBundle.message("inspection.message.spread.operator.over.literal.unnecessary.for.arguments.resolved.to.variadic.parameter", new Object[0]), new LocalQuickFix[]{PhpUnwrapSpreadOperatorQuickFix.INSTANCE});
                        }
                    }
                }
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.visitPhpFunctionCall((FunctionReference)reference);
            }
        };
    }

    private static boolean argumentMayBeGroupedWithSpread(List<PsiElement> arguments, int firstUnpackedArgumentIndex, Collection<Function> functions) {
        return IntStream.range(0, firstUnpackedArgumentIndex).anyMatch(i -> PhpPsiUtil.isArgumentUnpacking((PsiElement)arguments.get(i)) || PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.resolvedToVarArgParameter(arguments, i, functions));
    }

    @Nullable
    private static ArrayCreationExpression getUnpackedLiteral(List<PsiElement> arguments, int index) {
        return index >= 0 ? (ArrayCreationExpression)ObjectUtils.tryCast((Object)arguments.get(index), ArrayCreationExpression.class) : null;
    }

    private static boolean resolvedToVarArgParameter(List<PsiElement> arguments, int index, Collection<Function> functions) {
        return index >= 0 && !functions.isEmpty() && ContainerUtil.all(functions, f -> PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.resolvedToVarArgParameter(f, arguments, index));
    }

    private static boolean spreadArgumentsFromArrayDontFollowPositional(ArrayCreationExpression argument, List<PsiElement> arguments, int arrayArgumentIndex) {
        List arrayValues = ((ArrayCreationExpressionImpl)argument).values().collect(Collectors.toList());
        return PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.spreadArgumentsDontFollowPositional(arguments, arrayArgumentIndex, arrayValues);
    }

    public static boolean spreadArgumentsDontFollowPositional(List<PsiElement> arguments, int argumentIndex, List<? extends PsiElement> valuesFromArgument) {
        int firstArrayUnpackedArgument = ContainerUtil.indexOf(valuesFromArgument, PhpPsiUtil::isArgumentUnpacking);
        if (firstArrayUnpackedArgument < 0) {
            return true;
        }
        return PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.allFollowingElementsAreUnpacked(valuesFromArgument, firstArrayUnpackedArgument) && PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection.allFollowingElementsAreUnpacked(arguments, argumentIndex);
    }

    private static boolean allFollowingElementsAreUnpacked(List<? extends PsiElement> elements, int index) {
        return IntStream.range(index + 1, elements.size()).allMatch(i -> PhpPsiUtil.isArgumentUnpacking((PsiElement)elements.get(i)));
    }

    private static boolean resolvedToVarArgParameter(Function f, List<PsiElement> arguments, int index) {
        List<Parameter> parameters = Arrays.asList(f.getParameters());
        int i = PhpDeprecationInspection.resolveParameterIndex(arguments, parameters, index);
        return i >= 0 && parameters.get(i).isVariadic();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection", "buildVisitor"));
    }

    private static class PhpUnwrapSpreadOperatorQuickFix
    extends PsiUpdateModCommandQuickFix {
        public static final LocalQuickFix INSTANCE = new PhpUnwrapSpreadOperatorQuickFix();

        private PhpUnwrapSpreadOperatorQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.unwrap.spread.operator", new Object[0]);
            if (string == null) {
                PhpUnwrapSpreadOperatorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpUnwrapSpreadOperatorQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpUnwrapSpreadOperatorQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUnwrapSpreadOperatorQuickFix.$$$reportNull$$$0(3);
            }
            ArrayCreationExpressionImpl element = (ArrayCreationExpressionImpl)startElement.getNextSibling();
            PhpUnwrapSpreadOperatorQuickFix.copyArrayValuesBeforeLiteral(project, element);
            PhpUnwrapSpreadOperatorQuickFix.deleteUnpackedArgument(element);
        }

        private static void deleteUnpackedArgument(ArrayCreationExpressionImpl element) {
            element.getParent().deleteChildRange(element.getPrevSibling(), (PsiElement)element);
        }

        private static void copyArrayValuesBeforeLiteral(@NotNull Project project, ArrayCreationExpressionImpl element) {
            TextRange valuesRange;
            if (project == null) {
                PhpUnwrapSpreadOperatorQuickFix.$$$reportNull$$$0(4);
            }
            if ((valuesRange = PhpUnwrapSpreadOperatorQuickFix.getValuesRange(element)) == null) {
                return;
            }
            ParameterList copiedArguments = PhpPsiElementFactory.createArgumentList(project, valuesRange.substring(element.getText()));
            Object argument = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element.getPrevSibling(), true);
            if (argument == null) {
                argument = element;
            }
            for (PsiElement child = copiedArguments.getFirstChild(); child != null; child = child.getNextSibling()) {
                argument = argument.getParent().addAfter(child, argument);
            }
        }

        @Nullable
        private static TextRange getValuesRange(ArrayCreationExpressionImpl element) {
            ImmutableList elements = ArrayCreationExpressionImpl.children(element).toList();
            PhpPsiElement firstItem = (PhpPsiElement)ContainerUtil.getFirstItem((List)elements);
            PhpPsiElement lastItem = (PhpPsiElement)ContainerUtil.getLastItem((List)elements);
            if (firstItem == null || lastItem == null) {
                return null;
            }
            return TextRange.create((int)firstItem.getTextRangeInParent().getStartOffset(), (int)lastItem.getTextRangeInParent().getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection$PhpUnwrapSpreadOperatorQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessarySpreadOperatorForFunctionCallArgumentInspection$PhpUnwrapSpreadOperatorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "copyArrayValuesBeforeLiteral";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

