/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeSmell;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpUnnecessaryStaticReferenceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryStaticReferenceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpClassReference(ClassReference classReference) {
                if (!PhpAnnotatorVisitor.isStaticKeywordClassReference(classReference)) {
                    return;
                }
                PhpClass containingClass = PhpPsiUtil.getParentOfClass((PsiElement)classReference, PhpClass.class);
                if (containingClass == null || !containingClass.isFinal()) {
                    return;
                }
                holder.registerProblem((PsiElement)classReference, PhpBundle.message("inspection.message.redundant.static.in.final.class", new Object[0]), new LocalQuickFix[]{new PhpReplaceWithCurrentClassNameQuickFix(containingClass.getName())});
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryStaticReferenceInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithCurrentClassNameQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String myClassName;

        private PhpReplaceWithCurrentClassNameQuickFix(@NotNull String className) {
            if (className == null) {
                PhpReplaceWithCurrentClassNameQuickFix.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myClassName);
            if (string == null) {
                PhpReplaceWithCurrentClassNameQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithCurrentClassNameQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpReplaceWithCurrentClassNameQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceWithCurrentClassNameQuickFix.$$$reportNull$$$0(4);
            }
            element.replace((PsiElement)PhpPsiElementFactory.createClassReference(project, this.myClassName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryStaticReferenceInspection$PhpReplaceWithCurrentClassNameQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeSmell/PhpUnnecessaryStaticReferenceInspection$PhpReplaceWithCurrentClassNameQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

