/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.google.common.base.Predicates;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpRecursiveCallLineMarkerProvider;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticProcessor;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpMethodMayBeStaticInspection
extends PhpInspection {
    public static final MakeMethodStaticQuickFix MAKE_METHOD_STATIC_FIX = new MakeMethodStaticQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMethodMayBeStaticInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpClass(PhpClass clazz) {
                if (clazz.isTrait() || clazz.isInterface() || clazz.isAnonymous()) {
                    return;
                }
                Set<String> subAndSuperClassesMethodNames = PhpMethodMayBeStaticInspection.collectSubAndSuperClassesMethodNames(clazz);
                for (Method method : clazz.getOwnMethods()) {
                    PsiElement nameIdentifier;
                    if (subAndSuperClassesMethodNames.contains(method.getName()) || (nameIdentifier = method.getNameIdentifier()) == null || !PhpMethodMayBeStaticInspection.methodMayBeStatic(method)) continue;
                    holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.method.may.be.static", new Object[0]), new LocalQuickFix[]{MAKE_METHOD_STATIC_FIX});
                }
            }
        };
    }

    private static Set<String> collectSubAndSuperClassesMethodNames(PhpClass clazz) {
        HashSet subAndSuperClasses = new HashSet(PhpIndex.getInstance((Project)clazz.getProject()).getAllSubclasses(clazz.getFQN()));
        PhpClassHierarchyUtils.processSupers((PhpClass)clazz, (boolean)false, (boolean)true, (Processor)new CommonProcessors.CollectProcessor(subAndSuperClasses));
        return subAndSuperClasses.stream().filter(Predicates.not(PhpClass::isTrait)).flatMap(cls -> Arrays.stream(cls.getOwnMethods())).map(PhpNamedElement::getName).collect(PhpStringUtil.toCaseInsensitiveSet());
    }

    public static boolean methodMayBeStatic(@NotNull Method method) {
        if (method == null) {
            PhpMethodMayBeStaticInspection.$$$reportNull$$$0(1);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> CachedValueProvider.Result.create((Object)PhpMethodMayBeStaticInspection.methodMayBeStaticInner(method), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean methodMayBeStaticInner(@NotNull Method method) {
        if (method == null) {
            PhpMethodMayBeStaticInspection.$$$reportNull$$$0(2);
        }
        if (method instanceof PhpDocMethod) {
            return false;
        }
        if (PhpLangUtil.isMagicMethod(method.getNameCS())) {
            return false;
        }
        if (method.isStatic() || method.isAbstract() || method.getAccess() == PhpModifier.Access.PROTECTED) {
            return false;
        }
        if (method.getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
            return false;
        }
        MyMethodMayBeStaticInstructionProcessor methodMayBeStaticInstructionProcessor = new MyMethodMayBeStaticInstructionProcessor(method);
        for (PhpInstruction instruction : method.getControlFlow().getInstructions()) {
            if (instruction.process((PhpInstructionProcessor)methodMayBeStaticInstructionProcessor)) continue;
            return false;
        }
        return true;
    }

    @IntentionFamilyName
    public static String getMakeMethodStaticFixName() {
        return PhpBundle.message("quickfix.make.method.static", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpMethodMayBeStaticInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "methodMayBeStatic";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "methodMayBeStaticInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyMethodMayBeStaticInstructionProcessor
    extends PhpInstructionProcessor {
        private final Method myMethod;

        private MyMethodMayBeStaticInstructionProcessor(Method method) {
            this.myMethod = method;
        }

        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
            if (PhpLangUtil.isThisReference(instruction.getVariableName())) {
                PsiElement parent = instruction.getAnchor().getParent();
                if (parent instanceof MethodReference) {
                    return PhpRecursiveCallLineMarkerProvider.isRecursiveMethodCall((FunctionReference)((MethodReference)parent));
                }
                return false;
            }
            return super.processAccessVariableInstruction(instruction);
        }

        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
            FunctionReference functionReference = instruction.getFunctionReference();
            if (functionReference instanceof MethodReference) {
                return this.isReferenceToStaticMethod((MethodReference)functionReference);
            }
            return super.processPhpCallInstruction(instruction);
        }

        private boolean isReferenceToStaticMethod(MethodReference functionReference) {
            PsiElement resolvedRef = functionReference.resolve();
            return !(resolvedRef instanceof Method) || ((Method)resolvedRef).isStatic() || resolvedRef == this.myMethod;
        }
    }

    private static class MakeMethodStaticQuickFix
    extends ModCommandQuickFix {
        private MakeMethodStaticQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpMethodMayBeStaticInspection.getMakeMethodStaticFixName();
            if (string == null) {
                MakeMethodStaticQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Method method;
            if (project == null) {
                MakeMethodStaticQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MakeMethodStaticQuickFix.$$$reportNull$$$0(2);
            }
            if ((method = PhpPsiUtil.getParentOfClass(descriptor.getPsiElement(), false, Method.class)) == null) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    MakeMethodStaticQuickFix.$$$reportNull$$$0(3);
                }
                return modCommand;
            }
            Map referenceMap = StreamEx.of(PhpMakeStaticProcessor.findReferences(method)).select(MethodReference.class).mapToEntry(ref -> PhpMakeStaticProcessor.createStaticReplacement(project, ref)).nonNullValues().toMap();
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)method, (writableMethod, updater) -> {
                Map writableRefMap = EntryStream.of((Map)referenceMap).mapKeys(arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0)).toMap();
                writableRefMap.forEach(PsiElement::replace);
                writableMethod.replace((PsiElement)PhpMakeStaticProcessor.makeStaticMethod(project, writableMethod));
            });
            if (modCommand == null) {
                MakeMethodStaticQuickFix.$$$reportNull$$$0(4);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpMethodMayBeStaticInspection$MakeMethodStaticQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpMethodMayBeStaticInspection$MakeMethodStaticQuickFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

