/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPowCallCanBeReplacedWithOperatorInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPowCallCanBeReplacedWithOperatorInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunctionCall(FunctionReference reference) {
                if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "pow")) {
                    return;
                }
                if (reference.getParameters().length != 2) {
                    return;
                }
                holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.php.pow.call.can.be.replace.with.pow.operator", new Object[0]), new LocalQuickFix[]{PhpReplacePowCallWithOperatorQuickFix.INSTANCE});
            }
        };
    }

    @Nullable
    private static PsiElement parenthesizeIfNeeded(@Nullable PsiElement argument) {
        if (argument instanceof ParenthesizedExpression) {
            return argument;
        }
        if (argument instanceof StringLiteralExpression) {
            return argument;
        }
        if (argument instanceof UnaryExpression) {
            if (PhpPsiUtil.isOfType(((UnaryExpression)argument).getOperation(), PhpTokenTypes.opBIT_NOT)) {
                return PhpCodeEditUtil.parenthesize(argument);
            }
            return argument;
        }
        if (argument instanceof TernaryExpression || argument instanceof BinaryExpression) {
            return PhpCodeEditUtil.parenthesize(argument);
        }
        return argument;
    }

    private static boolean isNegativeUnaryExp(@Nullable PsiElement argument) {
        return argument instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)argument).getOperation(), PhpTokenTypes.opMINUS);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP560;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpPowCallCanBeReplacedWithOperatorInspection", "buildVisitor"));
    }

    static class PhpReplacePowCallWithOperatorQuickFix
    extends PsiUpdateModCommandQuickFix {
        static PhpReplacePowCallWithOperatorQuickFix INSTANCE = new PhpReplacePowCallWithOperatorQuickFix();

        PhpReplacePowCallWithOperatorQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.with.pow.operator", new Object[0]);
            if (string == null) {
                PhpReplacePowCallWithOperatorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            FunctionReference functionReference;
            if (project == null) {
                PhpReplacePowCallWithOperatorQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplacePowCallWithOperatorQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplacePowCallWithOperatorQuickFix.$$$reportNull$$$0(3);
            }
            if ((functionReference = (FunctionReference)ObjectUtils.tryCast((Object)element, FunctionReference.class)) == null) {
                return;
            }
            if (functionReference.getParameters().length != 2) {
                return;
            }
            PsiElement firstArg = PhpPowCallCanBeReplacedWithOperatorInspection.parenthesizeIfNeeded(functionReference.getParameter(0));
            firstArg = PhpPowCallCanBeReplacedWithOperatorInspection.isNegativeUnaryExp(firstArg) ? PhpCodeEditUtil.parenthesize(firstArg) : firstArg;
            PsiElement secondArg = PhpPowCallCanBeReplacedWithOperatorInspection.parenthesizeIfNeeded(functionReference.getParameter(1));
            if (firstArg == null || secondArg == null) {
                return;
            }
            BinaryExpression newExpression = PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, firstArg.getText() + " ** " + secondArg.getText());
            PhpCodeEditUtil.replace((PsiElement)functionReference, (PsiElement)newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpPowCallCanBeReplacedWithOperatorInspection$PhpReplacePowCallWithOperatorQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpPowCallCanBeReplacedWithOperatorInspection$PhpReplacePowCallWithOperatorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

