/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle.namingConvention;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.CommonOptionPanes;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class PhpBaseNamingConvention
extends PhpInspection {
    public String m_regex = this.getDefaultRegex();
    public int m_minLength = this.getDefaultMinLength();
    public int m_maxLength = this.getDefaultMaxLength();
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    protected void checkElement(PhpNamedElement clazz, @NotNull ProblemsHolder holder) {
        PsiElement nameNodePsi;
        String name;
        if (holder == null) {
            PhpBaseNamingConvention.$$$reportNull$$$0(0);
        }
        if (this.isValid(name = clazz.getName())) {
            return;
        }
        ASTNode nameNode = clazz.getNameNode();
        if (nameNode != null && (nameNodePsi = nameNode.getPsi()) != null && nameNodePsi.getTextLength() != 0) {
            holder.registerProblem(nameNodePsi, this.buildErrorString(name), new LocalQuickFix[0]);
        }
    }

    protected abstract int getDefaultMaxLength();

    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    boolean isValid(String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (this.m_maxLength > 0 && length > this.m_maxLength) {
            return false;
        }
        Matcher matcher = this.m_regexPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)name, (long)1000L));
        return matcher.matches();
    }

    @NotNull
    @InspectionMessage
    protected final String buildErrorString(Object ... infos) {
        String name = (String)infos[0];
        int length = name.length();
        if (length < this.getMinLength()) {
            String string = PhpBundle.message("inspection.naming.convention.problem.descriptor.short", this.getElementDescription(), length, this.getMinLength());
            if (string == null) {
                PhpBaseNamingConvention.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (this.getMaxLength() > 0 && length > this.getMaxLength()) {
            String string = PhpBundle.message("inspection.naming.convention.problem.descriptor.long", this.getElementDescription(), length, this.getMaxLength());
            if (string == null) {
                PhpBaseNamingConvention.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = PhpBundle.message("inspection.naming.convention.element.descriptor.regexp", this.getElementDescription(), this.getRegex());
        if (string == null) {
            PhpBaseNamingConvention.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected abstract String getElementDescription();

    protected String getRegex() {
        return this.m_regex;
    }

    public int getMinLength() {
        return this.m_minLength;
    }

    public int getMaxLength() {
        return this.m_maxLength;
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            PhpBaseNamingConvention.$$$reportNull$$$0(4);
        }
        super.readSettings(node);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValueSet("m_regex", value -> {
            try {
                this.m_regexPattern = Pattern.compile(this.m_regex);
            }
            catch (PatternSyntaxException ignore) {
                this.m_regex = this.getDefaultRegex();
                this.m_regexPattern = Pattern.compile(this.m_regex);
            }
        });
        if (optionController == null) {
            PhpBaseNamingConvention.$$$reportNull$$$0(5);
        }
        return optionController;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = CommonOptionPanes.conventions((String)"m_minLength", (String)"m_maxLength", (String)"m_regex", (OptRegularComponent[])new OptRegularComponent[0]);
        if (optPane == null) {
            PhpBaseNamingConvention.$$$reportNull$$$0(6);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/namingConvention/PhpBaseNamingConvention";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/namingConvention/PhpBaseNamingConvention";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

