/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle.namingConvention;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.codeStyle.namingConvention.PhpBaseNamingConvention;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpConstantNamingConventionInspection
extends PhpBaseNamingConvention {
    private static final int DEFAULT_MIN_LENGTH = 5;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Z_\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 5;
    }

    @Override
    protected String getElementDescription() {
        return PhpBundle.message("inspection.naming.convention.element.description.constant", new Object[0]);
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpConstantNamingConventionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpConstant(Constant constant) {
                super.visitPhpConstant(constant);
                PhpConstantNamingConventionInspection.this.checkElement((PhpNamedElement)constant, holder);
            }

            public void visitPhpField(Field field) {
                super.visitPhpField(field);
                if (field.isConstant()) {
                    PhpConstantNamingConventionInspection.this.checkElement((PhpNamedElement)field, holder);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/namingConvention/PhpConstantNamingConventionInspection", "buildVisitor"));
    }
}

