/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition.field;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpInitialDfaBasedTypeStateAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDfaBasedFieldAnalyzerProcessor
extends PhpInitialDfaBasedTypeStateAnalyzer<PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState> {
    public PhpDfaBasedFieldAnalyzerProcessor(boolean reverseBinaryExpression) {
        super(reverseBinaryExpression);
    }

    @Override
    protected boolean sameVariableName(CharSequence name) {
        return this.myAnchor == null || name.equals(PhpDfaBasedFieldAnalyzerProcessor.computeFieldName((FieldReference)this.myAnchor));
    }

    @Override
    @NotNull
    protected final PhpConditionDFAnalyzer<PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState> createAnalyzer(boolean stopOnNegations) {
        return new PhpFieldDfaBaseStateConditionDFAnalyzer(this.myAnchor != null ? (FieldReference)this.myAnchor : null, this.myGlobal, stopOnNegations, this.myReverseBinaryExpression);
    }

    @Nullable
    public static String computeFieldName(FieldReference field) {
        String name;
        Variable variable = (Variable)ObjectUtils.tryCast((Object)field.getClassReference(), Variable.class);
        if (variable != null && StringUtil.isNotEmpty((String)(name = PhpDfaBasedFieldAnalyzerProcessor.computeFieldNameNodeText(field)))) {
            return variable.getName() + "." + name;
        }
        return null;
    }

    @Nullable
    public static String computeFieldNameNodeText(FieldReference field) {
        PsiElement nameNode;
        String name = field.getName();
        if (StringUtil.isEmpty((String)name) && (nameNode = PhpStateArgumentInfo.getVariableNameNode(field)) != null) {
            return nameNode.getText();
        }
        return name;
    }

    public static final class PhpFieldDfaBaseStateConditionDFAnalyzer
    extends PhpPreviousDfaBaseStateConditionDFAnalyzer {
        @Nullable
        private final FieldReference myFieldReference;

        public PhpFieldDfaBaseStateConditionDFAnalyzer(@Nullable FieldReference fieldReference, boolean global, boolean stopOnNegations, boolean reverseBinaryExpression) {
            super(global, stopOnNegations, reverseBinaryExpression);
            this.myFieldReference = fieldReference;
        }

        @Override
        @NotNull
        public PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState createState(PsiElement element, PhpDfaBasedTypeState state) {
            String fieldName = PhpDfaBasedFieldAnalyzerProcessor.computeFieldName((FieldReference)element);
            PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState phpVariableDfaState = fieldName != null ? new PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState((CharSequence)fieldName, state) : PhpFieldDfaBaseStateConditionDFAnalyzer.createUnknownState();
            if (phpVariableDfaState == null) {
                PhpFieldDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(0);
            }
            return phpVariableDfaState;
        }

        @Override
        protected boolean needToProcessElement(PsiElement elementToProcess) {
            return elementToProcess instanceof FieldReference && (this.myFieldReference == null || PhpPsiUtil.areElementsEquivalent(elementToProcess, (PsiElement)this.myFieldReference));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/field/PhpDfaBasedFieldAnalyzerProcessor$PhpFieldDfaBaseStateConditionDFAnalyzer", "createState"));
        }
    }
}

