/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.local;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedSymbolsFilterVisitor
extends PhpElementVisitor {
    @NotNull
    protected final BiConsumer<PsiElement, PsiElement> myConsumer;

    public PhpUnusedSymbolsFilterVisitor(@NotNull BiConsumer<PsiElement, PsiElement> consumer) {
        if (consumer == null) {
            PhpUnusedSymbolsFilterVisitor.$$$reportNull$$$0(0);
        }
        this.myConsumer = consumer;
    }

    public void visitPhpClass(PhpClass clazz) {
        PsiElement nameIdentifier = clazz.getNameIdentifier();
        if (nameIdentifier != null && PhpIndex.getInstance((Project)clazz.getProject()).getDirectSubclasses(clazz.getFQN()).isEmpty()) {
            this.myConsumer.accept((PsiElement)clazz, nameIdentifier);
        }
    }

    public void visitPhpMethod(Method method) {
        PsiElement nameIdentifier = method.getNameIdentifier();
        if (PhpUnusedSymbolsFilterVisitor.isValidClassMember((PhpClassMember)method, nameIdentifier)) {
            this.myConsumer.accept((PsiElement)method, nameIdentifier);
        }
    }

    public void visitPhpField(Field field) {
        PsiElement nameIdentifier = field.getNameIdentifier();
        if (PhpUnusedSymbolsFilterVisitor.isValidClassMember((PhpClassMember)field, nameIdentifier)) {
            Field mirrorField = PhpUnusedSymbolsFilterVisitor.getMirror(field);
            if (mirrorField != null) {
                this.myConsumer.accept((PsiElement)mirrorField, nameIdentifier);
            } else {
                this.myConsumer.accept((PsiElement)field, nameIdentifier);
            }
        }
    }

    public void visitPhpFunction(Function function) {
        if (!function.isClosure()) {
            this.myConsumer.accept((PsiElement)function, function.getNameIdentifier());
        }
    }

    public void visitPhpConstant(Constant constant) {
        this.myConsumer.accept((PsiElement)constant, constant.getNameIdentifier());
    }

    private static boolean isValidClassMember(@NotNull PhpClassMember classMember, PsiElement nameIdentifier) {
        if (classMember == null) {
            PhpUnusedSymbolsFilterVisitor.$$$reportNull$$$0(1);
        }
        return nameIdentifier != null && !classMember.getModifier().isPrivate() && PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)classMember, (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)PhpClassHierarchyUtils.FALSE_PROCESSOR);
    }

    @Nullable
    public static Field getMirror(@NotNull Field classMember) {
        Field firstMember;
        PhpClass phpClass;
        if (classMember == null) {
            PhpUnusedSymbolsFilterVisitor.$$$reportNull$$$0(2);
        }
        if ((phpClass = classMember.getContainingClass()) != null && !classMember.isConstant() && (firstMember = phpClass.findOwnFieldByName((CharSequence)classMember.getName(), false)) != classMember && firstMember instanceof PhpDocProperty) {
            return firstMember;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedSymbolsFilterVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidClassMember";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMirror";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

